package JIMSCore;
/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    Utility.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

PUBLIC METHODS

  public static String sAsBinary(long x) {
  public static String sAsBinary(float x) {
  public static String sAsBinary(double x) {
  public static String sAsBinaryPadded(long x, int padLen) {
  public static String sAsBinaryPadded(float x, int padLen) {
  public static String sAsBinaryPadded(double x, int padLen) {
  public static String sAsHex(long x) {
  public static String sAsHex(float x) {
  public static String sAsHex(double x) {
  public static String sAsHexPadded(long x, int padLen) {
  public static String sAsHexPadded(double x, int padLen) {
  public static String sAsHexPadded(float x, int padLen) {
  public static String sPad(String s, int n) {
  public static String sLeftPad(String s, int n, char c) {
  public static long IntegerLiteralToLong(String s) {
  public static double FloatingPointLiteralToDouble(String s) {
  public static float FloatingPointLiteralToFloat(String s) {
  public static String sRemoveChar(String s, char c) {
  public static Vector vLoadFileAsVector(String s) {
  public static String sProcessedDataString(String s) {
  public static int iSetBit(int iValue, int iBit, boolean bState) {
  public static boolean bBitSet(int iValue, int iBit, boolean bState) {
  public static int iHexStrToInt(String s) {

*/
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;
import java.util.Enumeration;

public class Utility {

  public static String sAsBinary(long x) {
	String s = "0";
	if (x != 0)
	  s = Long.toBinaryString(x);
	return s;
  }    

  public static String sAsBinary(float x) {
	int v = Float.floatToIntBits(x);
	return sAsBinary(v);
  }    

  public static String sAsBinary(double x) {
	long v = Double.doubleToLongBits(x);
	return sAsBinary(v);
  }    

  public static String sAsBinaryPadded(long x, int padLen) {
	return sLeftPad(sAsBinary(x), padLen, '0');
  }    

  public static String sAsBinaryPadded(float x, int padLen) {
	return sLeftPad(sAsBinary(x), padLen, '0');
  }    

  public static String sAsBinaryPadded(double x, int padLen) {
	return sLeftPad(sAsBinary(x), padLen, '0');
  }    

  public static String sAsHex(long x) {
	String s = "0";
	if (x != 0)
	  s = Long.toHexString(x);
	return s;
  }    

  public static String sAsHex(float x) {
	int v = Float.floatToIntBits(x);
	return sAsHex(v);
  }    

  public static String sAsHex(double x) {
	long v = Double.doubleToLongBits(x);
	return sAsHex(v);
  }    

  public static String sAsHexPadded(long x, int padLen) {
	return sLeftPad(sAsHex(x), padLen, '0');
  }    

  public static String sAsHexPadded(double x, int padLen) {
	return sLeftPad(sAsHex(x), padLen, '0');
  }    

  public static String sAsHexPadded(float x, int padLen) {
	return sLeftPad(sAsHex(x), padLen, '0');
  }    

  public static String sPad(String s, int n) {

	if (s.length() > n)
	  return s.substring(0, n);
	StringBuffer result = new StringBuffer(s);
	while (result.length() < n) {
	  result.append(" ");
	}
	return result.toString();

  }    

  public static String sLeftPad(String s, int n, char c) {
	if (s.length() > n) {
	  return s.substring(s.length() - n);
	}

	int i = n - s.length();
	StringBuffer sb = new StringBuffer();
	while (i > 0) {
	  sb.append(c);
	  i--;
	}
	sb.append(s);
	return sb.toString();

/*
  The following is an alternative implementation:

	String sResult = s;
	while (sResult.length() < n) {
	  sResult = c + sResult;
	}
	return sResult;
*/

  }    

  public static long IntegerLiteralToLong(String s) {
	long v = 0;
	s = s.toUpperCase();
	if (s.startsWith("0X"))
	  v = Long.parseLong(s.substring(2), 16);
	else
	  v = Long.parseLong(s, 10);
	return v;
  }    

  public static double FloatingPointLiteralToDouble(String s) {
	double v = 0;
	try {
	  v = Double.parseDouble(s);
	} catch (Exception e) {
	  System.out.println("Error converting '" + s + "' to double: " + e);
	}
	return v;
  }    

  public static float FloatingPointLiteralToFloat(String s) {
	float v = 0;
	try {
	  v = Float.parseFloat(s);
	} catch (Exception e) {
	  System.out.println("Error converting '" + s + "' to float: " + e);
	}
	return v;
  }    

  public static String sRemoveChar(String s, char c) {
	// Remove all occurrences of the character c from string s.

	StringBuffer sb = new StringBuffer(s);
	for (int i = sb.length()-1; i >= 0; i--) {
	  if (sb.charAt(i) == c) {
		sb.deleteCharAt(i);
	  }
	}
	return sb.toString();

/*
  The following is an alternative implementation:

	String sResult = s.substring(0);  // copy the work string
	int i = sResult.indexOf(c);
	while (i > 0) {
	  result = sResult.substring(0, i) + result.substring(i+1);
	  i = result.indexOf(c);
	}
	return sResult;
*/

  }    

  public static Vector vLoadFileAsVector(String sFilename) {
	// Load the contents of the specified file (sFilename)
	//   into a Vector of String objects.  Return null if
	//   there is any problem while reading the file.

	Vector vResult = null;

	BufferedReader br = null;
	try {
	  br = new BufferedReader(new FileReader(sFilename));
	} catch (Exception e) {
	  // Probably file not found exception.
	  return vResult;
	}

	vResult = new Vector();
	do {
	  try {
		String in = br.readLine();
		if (in == null)
		  break; // End of file reached
		vResult.add(in);
	  } catch (Exception e) {
		// Could be some I/O error, out of memory, etc.
		vResult = null;
		break;
	  }
	} while (true);

	try {
	  br.close();
	} catch (Exception e) {
	}

	return vResult;

  }  // end method vLoadFileAsVector(String)    

  public static int iSetBit(int iValue, int iBit, boolean bState) {
	// Set bit number iBit of integer iValue to bState.
	/*
	  iBit should 0 to 31

	  31 is the MSB (right side),
	  0 is the LSB (left side)
	*/

	int iResult = iValue;

	if ( (iBit < 0) || (iBit > 31) ) {
	  return iResult;
	}

	int iFlag = (1 << iBit);
	if (bState) {
	  // Set the bit
	  iResult = (iValue | iFlag);
	} else {
	  iFlag = ~iFlag;
	  iResult = (iValue & iFlag);
	}
	return iResult; 
  }  // end method iSetBit(int, int, boolean)    

  public static boolean bBitSet(int iValue, int iBit, boolean bState) {
	// Returns TRUE if bit number iBit is set to bState in integer iValue.
	// Otherwise, return FALSE

	boolean bResult = false;

	if ( (iBit < 0) || (iBit > 31) ) {
	  return bResult;
	}

	int iFlag = (1 << iBit);
	if (bState) {
	  bResult = ((iValue & iFlag) > 0);
	} else {
	  bResult = ((iValue & iFlag) == 0);
	}

	return bResult;
  }  // end method bBitSet(int, int, boolean);    

  public static int iHexStrToInt(String s) {
	long l = Long.parseLong(s, 16);
	int i = (int)(l & 0x00000000FFFFFFFFL);
	return i;
  }    

}