package JIMSCore;
/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    StateHistoryBuffer.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/
import java.util.Vector;
import java.util.Enumeration;

public class StateHistoryBuffer {

  private long lCycleIndex;
  private Vector vStateHistory;  // Vector of String objects

  private int iSize;

  public StateHistoryBuffer(long lCycleIndex) {
	vStateHistory = new Vector();
	this.lCycleIndex = lCycleIndex;

	iSize = 8; // == length("C " + lCycleIndex), approximate
  }    

  public void addStateValue(String s) {
	vStateHistory.add(s);

	iSize += s.length();  // BYTE_SIZE * number_of_bytes
  }    

  public Vector vGetStateHistory() {
	return vStateHistory;
  }    

  public long lGetCycleIndex() {
	return lCycleIndex;
  }    

  public void setCycleIndex(long lIndex) {
	lCycleIndex = lIndex;
  }    

  public int iGetSize() {
	return iSize;
	/*
	int iResult = 8;  // 8 == Byte size of Cycle Index
	Enumeration e = vStateHistory.elements();
	while (e.hasMoreElements()) {
	  String s = (String)e.nextElement();
	  iResult += 1 * s.length(); // BYTE_SIZE * number_of_bytes
	}
	return iResult;
	*/
  }    

  public String toString() {
	StringBuffer sb = new StringBuffer();
	sb.append("C " + lCycleIndex + "\n");
	Enumeration e = vStateHistory.elements();
	while (e.hasMoreElements()) {
	  String s = (String)e.nextElement();
	  sb.append(s + "\n");
	}
	return sb.toString();
  }    

}