package JIMSCore;

import java.io.*;

public class ModifiedSource
{
	public static boolean bEnabled = false;
	private static BufferedWriter modifiedSource;
	private static String sFilename = "_CODE.S";

	public static void setOutputFile(String sFilename)
	{
		ModifiedSource.sFilename = sFilename;
	}    

	public static void start()
	{
		if (sFilename == null)   
			return;
		try
		{
			// Create the CODE.S file -- if it exists, overwrite its contents
			modifiedSource = new BufferedWriter(new FileWriter(sFilename));
			// append("\t.set noat");
			modifiedSource.close();
		}
		catch (Exception e)
		{
			System.err.println("Error creating modified code file: " + e);
			modifiedSource = null;
		}
	}    

	public static void append(String s)
	{
		if (sFilename == null)   
			return;
		if (modifiedSource != null)
		{
			try
			{
				modifiedSource = new BufferedWriter(new FileWriter(sFilename, true));
				modifiedSource.write(s + "\n");
				modifiedSource.close();
			}
			catch (Exception e)
			{
				System.err.println("Error writing to modified code file: " + e);
			}
		}
	}    
}