package JIMSCore;

/*

TITLE:   InstructionDecodeBuffer.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/

public class InstructionDecodeBuffer {

  public int rawInstruction;

  // Java byte = 8 bit
  // Java int = 32 bit

  // opcode = 6 bits
  // rd,rs,rt,shamt = 5 bits
  // funct = 6 bits
  // target,offset,imm = 16 bits
  // ft,fs,fd = 5 bits

  public byte opcode;  // 31:26
  public byte rd;  // 25:21
  public byte rs;
  public byte rt;
  public byte shamt; // 10:6
  public byte funct; // 5:0
  public int target;
  public int offset;
  public int imm;  // 15:0
  public int fcn2;
  public byte ft;
  public byte fs;
  public byte fd;

}