package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    MainMemory.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/
import java.util.Vector;

class GammaMemoryBucket {

  public byte[] cell;
  public byte[] modified;

  public GammaMemoryBucket() {
	reset();
  }    

  public void reset() {
	cell = new byte[MainMemory.NUM_BUCKETS];
	modified = new byte[MainMemory.NUM_BUCKETS];
	for (int i = 0; i < modified.length; i++)
	  cell[i] = 0;
  }    

  public void storeByte(int a1, byte value) {
	cell[a1] = (byte)value;
	if (modified[a1] < Byte.MAX_VALUE)
	  modified[a1]++;
  }    

  public byte loadByte(int a1) {
	return cell[a1];
  }    

  public StringBuffer sbGetMemoryDump(String s) {   
	StringBuffer sbResult = new StringBuffer();
	if (cell != null) {
	  for (int i = 0; i < cell.length; i++) {
		if (modified[i] > 0) {
		  sbResult.append(s + Utility.sAsHexPadded(i,2) + " " + Utility.sAsHexPadded(cell[i],2) + "\n");
		}
	  }
	}
	return sbResult;
  }    

}