package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    Coprocessor1.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/

/**
  * This is the Coprocessor1 class.
  *
  * @author Steve Lewis
*/
public class Coprocessor1 {

  // Floating Point Registers

  public static final String REG_ID[][] =
	{
	  {"$0",  "$FP0", "$F0", "$D0"},
	  {"$1",  "$FP1", "$F1"},
	  {"$2",  "$FP2", "$F2", "$D1"},
	  {"$3",  "$FP3", "$F3"},
	  {"$4",  "$FP4", "$F4", "$D2"},
	  {"$5",  "$FP5", "$F5"},
	  {"$6",  "$FP6", "$F6", "$D3"},
	  {"$7",  "$FP7", "$F7"},
	  {"$8",  "$FP8", "$F8", "$D4"},
	  {"$9",  "$FP9", "$F9"},
	  {"$10", "$FP10", "$F10", "$D5"},
	  {"$11", "$FP11", "$F11"},
	  {"$12", "$FP12", "$F12", "$D6"},
	  {"$13", "$FP13", "$F13"},
	  {"$14", "$FP14", "$F14", "$D7"},
	  {"$15", "$FP15", "$F15"},
	  {"$16", "$FP16", "$F16", "$D8"},
	  {"$17", "$FP17", "$F17"},
	  {"$18", "$FP18", "$F18", "$D9"},
	  {"$19", "$FP19", "$F19"},
	  {"$20", "$FP20", "$F20", "$D10"},
	  {"$21", "$FP21", "$F21"},
	  {"$22", "$FP22", "$F22", "$D11"},
	  {"$23", "$FP23", "$F23"},
	  {"$24", "$FP24", "$F24", "$D12"},
	  {"$25", "$FP25", "$F25"},
	  {"$26", "$FP26", "$F26", "$D13"},
	  {"$27", "$FP27", "$F27"},
	  {"$28", "$FP28", "$F28", "$D14"},
	  {"$29", "$FP29", "$F29"},
	  {"$30", "$FP30", "$F30", "$D15"},
	  {"$31", "$FP31", "$F31"},
	  {"$32", "$FCR0"},
	  {"$33", "$FCR31"}
	};

  public static final int NUM_REGS = 34;

  public static final int R_F0 = 0;  // D0
  public static final int R_F1 = 1;
  public static final int R_F2 = 2;  // D1
  public static final int R_F3 = 3;
  public static final int R_F4 = 4;  // D2
  public static final int R_F5 = 5;
  public static final int R_F6 = 6;  // D3
  public static final int R_F7 = 7;
  public static final int R_F8 = 8;  // D4
  public static final int R_F9 = 9;
  public static final int R_F10 = 10;  // D5
  public static final int R_F11 = 11;
  public static final int R_F12 = 12;  // D6
  public static final int R_F13 = 13;
  public static final int R_F14 = 14;  // D7
  public static final int R_F15 = 15;
  public static final int R_F16 = 16;  // D8
  public static final int R_F17 = 17;
  public static final int R_F18 = 18;  // D9
  public static final int R_F19 = 19;
  public static final int R_F20 = 20;  // D10
  public static final int R_F21 = 21;
  public static final int R_F22 = 22;  // D11
  public static final int R_F23 = 23;
  public static final int R_F24 = 24;  // D12
  public static final int R_F25 = 25;
  public static final int R_F26 = 26;  // D13
  public static final int R_F27 = 27;
  public static final int R_F28 = 28;  // D14
  public static final int R_F29 = 29;
  public static final int R_F30 = 30;  // D15
  public static final int R_F31 = 31;

  public static final int R_FCR0 = 32;
  public static final int R_FCR1 = 33;

  //private int[] iaReg;
  public int[] iaReg;

  public static final int CONDITION_BIT = 23;

  /*

  FCR31

  p162: FP Implementation/Revision Register, control register 0 (mnemonic FCR0)
	Accessed by mtc1, mfc1
  3          2          1
  10987654321098765432109876543210
  ****************Imp     Rev
	Imp value
	0 = No FPA hardware
	1 = R2360
	2 = R2010 (R2000 FPA chip)


  p159: Coprocessor 1, control register 31 (mnemonic FCR31)
	Accessed by mtc1, mfc1

  3          2          1
  10987654321098765432109876543210
  FCC7-1|FC*****UCause|Ena|Flag|RM
		 S      n
				I

  FCC7-1: 31..25
	Condition bits, set by FP compare instructions and tested by
	conditional branches.

  FS: 24
	Flush to 0

  C: 23

  UnImp: 17
	Following an FPA trap, this bit will be set to mark an
	unimplemented instruction exception.

  Cause: 16-12
	Cause/Enables/Flags
	  Bit 4: Invalid operation
	  Bit 3: Division by zero
	  Bit 2: Overflow
	  Bit 1: Underflow
	  Bit 0: Inexact

	CAUSE = bits are set according to the result of the last completed FP instruction
	FLAG = bits are sticky versions of the FCR31(Cause) bits,
	  logical "or" of the exceptional results.
	ENABLE = if one of these bits is set when an operation produces
	  an exceptional result that would have set the
	  corresponding FCR31(Cause) bit, then the CPU will trap so that
	  software can do whatever is necessary to report the
	  exceptional result.

  Enable: 11-7

  Flag: 6-2

  RM: 1-0
	Rounding mode
	0 = RN round to nearest
	1 = RZ round toward zero
	2 = RP round up, or towards +inf
	3 = RN round down, or towards -inf

  */

  public Coprocessor1() {

	reset();

  }    

  public void reset() {

	iaReg = new int[NUM_REGS];

	// It is assumed, by the nature of Java, that the
	//   values in the register array are all initialized
	//   to zero.

	iaReg[R_FCR0] = 0x00000201;
	// Imp == R2010 (R2000 FPA chip)
	// Rev = 1

  }  // end method reset()    

  public int iGetReg(int iReg) {
	return iaReg[iReg];
  }    

  public void setReg(int iReg, int iValue) {
	iaReg[iReg] = iValue;
  }    

  public static int iRegLiteralToID(String s) {

	// Returns -1 if the register literal is invalid,
	//   otherwise returns the index of the specified register literal.

	s = s.toUpperCase().trim();
	for (int i = 0; i < Coprocessor1.REG_ID.length; i++) {
	  for (int x = 0; x < Coprocessor1.REG_ID[i].length; x++) {
		if (s.equals(Coprocessor1.REG_ID[i][x]))
		  return i;
	  }
	}
	return -1;

  }  // end method bRegLiteralToID(String)    

}