package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandStatus.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: STATUS

InvalidCommandUseException Messages:
  <none>

Command Buffer Results:
  * STATUS JAVA_MEM_TOTAL x
  * STATUS JAVA_MEM_FREE x
  * STATUS NUM_CHECKPOINTS x
  * STATUS NUM_STATE_CHANGES x
  * STATUS NEXT_CHECKPOINT_SIZE_EST x
  * STATUS STATE_HISTORY_SIZE_EST x
  * STATUS DONE

*/
import java.util.StringTokenizer;

/**
  * This is the CommandStatus class.
  *
  * @author Steve Lewis
*/
public class CommandStatus extends Command {

  private Simulator simulator;

  public CommandStatus(StringTokenizer st, Simulator simulator) {
	super(st);
	this.simulator = simulator;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	System.gc();
	crb.append(RESPONSE + " STATUS JAVA_MEM_TOTAL " + Runtime.getRuntime().totalMemory() );
	crb.append(RESPONSE + " STATUS JAVA_MEM_FREE " + Runtime.getRuntime().freeMemory() );
	crb.append(RESPONSE + " STATUS NUM_CHECKPOINTS " + simulator.iGetNumCheckpoints());
	crb.append(RESPONSE + " STATUS NUM_STATE_CHANGES " + simulator.iGetNumStateChanges());
	crb.append(RESPONSE + " STATUS NEXT_CHECKPOINT_SIZE_EST " + simulator.iGetNextCheckpointByteSize());
	crb.append(RESPONSE + " STATUS STATE_HISTORY_SIZE_EST " + simulator.iGetStateHistoryByteSize());
	crb.append(RESPONSE + " STATUS CURRENT_CYCLE " + simulator.lGetCycleIndex());
	crb.append(RESPONSE + " STATUS " + DONE);

  }        

}