package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandReset.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: RESET

InvalidCommandUseException Messages:
  <none>

Command Buffer Results:
  * RESET OK
  * RESET ERR ERR_UNKNOWN_ERROR errorMsg
  * RESET DONE

*/

/**
  * This is the CommandReset class.
  *
  * @author Steve Lewis
*/
public class CommandReset extends Command {

  public static final String ERR_UNKNOWN_ERROR = "ERR_UNKNOWN_ERROR";

  private CommandProcessor commandProcessor;

  public CommandReset(CommandProcessor commandProcessor) {
	this.commandProcessor = commandProcessor;
  }    

  public void execute(CommandResultBuffer erb) throws InvalidCommandUseException {

	String s = RESPONSE + " RESET OK";
	try {
	  commandProcessor.initializeSimulator();
	} catch (Exception e) {
	  s = RESPONSE + " RESET ERR " + ERR_UNKNOWN_ERROR + " " + e;
	}

	erb.append(s);
	erb.append(RESPONSE + " RESET " + DONE);

  }  // end method execute(CommandResultBuffer)    

}