package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandRemove.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: REMOVE ( B* | G* ) index

InvalidCommandUseException Messages:
  Invalid breakpoint index.
  Invalid guard index.
  Incorrect use of REMOVE command.

Command Buffer Results:
  * REMOVE DONE

*/
import java.util.StringTokenizer;

/**
  * This is the CommandRemove class.
  *
  * @author Steve Lewis
*/
public class CommandRemove extends Command {

  private Simulator simulator;

  public CommandRemove(StringTokenizer st, Simulator simulator) {
	super(st);
	this.simulator = simulator;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	String s = nextToken();

	if (s.startsWith("B")) {  // BREAKPOINT keyword

	  s = nextToken();  // s == should be the index to remove

	  BreakpointList breakpointList = simulator.getBreakpointList();

	  int i = 1;
	  try {
		i = breakpointList.iRemoveBreakpoint(iGetNumber(s));
	  } catch (Exception e) {

	  }

	  if (i != BreakpointList.SUCCESS)
		throw new InvalidCommandUseException("Invalid breakpoint index.");

	} else if (s.startsWith("G")) {  // GUARD keyword

	  s = nextToken();  // s == should be the index to remove

	  GuardList guardList = simulator.getGuardList();

	  int i = 1;
	  try {
		i = guardList.iRemoveGuard(iGetNumber(s));
	  } catch (Exception e) {

	  }

	  if (i != GuardList.SUCCESS)
		throw new InvalidCommandUseException("Invalid guard index.");

	} else {

	  throw new InvalidCommandUseException("Incorrect use of REMOVE command.");

	}

	crb.append(RESPONSE + " REMOVE " + DONE);

  }  // end method execute(CommandResultBuffer)    

}