package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandOutput.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: OUTPUT

InvalidCommandUseException Messages:
  <none>

Command Buffer Results:
  * OUTPUT OK
  * OUTPUT ERR ERR_NOTHING_TO_OUTPUT
  * OUTPUT ERR ERR_CRITICAL
  * OUTPUT DONE

*/
import java.util.StringTokenizer;

/**
  * This is the CommandOutput class.
  *
  * @author Steve Lewis
*/
public class CommandOutput extends Command {

  public static final String ERR_NOTHING_TO_OUTPUT = "ERR_NOTHING_TO_OUTPUT";
  public static final String ERR_CRITICAL = "ERR_CRITICAL";

  private Simulator simulator;
  private StringBuffer sbOutput;

  public CommandOutput(StringTokenizer st, Simulator simulator) {
	super(st);
	this.simulator = simulator;
	sbOutput = null;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	StringBuffer sb = new StringBuffer();
	int i = simulator.iReadOutput(sb);

	switch (i) {

	  case 0:
		// SUCCESS: Return the initialized string buffer.
		sbOutput = sb;
		crb.append(RESPONSE + " OUTPUT OK");
		break;

	  case -1:
		// ERR_NO_OUTPUT_EXPECTED
		crb.append(RESPONSE + " OUTPUT ERR " + ERR_NOTHING_TO_OUTPUT);
		break;

	  default:
		// -2 == ERR_OUTPUT_FORMAT
		// -3 == ERR_NO_STRING_BUFFER
		crb.append(RESPONSE + " OUTPUT ERR " + ERR_CRITICAL);

	}

	crb.append(RESPONSE + " OUTPUT " + DONE);

  }  // end method execute(CommandResultBuffer)    

  public StringBuffer sbGetOutput() {
	// Returns null if no output was read, or if the buffer
	//   was not initialized.
	return sbOutput;
  }    

}