package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandLoad.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: LOAD (S filename) | (T x1 x2 x3 x4 [Ly]) | (D x1 ... xN)

InvalidCommandUseException Messages:
  <none>

Command Buffer Results:
  * LOAD OK
  * LOAD ERR ERR_INVALID_LIT
  * LOAD ERR ERR_CRITICAL
  * LOAD DONE

*/

/**
  * This is the CommandLoad class.
  *
  * @author Steve Lewis
*/
public class CommandLoad extends Command {

  public static final String ERR_INVALID_LIT = "ERR_INVALID_LIT";
  public static final String ERR_CRITICAL = "ERR_CRITICAL";

  private Simulator simulator;
  private String sParameters;

  public CommandLoad(String sParameters, Simulator simulator) {
	this.sParameters = sParameters;
	this.simulator = simulator;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	switch (simulator.iLoadCodeString(sParameters)) {
	  case 0:
		// 0 = SUCCESS
		crb.append(RESPONSE + " LOAD OK");
		break;

	  case -1:
		// -1 = INVALID_LINE_IDENTIFIER_TOKEN
		crb.append(RESPONSE + " LOAD ERR " + ERR_INVALID_LIT);
		break;

	  case -2:
		// -2 = CRITICAL_ERROR  (some exception, such as output of memory)
		crb.append(RESPONSE + " LOAD ERR " + ERR_CRITICAL);
		break;
	}

	crb.append(RESPONSE + " LOAD " + DONE);

  }  // end method execute()    

}