package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandList.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: LIST ( B* | G* )

InvalidCommandUseException Messages:
  Incorrect use of LIST command.

Command Buffer Results:
  * LIST BREAKPOINT NONE
  * LIST BREAKPOINT index (address,8)
  * LIST GUARD NONE
  * LIST GUARD index guardExpression
  * LIST DONE

*/
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.Enumeration;

/**
  * This is the CommandList class.
  *
  * @author Steve Lewis
*/
public class CommandList extends Command {

  private Simulator simulator;

  public CommandList(StringTokenizer st, Simulator simulator) {
	super(st);
	this.simulator = simulator;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	String s = nextToken();              

	if (s.startsWith("B")) {  // BREAKPOINT keyword

	  BreakpointList breakpointList = simulator.getBreakpointList();

	  int ia[] = breakpointList.iaGetBreakpoints();
	  if (ia == null) {
		crb.append(RESPONSE + " LIST BREAKPOINT NONE");
	  } else {
		for (int i = 0; i < ia.length; i++) {
		  crb.append(RESPONSE + " LIST BREAKPOINT " + i + " " + Utility.sAsHexPadded(ia[i], 8));
		}
	  }

	} else if (s.startsWith("G")) {  // GUARD keyword

	  Vector v = simulator.getGuardList().vGetGuards();

	  Enumeration e = v.elements();
	  if (!e.hasMoreElements()) {
		crb.append(RESPONSE + " LIST GUARD NONE");
	  } else {
		int i = 0;
		while (e.hasMoreElements()) {
		  GuardExpression g = (GuardExpression)e.nextElement();
		  crb.append(RESPONSE + " LIST GUARD " + i + " " + g);
		  i++;
		}
	  }

	} else {

	  throw new InvalidCommandUseException("Incorrect use of LIST command.");

	}

	crb.append(RESPONSE + " LIST " + DONE);

  }    

}