package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandInput.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: INPUT "string"

InvalidCommandUseException Messages:
  Invalid format of input or unexpected error.

Command Buffer Results:
  * INPUT ERR ERR_NO_INPUT_EXPECTED
  * INPUT ERR ERR_BAD_INPUT_FORMAT
  * INPUT DONE

*/
import java.util.StringTokenizer;

/**
  * This is the CommandInput class.
  *
  * @author Steve Lewis
*/
public class CommandInput extends Command {

  public static final String ERR_NO_INPUT_EXPECTED = "ERR_NO_INPUT_EXPECTED";
  public static final String ERR_BAD_INPUT_FORMAT = "ERR_BAD_INPUT_FORMAT";

  private Simulator simulator;
  private String sParameters;  // command parameters string

  public CommandInput(StringTokenizer st, String sParameters, Simulator simulator) {
	super(st);
	this.sParameters = sParameters;
	this.simulator = simulator;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	try {

	  // Remove double quotes and copy the parameter input string
	  String sInput = sParameters.substring(1, sParameters.length()-1);

	  int i = simulator.iWriteInput(sInput);
	  switch (i) {
		case 0:
		  // Successful, no error.
		  break;

		case -1:
		  // ERR_NO_INPUT_EXPECTED (input discarded)
		  crb.append(RESPONSE + " INPUT ERR " + ERR_NO_INPUT_EXPECTED);
		  break;

		case -2:
		  // ERR_INPUT_FORMAT
		  crb.append(RESPONSE + " INPUT ERR " + ERR_BAD_INPUT_FORMAT);
		  break;
	  }

	} catch (Exception e) {
	  throw new InvalidCommandUseException("Invalid format of input or unexpected error.");
	}

	crb.append(RESPONSE + " INPUT " + DONE);
  }    

}