package JIMSCore;

/*

TITLE:   CommandHistory.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: HISTORY (C* | V* | W*)

InvalidCommandUseException Messages:
  You must specify CLEAR, VIEW, or WRITE.

Command Buffer Results:
  * HISTORY OK
  * HISTORY ERR ERR_NO_CLEAR
  * HISTORY ERR ERR_HISTORY_LOG
  * HISTORY ERR ERR_HISTORY_WRITE
  * HISTORY DONE

*/
import java.util.StringTokenizer;
import java.util.Vector;

/**
  * This is the CommandHistory class.
  *
  * @author Steve Lewis
*/
public class CommandHistory extends Command {

  public static final String ERR_NO_CLEAR = "ERR_NO_CLEAR";
  public static final String ERR_HISTORY_LOG = "ERR_HISTORY_LOG";
  public static final String ERR_HISTORY_WRITE = "ERR_HISTORY_WRITE";

  private StringBuffer sbHistoryLog;
  private Simulator simulator;

  public CommandHistory(StringTokenizer st, Simulator simulator) {
	super(st);
	this.simulator = simulator;
  }    

  public StringBuffer sbGetHistoryLog() {
	return sbHistoryLog;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	String s = nextToken();

	String sMessage = RESPONSE + " HISTORY OK";

	if (s.startsWith("V")) {  // VIEW keyword

	  try {
		sbHistoryLog = simulator.sbGetHistoryLog();
	  } catch (Exception e) {
		sMessage = RESPONSE + " HISTORY ERR " + ERR_HISTORY_LOG;
	  }

	} else if (s.startsWith("C")) {  // CLEAR keyword

	  try {

		Vector vStateHistory = simulator.vGetStateHistory();
		Vector vCheckpoint = simulator.vGetCheckpoint();

		vStateHistory.clear();
		vCheckpoint.clear();

	  } catch (Exception e) {
		sMessage = RESPONSE + " HISTORY ERR " + ERR_NO_CLEAR;
	  }

	} else if (s.startsWith("W")) {  // WRITE keyword

	  try {
		simulator.writeHistoryLog("_HISTORY");
	  } catch (Exception e) {
		sMessage = RESPONSE + " HISTORY ERR " + ERR_HISTORY_WRITE;
	  }

	} else {
  
	  throw new InvalidCommandUseException("You must specify CLEAR, VIEW, or WRITE.");

	}

	crb.append(sMessage);
	crb.append(RESPONSE + " HISTORY " + DONE);

  }    

}