package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandHelp.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: HELP

InvalidCommandUseException Messages:
  <none>

Command Buffer Results:
  * HELP command
  * HELP DONE

*/

/**
  * This is the CommandHelp class.
  *
  * @author Steve Lewis
*/
public class CommandHelp extends Command {

  public CommandHelp() {
	super();
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	crb.append(RESPONSE + " HELP ADD ((B* address) | (G* expression))");
	crb.append(RESPONSE + " HELP EXIT");
	crb.append(RESPONSE + " HELP CHECKPOINT");
	crb.append(RESPONSE + " HELP GET (M* [range|value]) | (R* (GPR|CP0|CP1) [range|value])");
	crb.append(RESPONSE + " HELP HELP");
	crb.append(RESPONSE + " HELP LIST (BREAKPOINT | GUARD)");
	crb.append(RESPONSE + " HELP LOAD (S filename) | (T x1 x2 ... xN Ly) | (D x1 x2 ... xN)");
	crb.append(RESPONSE + " HELP REMOVE (BREAKPOINT | GUARD) index");
	crb.append(RESPONSE + " HELP RESET");
	crb.append(RESPONSE + " HELP RUN");
	crb.append(RESPONSE + " HELP SET (MEMORY | REGISTER) (range | x) value");
	crb.append(RESPONSE + " HELP STEP n");
	crb.append(RESPONSE + " HELP UNDO n");
	crb.append(RESPONSE + " HELP HISTORY (VIEW | CLEAR | WRITE)");
	crb.append(RESPONSE + " HELP STATUS");
	crb.append(RESPONSE + " HELP INPUT \"string\"");
	crb.append(RESPONSE + " HELP OUTPUT");

	crb.append(RESPONSE + " HELP " + DONE);

  }  // end method execute(CommandResultBuffer)    

}