package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandExit.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: EXIT

InvalidCommandUseException Messages:
  Error deallocating simulator.

Command Buffer Results:
  * EXIT DONE
   
*/

/**
  * This is the CommandExit class.
  *
  * @author Steve Lewis
*/
public class CommandExit extends Command {

  public CommandExit() {
	super();
  }    

  private CommandProcessor commandProcessor;

  public CommandExit(CommandProcessor commandProcessor) {
	this.commandProcessor = commandProcessor;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	try {
	  commandProcessor.terminateSimulator();
	} catch (Exception e) {
	  throw new InvalidCommandUseException("Error deallocating simulator.");
	}
	crb.append(RESPONSE + " EXIT " + DONE);

  }    

}