package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandCheckpoint.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

Command: CHECKPOINT

InvalidCommandUseException Messages:
  <none>

Command Buffer Results:
  * CHECKPOINT DONE

*/
import java.util.StringTokenizer;

/**
  * This is the CommandCheckpoint class.
  *
  * @author Steve Lewis
*/
public class CommandCheckpoint extends Command {

  private Simulator simulator;

  public CommandCheckpoint(Simulator simulator) {
	this.simulator = simulator;
  }    

  public void execute(CommandResultBuffer crb) throws InvalidCommandUseException {

	simulator.makeCheckpoint();
	crb.append(RESPONSE + " CHECKPOINT " + DONE);

  }  // end method execute()    

}