package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CheckpointBuffer.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/
import java.util.Vector;
import java.util.Enumeration;

/**
  * This is the CheckpointBuffer class.
  *
  * @author Steve Lewis
*/
public class CheckpointBuffer {

  private long lCycleIndex;
  private Vector vStateRecord;  // Vector of String objects

  private int iSize;

  public CheckpointBuffer(long lCycleIndex) {
	vStateRecord = new Vector();
	this.lCycleIndex = lCycleIndex;

	iSize = 8;
  }    

  public void addStateValue(String s) {
	vStateRecord.add(s);

	iSize += 1 * s.length();  // BYTE_SIZE * number_of_bytes
  }    

  public Vector vGetStateRecord() {
	return vStateRecord;
  }    

  public long lGetCycleIndex() {
	return lCycleIndex;
  }    

  public int iGetSize() {
	return iSize;
  }    

  public String toString() {
	StringBuffer sb = new StringBuffer();
	sb.append("CP " + lCycleIndex + "\n");
	Enumeration e = vStateRecord.elements();
	while (e.hasMoreElements()) {
	  String s = (String)e.nextElement();
	  sb.append(s + "\n");
	}
	return sb.toString();
  }    


}