# CDA3101 - Spring 2000
# Example program
#
# By Dave Small
#
# Description:
#
#	This is a fully functioning implementation of the program
#	discussed in lecture on Wednesday October 6.  The original
#	C/C++ program looked something like:
#
#		const size = 16;
#
#		void main( void )
#		{
#		  int A[size] = { 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15 };
#
#		  for( i = 0; i != size ; i++ )
#		    A[i] = A[i] + 0x1000fff0;
#		}
#
#	We discussed how to transform this into an equivalent C program
#	using goto statements, so that we could then convert it into
#	assembly code.  If you were writing this, it would be a good
#	idea to show the modified program here!
#
# Assumptions:
#
#	This program assumes that int's are 32-bits long.
#
# Register usage:
#
#	t0: CEA = Current Element Address = &A[i] = address of i-th element
#	t1: i
#	t2: size
#	t3: 0x1000fff0 (constant)
#	t4: A[i]
#

#--------------------------------------------------------------------
# The code segment
#--------------------------------------------------------------------

	.text
	.globl	main

	# initialize program variables

main:	li	$t2, 16		# size = 16

	# initialize local variables
	
	la	$t0, A		# CEA = &A[0]
	li	$t3, 0x1000fff0	# 0x1000fff0 (constant)
	li	$t1, 0		# i = 0
	
	# sum all the array elements

loop:	beq	$t1, $t2, pool	# if ( i == size ) exit loop
	lw	$t4, 0($t0)	#   A[i] = MEM[ CEA ]
	add	$t4, $t4, $t3	#   A[i] = A[i] + 0x1000fff0
	sw	$t4, 0($t0)	#   MEM[ CEA ] = A[i]
	addi	$t1, $t1, 1	#   i++
	addi	$t0, $t0, 4	#   CEA = CEA + 4
	b	loop		# continue looping
pool:

	# terminate program

	li	$v0, 10		# return control...
	syscall			# to SPIM

#-------------------------------------------------------------------
# The data segment
#-------------------------------------------------------------------

	.data
A:	.word	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
