package JIMSwingGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import JIMSCore.*;

/**
  * This is the MultistepForwardDialog class.
  *
  * @author Fred Williams
*/
class MultistepForwardDialog extends JDialog implements ActionListener
{
	public MultistepForwardDialog(Frame frame, CommandProcessor cp)
	{
		super(frame, "Multiple step forward", true);
		returnValue = 0;
		commandProcessor = cp;

		JLabel valueLabel = new JLabel("Number of steps: ");
		value = new JTextField();

		JPanel labelsPanel = new JPanel();
		labelsPanel.setLayout(new BoxLayout(labelsPanel, BoxLayout.X_AXIS));
		labelsPanel.setBorder(BorderFactory.createEmptyBorder(0,0,5,0));
		labelsPanel.add(valueLabel);
		labelsPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		labelsPanel.add(value);

		stepButton = new JButton("Step");
		stepButton.setDefaultCapable(true);
		getRootPane().setDefaultButton(stepButton);
		stepButton.addActionListener(this);

		cancelButton = new JButton("Cancel");
		cancelButton.setMnemonic(KeyEvent.VK_C);
		cancelButton.addActionListener(this);

		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.setBorder(BorderFactory.createEmptyBorder(10,5,10,5)); 
		buttonPanel.add(stepButton);
		buttonPanel.add(Box.createRigidArea(new Dimension(5, 10))); 
		buttonPanel.add(cancelButton);

		JPanel contentPane = new JPanel();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		contentPane.setBorder(BorderFactory.createEmptyBorder(12,12,11,11));
		contentPane.add(labelsPanel);
		contentPane.add(buttonPanel);

		setContentPane(contentPane);
		setResizable(false);
		pack();
		setLocation(new Point(frame.getX() + ((frame.getWidth()-this.getWidth()) / 2), frame.getY() + ((frame.getHeight()-this.getHeight()) / 2)));
		setVisible(true);
	}

	public void actionPerformed(ActionEvent ae)
	{
		Object source = ae.getSource();
		if (source == stepButton)
		{
			try
			{
				returnValue = Integer.parseInt(value.getText());
				dispose();
			}
			catch (NumberFormatException nfe)
			{
				JOptionPane.showMessageDialog(this, "Invalid step value", "Error", JOptionPane.ERROR_MESSAGE);
			}
		}
		if (source == cancelButton)
		{
			dispose();
		}
	}

	public int getReturnValue()
	{
		return returnValue;
	}

	private CommandProcessor commandProcessor;
	private JTextField value;
	private JButton stepButton;
	private JButton cancelButton;
	private int returnValue;
}
