package JIMSwingGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import JIMSCore.*;

/**
  * This is the InputDialog class.
  *
  * @author Fred Williams
*/
class InputDialog extends JDialog implements ActionListener
{
	private CommandProcessor commandProcessor;
	private JPanel contentPane;
	private JPanel intermediatePane;
	private JTextField value;
	private JButton accept;
	private JButton cancel;
	private String returnValue;

	public InputDialog(Frame frame, CommandProcessor cp)
	{
		super(frame, "Console input", true);
		returnValue = null;
		commandProcessor = cp;
		JLabel valueLabel = new JLabel("Input: ");
		value = new JTextField();
		accept = new JButton("Apply");
		accept.setMnemonic(KeyEvent.VK_A);
		accept.setDefaultCapable(true);
		getRootPane().setDefaultButton(accept);
		accept.addActionListener(this);
		cancel = new JButton("Cancel");
		cancel.setMnemonic(KeyEvent.VK_C);
		cancel.addActionListener(this);

		intermediatePane = new JPanel();
		intermediatePane.setLayout(new GridLayout(0,2,5,10));
		intermediatePane.add(valueLabel);
		intermediatePane.add(value);
		intermediatePane.add(accept);
		intermediatePane.add(cancel);

		contentPane = new JPanel();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(intermediatePane, BorderLayout.CENTER);
		contentPane.add(new JPanel(), BorderLayout.NORTH);
		contentPane.add(new JPanel(), BorderLayout.SOUTH);
		contentPane.add(new JPanel(), BorderLayout.EAST);
		contentPane.add(new JPanel(), BorderLayout.WEST);

		setContentPane(contentPane);
		setResizable(false);
		pack();
		setLocation(new Point(frame.getX() + ((frame.getWidth()-this.getWidth()) / 2), frame.getY() + ((frame.getHeight()-this.getHeight()) / 2)));
		setVisible(true);
	}

	public void actionPerformed(ActionEvent ae)
	{
		if (ae.getSource() == accept)
		{
			CommandResultBuffer crb = commandProcessor.processCommand("INPUT \"" + value.getText() + "\"");
			returnValue = crb.sGetNextResponse();
			dispose();
		}
		if (ae.getSource() == cancel)
		{
			dispose();
		}
	}

	public String getReturnValue()
	{
		return returnValue;
	}
	
	public String getText()
	{
		return value.getText();
	}
}
