package JIMSwingGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import JIMSCore.*;

/**
  * A class representing the dialog for editing breakpoints.
  *
  * @author Fred Williams
*/
class BreakpointEditDialog extends JDialog implements ActionListener
{
	public BreakpointEditDialog(Frame frame, CommandProcessor cp)
	{
		super(frame, "Breakpoints", true);
		commandProcessor = cp;
		breakpoints = new Vector();
		breakpointList = new JList();
		breakpointList.setSelectionModel(new SourceListSelectionModel());
		breakpointList.setVisibleRowCount(8);
		JScrollPane listPane = new JScrollPane(breakpointList, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		listPane.getViewport().setScrollMode(JViewport.SIMPLE_SCROLL_MODE);

		addButton = new JButton("Add");
		addButton.setDefaultCapable(true);
		getRootPane().setDefaultButton(addButton);
		addButton.addActionListener(this);

		remove = new JButton("Remove");
		remove.setMnemonic(KeyEvent.VK_R);
		remove.addActionListener(this);

		closeButton = new JButton("Close");
		closeButton.setMnemonic(KeyEvent.VK_C);
		closeButton.addActionListener(this);

		JLabel addLabel = new JLabel("Address to add: ");
		addField = new JTextField();
		JLabel removeLabel = new JLabel("Index to remove: ");
		removeField = new JTextField();

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new GridLayout(0,3,5,10));
		buttonPane.add(addButton);
		buttonPane.add(remove);
		buttonPane.add(closeButton);

		JPanel intermediatePane2 = new JPanel();
		intermediatePane2.setLayout(new GridLayout(0,2,5,10));
		intermediatePane2.setBorder(BorderFactory.createEmptyBorder(10,5,10,5)); 
		intermediatePane2.add(addLabel);
		intermediatePane2.add(addField);
		intermediatePane2.add(removeLabel);
		intermediatePane2.add(removeField);

		JPanel intermediatePane1 = new JPanel();
		intermediatePane1.setLayout(new BoxLayout(intermediatePane1, BoxLayout.Y_AXIS));
		intermediatePane1.add(listPane);
		intermediatePane1.add(intermediatePane2);
		intermediatePane1.add(buttonPane);

		JPanel contentPane = new JPanel();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(intermediatePane1, BorderLayout.CENTER);
		contentPane.add(new JPanel(), BorderLayout.NORTH);
		contentPane.add(new JPanel(), BorderLayout.SOUTH);
		contentPane.add(new JPanel(), BorderLayout.EAST);
		contentPane.add(new JPanel(), BorderLayout.WEST);

		setContentPane(contentPane);
		setResizable(false);
		pack();
		setLocation(new Point(frame.getX() + ((frame.getWidth()-this.getWidth()) / 2), frame.getY() + ((frame.getHeight()-this.getHeight()) / 2)));
		updateDisplay();
		setVisible(true);
	}

	public void actionPerformed(ActionEvent ae)
	{
		Object source = ae.getSource();
		if (source == addButton)
		{
			crb = commandProcessor.processCommand("ADD BREAKPOINT " + addField.getText());
			String returnValue = crb.sGetNextResponse();
			if (returnValue != null)
			{
				if (returnValue.startsWith("* ADD DONE"))
				{
					JOptionPane.showMessageDialog(this, "Breakpoint added successfully.", "Success", JOptionPane.INFORMATION_MESSAGE);
				}
				if (returnValue.startsWith("EXCEPTION"))
				{
					JOptionPane.showMessageDialog(this, returnValue.substring(10), "Error", JOptionPane.ERROR_MESSAGE);
				}
				addField.setText(null);
				removeField.setText(null);
				updateDisplay();
			}
		}
		if (source == remove)
		{
			String toRemove = removeField.getText();
			String command = "REMOVE BREAKPOINT " + toRemove;
			crb = commandProcessor.processCommand(command);
			String returnValue = crb.sGetNextResponse();
			if (returnValue != null)
			{
				if (returnValue.startsWith("* REMOVE DONE"))
				{
					JOptionPane.showMessageDialog(this, "Breakpoint removed successfully.", "Success", JOptionPane.INFORMATION_MESSAGE);
				}
				if (returnValue.startsWith("EXCEPTION"))
				{
					JOptionPane.showMessageDialog(this, returnValue.substring(10), "Error", JOptionPane.ERROR_MESSAGE);
				}
				addField.setText(null);
				removeField.setText(null);
				updateDisplay();
			}
		}
		if (source == closeButton)
		{
			dispose();
		}
	}

	private void updateDisplay()
	{
		breakpoints = new Vector();
		crb = commandProcessor.processCommand("LIST BREAKPOINT");
		String s = crb.sGetNextResponse();
		if (!(s.startsWith("* LIST BREAKPOINT NONE")))
		{
			int counter = 0;
			while (!(s.startsWith("* LIST DONE")))
			{
				StringBuffer listElement = new StringBuffer();
				listElement.append(counter + ": ");
				StringTokenizer st = new StringTokenizer(s);
				String asterisk = st.nextToken();
				String word1 = st.nextToken();
				String word2 = st.nextToken();
				String index = st.nextToken();
				String address = st.nextToken();
				listElement.append(address);
				breakpoints.addElement(listElement.toString());
				s = crb.sGetNextResponse();
				counter++;
			}
		}
		breakpointList.setListData(breakpoints);
		validate();
	}

	private CommandProcessor commandProcessor;
	private CommandResultBuffer crb;
	private JButton addButton;
	private JButton remove;
	private JButton closeButton;
	private JList breakpointList;
	private JTextField addField;
	private JTextField removeField;
	private Vector breakpoints;
}
