package JIMSCore;
/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    TextSection.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/
import java.util.Enumeration;
import java.util.Vector;

public class TextSection {

  public static final int TYPE_TEXT = 0;
  public static final int TYPE_KTEXT = 1;

  public int iAddress;
  public Vector vTextVector;  // Vector of TextEntry
  public int iType;

  public TextSection(int iAddress, int iType) {
	this.iAddress = iAddress;
	vTextVector = new Vector();
	this.iType = iType;
  }    

  public String toString() {
	StringBuffer sb = new StringBuffer();
	sb.append("--section " + Utility.sAsHexPadded(iAddress,8)
	  + ", " + iType + "--\n");
	if (vTextVector != null) {
	  Enumeration e = vTextVector.elements();
	  while (e.hasMoreElements()) {
		TextEntry textEntry = (TextEntry)e.nextElement();
		sb.append(textEntry + "\n");
	  }
	}
	return sb.toString();
  }  // end method toString()    

}