package JIMSCore;
/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    TextEntry.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/
import java.util.StringTokenizer;

public class TextEntry {

  public static final String regID[][] =
	{
	  // 5-bit
	  // reg
	  // value  register aliases
	  {"00000", "$0",  "$ZERO", "$R0" },
	  {"00001", "$1",  "$AT"   },
	  {"00010", "$2",  "$V0"   },
	  {"00011", "$3",  "$V1"   },
	  {"00100", "$4",  "$A0"   },
	  {"00101", "$5",  "$A1"   },
	  {"00110", "$6",  "$A2"   },
	  {"00111", "$7",  "$A3"   },
	  {"01000", "$8",  "$T0"   },
	  {"01001", "$9",  "$T1"   },
	  {"01010", "$10", "$T2"   },
	  {"01011", "$11", "$T3"   },
	  {"01100", "$12", "$T4"   },
	  {"01101", "$13", "$T5"   },
	  {"01110", "$14", "$T6"   },
	  {"01111", "$15", "$T7"   },
	  {"10000", "$16", "$S0"   },
	  {"10001", "$17", "$S1"   },
	  {"10010", "$18", "$S2"   },
	  {"10011", "$19", "$S3"   },
	  {"10100", "$20", "$S4"   },
	  {"10101", "$21", "$S5"   },
	  {"10110", "$22", "$S6"   },
	  {"10111", "$23", "$S7"   },
	  {"11000", "$24", "$T8"   },
	  {"11001", "$25", "$T9"   },
	  {"11010", "$26", "$K0"   },
	  {"11011", "$27", "$K1"   },
	  {"11100", "$28", "$GP"   },
	  {"11101", "$29", "$SP"   },
	  {"11110", "$30", "$FP"   },
	  {"11111", "$31", "$RA"   },
 
	  {"00000", "$F0"          },
	  {"00001", "$F1"          },
	  {"00010", "$F2"          },
	  {"00011", "$F3"          },
	  {"00100", "$F4"          },
	  {"00101", "$F5"          },
	  {"00110", "$F6"          },
	  {"00111", "$F7"          },
	  {"01000", "$F8"          },
	  {"01001", "$F9"          },
	  {"01010", "$F10"         },
	  {"01011", "$F11"         },
	  {"01100", "$F12"         },
	  {"01101", "$F13"         },
	  {"01110", "$F14"         },
	  {"01111", "$F15"         },
	  {"10000", "$F16"         },
	  {"10001", "$F17"         },
	  {"10010", "$F18"         },
	  {"10011", "$F19"         },
	  {"10100", "$F20"         },
	  {"10101", "$F21"         },
	  {"10110", "$F22"         },
	  {"10111", "$F23"         },
	  {"11000", "$F24"         },
	  {"11001", "$F25"         },
	  {"11010", "$F26"         },
	  {"11011", "$F27"         },
	  {"11100", "$F28"         },
	  {"11101", "$F29"         },
	  {"11110", "$F30"         },
	  {"11111", "$F31"         }
	};

  public String op,rs,rt,rd,shamt,funct;
  public String fd, fs, ft;

  public String addr_imm;
  // contains 16-bit immediate value, or 16-bit branch target,
  //   or lower 16-bit portion of a word address.

  public String code;  // break code, up to 20-bits
  public String target;  // jump target, up to 26-bits

  public String format;
  public String formatLen;

  public int iSourceLine;

  public TextEntry(int iSourceLine) {
	this.iSourceLine = iSourceLine;
  }    

  public String toString() {
	return "[" + op + ": " + sGetInstruction() + "]";
  }    

  public String sGetInstruction() {

	// Convert format to the binary sequence of this instruction.

	// XX-rs-rt-rd-XX-XX
	// 6-5-5-5-5-6

	String result = "";

	StringTokenizer stFormat = new StringTokenizer(format, "-");
	StringTokenizer stFormatLen = new StringTokenizer(formatLen, "-");

	while (stFormat.hasMoreTokens()) {

	  String s = stFormat.nextToken();
	  int i = Integer.parseInt(stFormatLen.nextToken());

	  if (s.equals("rs")) {
		result += sRegStringToRegValue(rs);
	  } else
	  if (s.equals("rt")) {
		result += sRegStringToRegValue(rt);
	  } else
	  if (s.equals("rd")) {
		result += sRegStringToRegValue(rd);
	  } else
	  if (s.equals("imm")) {
		result += "imm("+addr_imm+")"; 
	  } else
	  if (s.equals("branch")) {
		result += "branch("+addr_imm+")";
	  } else
	  if (s.equals("offset")) {
		// addr_imm may contain a branch label
		result += "offset("+addr_imm+")";
	  } else
	  if (s.equals("target")) {
		// target may contain a jump label
		result += "target("+target+")";
	  } else
	  if (s.equals("code")) {
		result += "code("+code+")";
	  } else
	  if (s.equals("shamt")) {
		result += "shamt("+shamt+")";
	  } else
	  if (s.equals("fs")) {
		result += sRegStringToRegValue(fs);
	  } else
	  if (s.equals("ft")) {
		result += sRegStringToRegValue(ft);
	  } else
	  if (s.equals("fd")) {
		result += sRegStringToRegValue(fd);
	  } else
	  {
		// Assume it is a hex value
		long l = Utility.IntegerLiteralToLong("0x"+s);
		result += Utility.sAsBinaryPadded(l, i);
		//System.out.println("l == " + l +", i == " + i);
		//System.out.println("binpad(l,i)="+Utility.sAsBinaryPadded(l, i));
	  }
	  
	}  // while

	return result;

  }  // end method sGetInstruction()    

  private String sRegStringToRegValue(String s) {
	s = s.toUpperCase();
	for (int i = 0; i < regID.length; i++) {
	  for (int x = 1; x < regID[i].length; x++) {
		if (s.equals(regID[i][x]))
		  return regID[i][0];
	  }
	}
	// An invalid register must have been specified.
	System.out.println("Invalid register: " + s);
	return "?????"; 
  }  // end method iRegStringToRegValue(String)    

}