package JIMSCore;

/*

TITLE:   InstructionDecoder.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/

public class InstructionDecoder {

/*

  General format of MIPS instructions (all instructions 32-bits):

	op____rs___rt___rd___shamtfunct_
	op____target____________________
	op____rs___rt___offset__________
	op____rs___rt___imm_____________
	op____fcn2_ft___fs___fd___funct_
	10987654321098765432109876543210
	 3         2         1         

*/

  public InstructionDecodeBuffer decode(int iInstr) {
	// If there are any errors, this method will return null.

	InstructionDecodeBuffer decodeBuffer = null;

	try {

	  decodeBuffer = new InstructionDecodeBuffer();

	  decodeBuffer.rawInstruction = iInstr;
	  decodeBuffer.opcode = (byte)( (iInstr & 0xFC000000) >>> 26 );  // instr(31:26)
	  decodeBuffer.rs     = (byte)( (iInstr & 0x03E00000) >>> 21 );  // instr(25:21)
	  decodeBuffer.rt     = (byte)( (iInstr & 0x001F0000) >>> 16 );  // instr(20:16)
	  decodeBuffer.rd     = (byte)( (iInstr & 0x0000F800) >>> 11 );  // instr(15:11)
	  decodeBuffer.shamt  = (byte)( (iInstr & 0x000007C0) >>> 6  );  // instr(10:6)
	  decodeBuffer.funct  = (byte)( (iInstr & 0x0000003F) );  // instr(5:0)
	  decodeBuffer.target = (iInstr & 0x03FFFFFF);  // instr(25:0)
	  decodeBuffer.offset = (int)((short)(iInstr & 0xFFFF));  // instr(15:0) -- Java will sign-extend
	  decodeBuffer.imm    = decodeBuffer.offset;
	  decodeBuffer.fcn2   = decodeBuffer.rs;
	  decodeBuffer.ft     = decodeBuffer.rt;
	  decodeBuffer.fs     = decodeBuffer.rd;
	  decodeBuffer.fd     = decodeBuffer.shamt;

	} catch (Exception e) {

	  decodeBuffer = null;

	}

	return decodeBuffer;

  }  // end method decode(int)    

}