package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    GuardList.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/
import java.util.Vector;

public class GuardList {

  public static final int SUCCESS = 0;
  public static final int ERR_INVALID_INDEX = -3;

  private static Vector vGuard;

  public GuardList() {
	vGuard = new Vector();
  }    

  public Vector vGetGuards() {
	return vGuard;
  }    

  public void addGuard(GuardExpression g) {
	vGuard.add(g);
  }    

  public int iRemoveGuard(int index) {
	try {
	  vGuard.removeElementAt(index);
	} catch (Exception e) {
	  return ERR_INVALID_INDEX;
	}
	return SUCCESS;
  }    

}