package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    DataSection.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/
import java.util.Vector;
import java.util.Enumeration;

/**
  * This is the DataSection class.
  *
  * @author Steve Lewis
*/
public class DataSection {

  public static final int TYPE_DATA = 0;
  public static final int TYPE_KDATA = 1;

  public int iAddress;  // Starting address of this data section
  public Vector vDataVector;  // Vector of DataEntry
  public int iType;

  public DataSection(int iAddress, int iType) {
	this.iAddress = iAddress;
	vDataVector = new Vector();
	this.iType = iType;
  }    

  public String toString() {
	StringBuffer sb = new StringBuffer();
	sb.append("--section " + Utility.sAsHexPadded(iAddress,8)
	  + ", " + iType + "--\n");
	Enumeration e = vDataVector.elements();
	while (e.hasMoreElements()) {
	  DataEntry dataEntry = (DataEntry)e.nextElement();
	  sb.append(dataEntry + "\n");
	}
	return sb.toString();
  }  // end method toString()    

}