package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    CommandResultBuffer.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

PUBLIC METHODS

public String sGetNextResponse()
  Returns the next string response in the result buffer.
  Keep in mind that this method consumes the buffer results.
  A string is always returned.  If the buffer is empty or
  nothing more available, an empty string is returned.

  See COMMAND.TXT for proper command response strings.

public void append(String s)
  Command classes use this method to add content to the
  result buffer.

public String toString()
  This method is available for debugging purposes.  It
  returns a single string containing the entire content of
  the result buffer.  Unlike sGetNextResponse(), this
  method does not consume the buffer results.


*/
import java.util.Vector;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/**
  * This is the CommandResultBuffer class.
  *
  * @author Steve Lewis
*/
public class CommandResultBuffer {

  private Vector vResult;

  public CommandResultBuffer() {
	vResult = new Vector();
  }    

public String sGetNextResponse() {
  String sResult = "";
  try {
	sResult = (String) vResult.elementAt(0);
	vResult.removeElementAt(0);
  }
  catch (Exception e) {
	sResult = "";
  }
  return sResult;
} // end method sGetNextResponse()    

  public void append(String s) {
	vResult.add(s);
  }  // end method append(String)    

  public String toString() {

	Enumeration e = null;
	try {
	  e = vResult.elements();
	} catch (Exception err) {
	  // Most likely a null-pointer error, which should
	  //   not have happened.
	  return "Error retrieving contents of command result buffer.\n";
	}

	StringBuffer sbResult = new StringBuffer();

	do {

	  try {
		sbResult.append((String)e.nextElement());
	  } catch (NoSuchElementException err) {
		// No more elements in the list
		break;
	  }

	  sbResult.append("\n");

	} while (true);

	return sbResult.toString();

  }  // end method toString()    

}