package JIMSCore;

/*

PROJECT: MIPS Simulator With Reversible Debugging Support
FILE:    MainMemory.java
AUTHOR:  Steve Lewis

Copyright (C) 2001 University of Florida
All rights reserved.

======================================================================

*/
import java.util.Vector;

/**
  * This is the BetaMemoryBucket class.
  *
  * @author Steve Lewis
*/
class BetaMemoryBucket {

  public GammaMemoryBucket[] memoryBucket;

  public BetaMemoryBucket() {
	reset();
  }    

  public void reset() {
	if (memoryBucket != null) {
	  for (int i = 0; i < memoryBucket.length; i++) {
		if (memoryBucket[i] != null) {
		  memoryBucket[i].reset();
		  memoryBucket[i] = null;
		}
	  }
	}
	memoryBucket = new GammaMemoryBucket[MainMemory.NUM_BUCKETS];
  }    

  public void storeByte(int a1, int a2, byte value) {
	if (memoryBucket[a1] == null) {
	  memoryBucket[a1] = new GammaMemoryBucket();
	}
	memoryBucket[a1].storeByte(a2, value);
  }    

  public byte loadByte(int a1, int a2) {
	if (memoryBucket == null || memoryBucket[a1] == null) {
	  return 0;
	}
	return memoryBucket[a1].loadByte(a2);
  }    

  public StringBuffer sbGetMemoryDump(String s) {
	StringBuffer sbResult = new StringBuffer();
	if (memoryBucket != null) {
	  for (int i = 0; i < memoryBucket.length; i++) {
		if (memoryBucket[i] != null) {
		  sbResult.append(
			memoryBucket[i].sbGetMemoryDump( s + Utility.sAsHexPadded(i,2) )
					   );
		}
	  }
	}
	return sbResult;
  }            

}