# Steve Lewis
# This is a square root finding program.

# double DELTA = 1.0E-8;
# double n = number to find square root of;
# double guess = initial guess;  (x / 2.0)
# while (true) {
#   if ( abs(n-guess^2) <= DELTA) )
#     break;
#   output guess
#   guess = 0.5 * (n / guess + guess);
# }
# output sqrt(n) == guess

        .data   0x10000000

# n == the number you want to find the square root of
n:      .double 999435678123443.5

# DELTA == the amount of desired precision (larger value
#          is less precise, but faster)
DELTA:  .double 0.00000001

# guess == the initial guess, then holds the final guess
guess:  .double 0.0

# two == constant used during the initial guess
two:    .double 2.0

# half == constant used when calculating the next guess
half:   .double 0.5

# some user friendly output strings
nline:  .asciiz "\n"
final:  .asciiz "\nThe sqrt is "

        .text   0x00400000

main:
        l.d     $f0, n          # $f0 = n
        l.d     $f2, two        # $f2 = 2.0
        l.d     $f6, DELTA      # $f6 = DELTA
        l.d     $f10,half       # $f10 = 0.5

# prepare the initial guess (store at MEM[guess])
        div.d   $f8, $f0, $f2   # $f8 = $f0 / $f2 == (n / 2.0)
        s.d     $f8, guess      # $f8 = the initial guess

        l.d     $f14, guess     # $f14 = previous guess
        l.d     $f4, guess      # let $f4 = current guess
loop:


# Perform the guard of the while loop:  abs(n-guess^2) <= DELTA

#   1) square the guess
        mul.d   $f4, $f4, $f4   # $f4 = $f4 * $f4 == guess^2

#   2) n - guess^2
        sub.d   $f4, $f0, $f4   # $f4 = $f0 - $f4 == (n - guess^2)

#   3) abs result
        abs.d   $f4, $f4        # $f4 = abs($f4) == abs(n-guess^2)

#   4) result > DELTA
        c.le.d  $f4, $f6        # if ( abs(n-guess^2) <= DELTA ) )
        bc1t    done

# Output the guess
        l.d     $f12, guess     # reg[$f12] == double to print
        li      $v0, 3          # 3 == print double
        syscall

#        li      $v0, 4          # 4 == print string (newline)
#        la      $a0, nline
#        syscall

# adjust the value of guess
#   1) (n/guess)
        div.d   $f4, $f0, $f8   # $f4 = $f0 / $f8 == (n/guess)
#   2) (n/guess) + guess
        add.d   $f4, $f4, $f8   # $f4 = $f4 + $f8 == (n/guess) + guess
#   3) (n/guess)+guess * 0.5
        mul.d   $f4, $f4, $f10  # $f4 = $f4 * $f10 == (n/guess)+guess * 0.5
#   4) store the guess
        s.d     $f4, guess      # guess = $f4 (the new guess)
        l.d     $f8, guess      # let $f8 == copy of new guess

        c.eq.d  $f8, $f14       # if new guess == old guess, exit
        bc1t    done

        l.d     $f14, guess     # set the old guess to the new guess
       

        j       loop

done:
# output the final guess
        li      $v0, 4          # 4 == print string
        la      $a0, final
        syscall

        l.d     $f12, guess     # reg[$f12] == double to print
        li      $v0, 3          # 3 == print double
        syscall

#        li      $v0, 4          # 4 == print string
#        la      $a0, nline
#        syscall

        mul.d   $f12, $f12, $f12 # $f12 = $f12 * $f12 == answer ^ 2

        li      $v0, 3          # 3 == print double
        syscall

        li      $v0, 10
        syscall

