# By Steve Lewis 
#
# Description:
#
#	This program collects n integer values and displays
#	statistics (min, max, sum) of these values.  The primary
#	purpose of this project is to demonstrate the use of
#	stack-frames for recursive function calls.
#
#---------------------------------------------------------------------

#---------------------------------------------------------------------
# The code segment
#---------------------------------------------------------------------

	.text
	.globl	main

#---------------------------------------------------------------------
# FUNCTION:	main
# PURPOSE:	Prompts user for number of values to read,
#		prompts for the first value, then calls stats
#		to recursively process remaining values.
# RETURNS:	void
# NOTES:	$s0 holds n (number of integer values)
#		$s1 holds x (the first integer value)
#		$t0 used for greater-than comparison, and temp
#                 var. for fifth parameter to function stats
#               $a0-$a3 hold first four parameters to function stats
# PSUEDO-CODE:
#   void main()
#   {
#     int n = promptForNumberOfValuesToRead();
#     if (n >= 1)    ==>  if (n > 0)
#     {
#       int x = getValue(1, n);
#       stats(n, x, x, x, 2);
#     }
#   }

main:
	# get number of values to read (result stored in $v0)
	jal	promptForNumberOfValuesToRead
	move	$s0, $v0	# let $s0 = n

	sgt	$t0, $s0, $0	# if (n > 0) set $t0 = 1
	beq	$t0, $0, exit	# if (n > 0) is FALSE goto exit

        li      $a0, 1          # param 1: $a0 = 1
	move	$a1, $s0	# param 2: $a1 = n
        jal     getValue	# call getValue(1,n)
	move	$s1, $v0	# let $s1 = x

        move    $a0, $s0        # $a0 = n
        move    $a1, $s1        # $a1 = x
        move    $a2, $s1        # $a2 = x
        move    $a3, $s1        # $a3 = x
        addi	$t0, $0, 2	# $t0 = 2
        # need to store fifth parameter on stack
	sub	$sp, $sp, 4	# initialize
	sw	$t0, 0($sp)	# store $t0 on stack
        jal     stats		# call stats(n, x, x, x, 2)

exit:
	la	$a0, end_str
	li	$v0, 4
	syscall

	li	$v0, 10			# system call 10 to exit program
	syscall
#---------------------------------------------------------------------

#---------------------------------------------------------------------
# FUNCTION:	promptForNumberOfValuesToRead
# PURPOSE:	Prompts the user to specify the number of values
#		to be read and returns the value specified.
# RETURNS:	$v0 (integer, number of values to read)
# NOTES:	$a0 used for paramter for print string function
# PSUEDO-CODE:
#   int promptForNumberOfValuesToRead()
#   {
#     print_string("How many numbers to read? ");
#     return read_int();
#   }

promptForNumberOfValuesToRead:

	# show the "How many values to read?" string
	la	$a0, howmany_str
	li	$v0, 4
	syscall

	# wait for integer input
	li	$v0, 5
	syscall

	# return to calling return (result stored in $v0)
	jr	$ra
#---------------------------------------------------------------------

#---------------------------------------------------------------------
# FUNCTION:	getValue
# PURPOSE:	Prompts the user to enter a value and returns
#		the value specified by the user.
# RETURNS:	$v0 (integer, an integer value input from user)
# NOTES:	$s0 used to hold x parameter
#		$s1 used to hold y parameter
#		$a0 used for paramter for output functions
# PSUEDO-CODE:
#   int getValue(int x, int y)
#   {
#     print_string("Please enter an int value (#");
#     print_int(x);
#     print_string(" of ");
#     print_int(y);
#     print_string("): ");
#     return read_int();
#   }
#

getValue:
	# preserve $s0 and $s1 values, since they are used locally
	sub	$sp, $sp, 8
	sw	$s0, 4($sp)
	sw	$s1, 0($sp)

	# store the x and y parameters in different
	#   registers (since $a0 and $a1 might be used
	#   to call other functions)
	move	$s0, $a0		# $s0 = x
	move	$s1, $a1		# $s1 = y

	# print the "Please enter int value (" string
	la	$a0, int_str
	li	$v0, 4
	syscall

	# print the value of x integer parameter
	move	$a0, $s0
	li	$v0, 1
	syscall

	# print the " of " string
	la	$a0, of_str
	li	$v0, 4
	syscall

	# print the value of the y integer parameter
	move 	$a0, $s1
	li	$v0, 1
	syscall

	# print the ":) " string
	la	$a0, p_str
	li	$v0, 4
	syscall

	# we now have the prompt:
	#   "Please enter int value (x of y): "

	# now wait for integer input (result stored in $v0)
	li	$v0, 5
	syscall

	# restore the $s0 and $s1 values from the stack
	lw	$s1, 0($sp)
	lw	$s0, 4($sp)
	add	$sp, $sp, 8

	# return to the calling function
	jr	$ra
#---------------------------------------------------------------------

#---------------------------------------------------------------------
# FUNCTION:	results
# PURPOSE:	To display the values of the results passed
#		as the parameters.
# RETURNS:	void
# NOTES:        $s0-$s4 used to hold parameter values
#		$t0 temporary holds 5th parameter
# PSUEDO-CODE:
#   void results(int timesCalled, int x, int sum, int min, int max)
#   {
#     print_string("------------------------------------------");
#     print_string("This report is for the first ");
#     print_int(timesCalled);
#     print_string(" values entered.");
#     print_string("\nx = ");
#     print_int(x);
#     print_string("\nsum = ");
#     print_int(sum);
#     print_string("\nmin = ");
#     print_int(min);
#     print_string("\nmax = ");
#     print_int(max);
#   }

results:
	# before we can use the stack, we need to pull the 5th param
	#   from the stack into a temp register
	
	lw	$t0, 0($sp)
	add	$sp, $sp, 4

	# use stack to preserve local variable
	#  registers used in this function
	sub	$sp, $sp, 20
	sw	$s0, 16($sp)
	sw	$s1, 12($sp)
	sw	$s2, 8($sp)
	sw	$s3, 4($sp)
	sw	$s4, 0($sp)

	# move parameters registers into local variable registers
	#   since parameters registers may be usedto call
	#   other functions
	move	$s0, $a0		# timesCalled
	move	$s1, $a1		# x
	move	$s2, $a2		# sum
	move	$s3, $a3		# min
	move	$s4, $t0		# max (popped earlier)

	# print the dash string
	la	$a0, dash_str
	li	$v0, 4
	syscall

	# print the "This report is for first " string
	la	$a0, first_str
	li	$v0, 4
	syscall

	# print the value of the timesCalled integer
	move	$a0, $s0
	li	$v0, 1
	syscall

	# print the "values entered.\nx = " string
	la	$a0, values_str
	li	$v0, 4
	syscall

	# print the value of the x integer
	move 	$a0, $s1
	li	$v0, 1
	syscall

	# print the "\nsum = " string
	la	$a0, sum_str
	li	$v0, 4
	syscall

	# print the value of the sum integer
	move	$a0, $s2
	li	$v0, 1
	syscall

	# print the "\nmin = " string
	la	$a0, min_str
	li	$v0, 4
	syscall

	# print the value of the min integer
	move	$a0, $s3
	li	$v0, 1
	syscall

	# print the "\nmax = " string
	la	$a0, max_str
	li	$v0, 4
	syscall

	# print the value of the max integer
	move	$a0, $s4
	li	$v0, 1
	syscall

	# restore the local vars from the stack
	lw	$s4, 16($sp)
	lw	$s3, 12($sp)
	lw	$s2, 8($sp)
	lw	$s1, 4($sp)
	lw	$s0, 0($sp)
	add	$sp, $sp, 20

	# return the calling function
	jr	$ra
#---------------------------------------------------------------------

#---------------------------------------------------------------------
# FUNCTION:	stats
# PURPOSE:	This function prompts the user for integer values,
#		until a specified number of values have been entered.
#		The function recursively keeps track of the max, min,
#		and sum of the values.  After entering the values, the
#		results are display in reverse order.
# RETURNS:	void
# NOTES:        $s0-$s4 used to hold parameter values
#		$s5 used to hold integer value returned from user
#		$t0 and $t1 used as general-purpose variables
#		$a0, $a1 used as parameters to other functions
# STACK-FRAME:
#
#	Callee's FP ->	|		|	High Mem	
#			+===============+	
#			|  caller's FP	|	FP-4
#			+---------------+	
#			| caller's $s0	|	FP-8	
#			| caller's $s1  |	FP-12
#			| caller's $s2  |	FP-16
#			| caller's $s3  |	FP-20
#			| caller's $s4  |	FP-24
#			| caller's $s5  |	FP-28
#			+---------------+
#		 SP ->	|  ret address	|	FP-32	
#			+===============+	
#			|		|	Low Mem
#
# PSUEDO-CODE:
#   void stats(int n, int sum, int min, int max, int timesCalled)
#   {
#     if (n >= timesCalled)
#     {
#       int x = getValue(timesCalled, n);
#       sum = sum + x;
#       if (x < min)
#         min = x;
#       if (x > max)
#         max = x;
#       stats(n, sum, min, max, timesCalled+1);
#       results(timesCalled, x, sum, min, max);
#     }
#   }
#

stats:
	# get the 5th parameter from the stack, which
	#   should be pushed before this function is called
	lw	$t0, 0($sp)
	add	$sp, $sp, 4

	sw	$fp, -4($sp)		# preserve caller's FP
	move	$fp, $sp		# set FP for new frame
	sub	$sp, $sp, 32		# allocate local storage on stack

	# store caller's local registers
	sw	$s0, -8($fp)
	sw	$s1, -12($fp)
	sw	$s2, -16($fp)
	sw	$s3, -20($fp)
	sw	$s4, -24($fp)
	sw	$s5, -28($fp)

	# store return address for recursive call
	sw	$ra, -32($fp)

	# copy of the parameter values
	move	$s0, $a0		# n
	move	$s1, $a1		# sum
	move	$s2, $a2		# min
	move	$s3, $a3		# max
	move	$s4, $t0		# timesCalled (from stack)

	# check the base case (n >= timesCalled)
	#   actually, we do (n > timesCalled-1)
	addi	$t1, $s4, -1		# let $t1 = timesCalled-1
	sgt	$t0, $s0, $t1		# if n > timesCalled-1 set $t0 = 1
	beq	$t0, $0, skipstats

	# call getValue(timesCalled, n), results in $t1
	move	$a0, $s4
	move	$a1, $s0
	jal	getValue
	move	$s5, $v0		# move $v0 to $t1

	add	$s1, $s1, $s5		# sum = sum + x

	slt	$t0, $s5, $s2		# if (x < min)
	beq	$t0, $0, nonewmin	# if FALSE, no new min
	move	$s2, $s5		# set min = x
nonewmin:

	sgt	$t0, $s5, $s3		# if (x > max)
	beq	$t0, $0, nonewmax	# if FALSE, no new max
	move	$s3, $s5		# set max = x
nonewmax:

	# setup parameters for stats function
	move	$a0, $s0		# n
	move	$a1, $s1		# sum
	move	$a2, $s2		# min
	move	$a3, $s3		# max
	add	$t0, $s4, 1		# timesCalled = timesCalled + 1
	sub	$sp, $sp, 4
	sw	$t0, 0($sp)		# put 5th param on stack (timesCalled)
	jal	stats			# call stats(n, sum, min, max, timesCalled+1)

	# setup parameters for results function
	move	$a0, $s4		# timesCalled
	move	$a1, $s5		# x
	move	$a2, $s1		# sum
	move	$a3, $s2		# min
	sub	$sp, $sp, 4
	sw	$s3, 0($sp)		# max (store on stack)
	jal	results			# call results(timesCalled, x, sum, min, max)

        # store the return address value
	lw	$ra, -32($fp)

skipstats:
	# restore the caller register values
	lw	$s5, -28($fp)
	lw	$s4, -24($fp)
	lw	$s3, -20($fp)
	lw	$s2, -16($fp)
	lw	$s1, -12($fp)
	lw	$s0, -8($fp)

	move	$sp, $fp		# deallocate local storage
	lw	$fp, -4($sp)		# restore caller's FP

	jr	$ra			# return to calling function
#---------------------------------------------------------------------

#---------------------------------------------------------------------
# The data segment
#---------------------------------------------------------------------
	.data
	.align 0

howmany_str:
	.asciiz "How many numbers to read? "
int_str:
	.asciiz "Please enter int value (#"
of_str:
	.asciiz " of "
p_str:
	.asciiz "): "
dash_str:
	.asciiz "\n------------------------------------------\n"
first_str:
	.asciiz "This report is for the first "
values_str:
	.asciiz " values entered.\nx = "
sum_str:
	.asciiz "\nsum = "
min_str:
	.asciiz "\nmin = "
max_str:
	.asciiz "\nmax = "
end_str:
	.asciiz "\nEnd of program.\n"
