/*
 * Decompiled with CFR 0.152.
 */
package JIMSwingGUI;

import JIMSCore.Assembler;
import JIMSCore.CommandOutput;
import JIMSCore.CommandProcessor;
import JIMSCore.CommandResultBuffer;
import JIMSCore.Utility;
import JIMSwingGUI.BreakpointEditDialog;
import JIMSwingGUI.CommandConsoleWindow;
import JIMSwingGUI.HelpWindow;
import JIMSwingGUI.InputDialog;
import JIMSwingGUI.MemoryEditDialog;
import JIMSwingGUI.MultistepBackwardDialog;
import JIMSwingGUI.MultistepForwardDialog;
import JIMSwingGUI.RegisterEditDialog;
import JIMSwingGUI.SettingsDialog;
import JIMSwingGUI.SourceFileFilter;
import JIMSwingGUI.SourceListCellRenderer;
import JIMSwingGUI.SourceListSelectionModel;
import JIMSwingGUI.Splashscreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class TopLevelWindow
extends JFrame
implements ActionListener,
WindowListener,
ComponentListener,
InternalFrameListener {
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenuItem open;
    private JMenuItem exit;
    private JMenu simulatorMenu;
    private JMenuItem singleStepF;
    private JMenuItem singleStepB;
    private JMenuItem multipleStepF;
    private JMenuItem multipleStepB;
    private JMenuItem stop;
    private JMenuItem runF;
    private JMenuItem runB;
    private JMenuItem reset;
    private JMenuItem breakpoints;
    private JMenuItem registerModify;
    private JMenuItem memoryModify;
    private JMenuItem status;
    private JMenuItem commandConsole;
    private JMenuItem settings;
    private JMenu windowMenu;
    private JCheckBoxMenuItem showRegisterWindow;
    private JCheckBoxMenuItem showMemoryWindow;
    private JCheckBoxMenuItem showSourceWindow;
    private JCheckBoxMenuItem showConsoleWindow;
    private JMenuItem resetAllWindows;
    private JMenu helpMenu;
    private JMenuItem helpContents;
    private JMenuItem about;
    private JInternalFrame registerWindow;
    private JList registerList;
    private JScrollPane registerPane;
    private JInternalFrame memoryWindow;
    private JScrollPane memoryPane;
    private JList memoryList;
    private JInternalFrame sourceWindow;
    private JList sourceList;
    private JScrollPane sourcePane;
    private JInternalFrame consoleWindow;
    private JScrollPane consolePane;
    private JTextArea consoleText;
    private Insets topInsets;
    private Insets desktopInsets;
    private JToolBar toolBar;
    private JButton openButton;
    private JButton goFButton;
    private JButton goBButton;
    private JButton stopButton;
    private JButton stepForwardButton;
    private JButton multiStepForwardButton;
    private JButton stepBackButton;
    private JButton multiStepBackButton;
    private JButton settingsButton;
    private JPanel contentPane;
    private JDesktopPane desktopPane;
    private StringBuffer registersContent;
    private String openDir;
    private int applicationX;
    private int applicationY;
    private int applicationWidth;
    private int applicationHeight;
    private int registersX;
    private int registersY;
    private int registersWidth;
    private int registersHeight;
    private int memoryX;
    private int memoryY;
    private int memoryWidth;
    private int memoryHeight;
    private int sourceX;
    private int sourceY;
    private int sourceWidth;
    private int sourceHeight;
    private int consoleX;
    private int consoleY;
    private int consoleWidth;
    private int consoleHeight;
    private int desktopPaneWidth;
    private int desktopPaneHeight;
    private Vector sourceCode;
    private Vector sourceLinks;
    private CommandProcessor commandProcessor;
    private CommandResultBuffer commandResultBuffer;
    private runThread simExecutionThread;
    private boolean shouldRun;
    private boolean fileLoaded;
    private boolean showMoreErrors;
    private boolean GPRHex;
    private boolean SFPHex;
    private boolean DFPHex;
    private boolean ignoreInvalidAT;
    private boolean registerWindowIsIcon;
    private boolean memoryWindowIsIcon;
    private boolean sourceWindowIsIcon;
    private boolean consoleWindowIsIcon;
    private int xCorrection;
    private int yCorrection;

    public TopLevelWindow() {
        Splashscreen splashscreen = new Splashscreen();
        this.shouldRun = false;
        this.fileLoaded = false;
        this.menuBar = new JMenuBar();
        this.setUpMenus();
        this.toolBar = new JToolBar();
        this.setUpToolBar();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.topInsets = this.getInsets();
        this.setContentPane(this.contentPane);
        this.setJMenuBar(this.menuBar);
        this.contentPane.add(this.toolBar);
        this.pack();
        this.xCorrection = this.topInsets.left + this.topInsets.right;
        this.yCorrection = this.topInsets.top + this.topInsets.bottom + this.menuBar.getHeight() + this.toolBar.getHeight();
        this.loadConfig();
        this.setUpMenuItems();
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setBackground(Color.getColor("gray"));
        this.desktopPane.setLayout(null);
        this.desktopPane.setBorder(BorderFactory.createLineBorder(Color.getColor("black")));
        this.desktopInsets = this.desktopPane.getInsets();
        this.contentPane.add(this.desktopPane);
        this.registerWindow = new JInternalFrame("Registers", true, false, true, true);
        this.registerWindow.setBounds(this.registersX, this.registersY, this.registersWidth, this.registersHeight);
        this.registerList = new JList();
        this.registerList.setSelectionModel(new SourceListSelectionModel());
        this.registerList.setCellRenderer(new SourceListCellRenderer());
        this.registerPane = new JScrollPane(this.registerList, 20, 30);
        this.registerPane.setSize(this.registerWindow.getContentPane().getWidth(), this.registerWindow.getContentPane().getHeight());
        this.registerPane.getViewport().setScrollMode(0);
        this.registerWindow.getContentPane().add(this.registerPane);
        this.registerWindow.addComponentListener(this);
        this.registerWindow.addInternalFrameListener(this);
        this.memoryWindow = new JInternalFrame("Memory", true, false, true, true);
        this.memoryWindow.setBounds(this.memoryX, this.memoryY, this.memoryWidth, this.memoryHeight);
        this.memoryList = new JList();
        this.memoryList.setSelectionModel(new SourceListSelectionModel());
        this.memoryList.setCellRenderer(new SourceListCellRenderer());
        this.memoryPane = new JScrollPane(this.memoryList, 20, 30);
        this.memoryPane.getViewport().setScrollMode(0);
        this.memoryWindow.getContentPane().add(this.memoryPane);
        this.memoryWindow.addComponentListener(this);
        this.memoryWindow.addInternalFrameListener(this);
        this.sourceWindow = new JInternalFrame("Source", true, false, true, true);
        this.sourceWindow.setBounds(this.sourceX, this.sourceY, this.sourceWidth, this.sourceHeight);
        this.sourceList = new JList();
        this.sourceList.setSelectionModel(new SourceListSelectionModel());
        this.sourceList.setCellRenderer(new SourceListCellRenderer());
        this.sourcePane = new JScrollPane(this.sourceList, 20, 30);
        this.sourcePane.setSize(this.sourceWindow.getContentPane().getWidth(), this.sourceWindow.getContentPane().getHeight());
        this.sourcePane.getViewport().setScrollMode(0);
        this.sourceWindow.getContentPane().add(this.sourcePane);
        this.sourceWindow.addComponentListener(this);
        this.sourceWindow.addInternalFrameListener(this);
        this.consoleWindow = new JInternalFrame("Console", true, false, true, true);
        this.consoleWindow.setBounds(this.consoleX, this.consoleY, this.consoleWidth, this.consoleHeight);
        this.consoleText = new JTextArea();
        this.consoleText.setEditable(false);
        this.consoleText.setFont(new Font("monospaced", 0, 12));
        this.consolePane = new JScrollPane(this.consoleText, 20, 30);
        this.consolePane.setSize(this.consoleWindow.getContentPane().getWidth(), this.consoleWindow.getContentPane().getHeight());
        this.consolePane.getViewport().setScrollMode(0);
        this.consoleWindow.getContentPane().add(this.consolePane);
        this.consoleWindow.addComponentListener(this);
        this.consoleWindow.addInternalFrameListener(this);
        this.desktopPane.add(this.registerWindow);
        this.desktopPane.add(this.memoryWindow);
        this.desktopPane.add(this.sourceWindow);
        this.desktopPane.add(this.consoleWindow);
        try {
            this.registerWindow.setIcon(this.registerWindowIsIcon);
            this.memoryWindow.setIcon(this.memoryWindowIsIcon);
            this.sourceWindow.setIcon(this.sourceWindowIsIcon);
            this.consoleWindow.setIcon(this.consoleWindowIsIcon);
        }
        catch (PropertyVetoException propertyVetoException) {
            System.err.println("Error setting iconified/deiconified state of internal frames in TopLevelWindow constructor.");
        }
        this.registerWindow.setVisible(true);
        this.memoryWindow.setVisible(true);
        this.sourceWindow.setVisible(true);
        this.consoleWindow.setVisible(true);
        this.performReset();
        ((Component)this).setLocation(this.applicationX, this.applicationY);
        ((Component)this).setSize(this.applicationWidth, this.applicationHeight);
        this.setResizable(true);
        this.setTitle("JIMSwing Release 1.0");
        splashscreen.dispose();
        ((Component)this).setVisible(true);
        try {
            this.registerWindow.setSelected(true);
            this.memoryWindow.setSelected(false);
            this.sourceWindow.setSelected(false);
            this.consoleWindow.setSelected(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            System.err.println("Error setting selected internal frame in TopLevelWindow constructor.");
        }
        this.desktopPaneWidth = this.desktopPane.getWidth();
        this.desktopPaneHeight = this.desktopPane.getHeight();
        this.addWindowListener(this);
        this.addComponentListener(this);
    }

    private void performBackStep(boolean bl) {
        this.commandResultBuffer = this.commandProcessor.processCommand("UNDO 1");
        String string = this.commandResultBuffer.sGetNextResponse();
        if (string.startsWith("* UNDO OUTPUT")) {
            this.commandResultBuffer = this.commandProcessor.processCommand("OUTPUT");
            string = this.commandResultBuffer.sGetNextResponse();
            if (string.equals("* OUTPUT OK")) {
                CommandOutput commandOutput = (CommandOutput)this.commandProcessor.getLastCommand();
                StringBuffer stringBuffer = commandOutput.sbGetOutput();
                this.consoleText.append(stringBuffer.toString());
            }
            this.validate();
        }
        if (string.startsWith("* UNDO EXCEPTION")) {
            JOptionPane.showMessageDialog(this, "Error encountered.", "Error", 0);
            this.shouldRun = false;
            bl = true;
        }
        if (string.startsWith("* UNDO ERR")) {
            JOptionPane.showMessageDialog(this, "Error encountered.", "Error", 0);
            this.shouldRun = false;
            bl = true;
        }
        this.updateConsole();
        if (bl) {
            this.updateMemory();
            this.updateRegisters();
            this.highlightSourceLine(this.getRegisterValue("GPR", "$PC"));
        }
        this.validate();
    }

    private void performForwardStep(boolean bl) {
        Object object;
        this.commandResultBuffer = this.commandProcessor.processCommand("STEP 1");
        String string = this.commandResultBuffer.sGetNextResponse();
        if (string.startsWith("* STEP EXCEPTION 4")) {
            this.commandResultBuffer = this.commandProcessor.processCommand("OUTPUT");
            string = this.commandResultBuffer.sGetNextResponse();
            if (string.equals("* OUTPUT OK")) {
                object = (CommandOutput)this.commandProcessor.getLastCommand();
                StringBuffer stringBuffer = ((CommandOutput)object).sbGetOutput();
                this.consoleText.append(stringBuffer.toString());
            }
            this.validate();
        }
        if (string.startsWith("* STEP EXCEPTION 5")) {
            this.shouldRun = false;
            this.highlightSourceLine(this.getRegisterValue("GPR", "$PC"));
            this.validate();
            object = new InputDialog((Frame)this, this.commandProcessor);
            string = ((InputDialog)object).getReturnValue();
            if (string != null && string.equals("* INPUT DONE")) {
                this.consoleText.append(((InputDialog)object).getText() + "\n");
                this.shouldRun = true;
            }
        }
        if (string.startsWith("* STEP EXCEPTION 6")) {
            this.shouldRun = false;
            bl = true;
            this.performBackStep(true);
            JOptionPane.showMessageDialog(this, "Exit system call encountered.", "System call exit", 1);
        }
        if (string.startsWith("* STEP BREAKPOINT")) {
            this.shouldRun = false;
            bl = true;
            JOptionPane.showMessageDialog(this, "Breakpoint encountered.", "Breakpoint", 1);
        }
        if (string.startsWith("* STEP ERR")) {
            this.shouldRun = false;
            bl = true;
            JOptionPane.showMessageDialog(this, string, "Error", 0);
        }
        if (string.startsWith("* STEP GUARD")) {
            this.shouldRun = false;
            bl = true;
            JOptionPane.showMessageDialog(this, "Guard expression encountered.", "Guard", 1);
        }
        this.updateConsole();
        if (bl) {
            this.updateMemory();
            this.updateRegisters();
            this.highlightSourceLine(this.getRegisterValue("GPR", "$PC"));
        }
        this.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        Object object = actionEvent.getSource();
        if (object == this.exit) {
            this.performExit();
        }
        if (object == this.resetAllWindows && (n2 = JOptionPane.showConfirmDialog(this, "Reset all windows?", "Confirm", 0)) == 0) {
            this.restoreWindows();
        }
        if (object == this.settings || object == this.settingsButton) {
            SettingsDialog settingsDialog = new SettingsDialog(this, this.GPRHex, this.SFPHex, this.DFPHex, this.ignoreInvalidAT);
        }
        if (object == this.showRegisterWindow) {
            try {
                this.registerWindow.setIcon(!this.showRegisterWindow.isSelected());
            }
            catch (PropertyVetoException propertyVetoException) {
                System.err.println("Error iconifying/deiconifying window in TopLevelWindow.actionPerformed.");
            }
        }
        if (object == this.showMemoryWindow) {
            try {
                this.memoryWindow.setIcon(!this.showMemoryWindow.isSelected());
            }
            catch (PropertyVetoException propertyVetoException) {
                System.err.println("Error iconifying/deiconifying window in TopLevelWindow.actionPerformed.");
            }
        }
        if (object == this.showSourceWindow) {
            try {
                this.sourceWindow.setIcon(!this.showSourceWindow.isSelected());
            }
            catch (PropertyVetoException propertyVetoException) {
                System.err.println("Error iconifying/deiconifying window in TopLevelWindow.actionPerformed.");
            }
        }
        if (object == this.showConsoleWindow) {
            try {
                this.consoleWindow.setIcon(!this.showConsoleWindow.isSelected());
            }
            catch (PropertyVetoException propertyVetoException) {
                System.err.println("Error iconifying/deiconifying window in TopLevelWindow.actionPerformed.");
            }
        }
        if (object == this.about) {
            JOptionPane.showMessageDialog(this, "JIMSwing Release 1.0\nFred Williams, 2001\nUniversity of Florida\n\nAn extension of JIMS Release 1\nSteve Lewis, 2001\nUniversity of Florida\n", "About JIMSwing", 1);
        }
        if (object == this.helpContents) {
            HelpWindow helpWindow = new HelpWindow(this);
        }
        if (object == this.commandConsole) {
            CommandConsoleWindow commandConsoleWindow = new CommandConsoleWindow(this, this.commandProcessor);
        }
        if (object == this.status) {
            this.commandResultBuffer = this.commandProcessor.processCommand("STATUS");
            String string = new String();
            StringBuffer stringBuffer = new StringBuffer();
            while (!(string = this.commandResultBuffer.sGetNextResponse()).equals("* STATUS DONE")) {
                stringBuffer.append(string + "\n");
            }
            JOptionPane.showMessageDialog(this, stringBuffer.toString(), "Simulator status", 1);
        }
        if (object == this.reset && this.performReset()) {
            JOptionPane.showMessageDialog(this, "Simulator reset.", "Reset status", 1);
        }
        if (!(object != this.runF && object != this.goFButton || this.shouldRun)) {
            this.shouldRun = true;
            this.simExecutionThread = new runThread("JIMSwing running", true);
            this.simExecutionThread.start();
        }
        if (!(object != this.runB && object != this.goBButton || this.shouldRun)) {
            this.shouldRun = true;
            this.simExecutionThread = new runThread("JIMSwing running", false);
            this.simExecutionThread.start();
        }
        if (object == this.stop || object == this.stopButton) {
            if (this.shouldRun) {
                this.shouldRun = false;
                this.updateMemory();
                this.updateRegisters();
                this.highlightSourceLine(this.getRegisterValue("GPR", "$PC"));
            } else {
                JOptionPane.showMessageDialog(this, "Simulator not running.", "Error", 0);
            }
        }
        if (!(object != this.multipleStepF && object != this.multiStepForwardButton || this.shouldRun)) {
            MultistepForwardDialog multistepForwardDialog = new MultistepForwardDialog((Frame)this, this.commandProcessor);
            this.validate();
            int n3 = multistepForwardDialog.getReturnValue();
            n = 0;
            if (n3 != 0) {
                while (n < n3) {
                    this.performForwardStep(false);
                    ++n;
                }
                this.performForwardStep(true);
            }
        }
        if (!(object != this.multipleStepB && object != this.multiStepBackButton || this.shouldRun)) {
            MultistepBackwardDialog multistepBackwardDialog = new MultistepBackwardDialog((Frame)this, this.commandProcessor);
            this.validate();
            int n4 = multistepBackwardDialog.getReturnValue();
            n = 0;
            if (n4 != 0) {
                while (n < n4) {
                    this.performBackStep(false);
                    ++n;
                }
                this.performBackStep(true);
            }
        }
        if (!(object != this.singleStepF && object != this.stepForwardButton || this.shouldRun)) {
            this.performForwardStep(true);
        }
        if (!(object != this.singleStepB && object != this.stepBackButton || this.shouldRun)) {
            this.performBackStep(true);
        }
        if (object == this.breakpoints) {
            BreakpointEditDialog breakpointEditDialog = new BreakpointEditDialog((Frame)this, this.commandProcessor);
        }
        if (object == this.memoryModify) {
            MemoryEditDialog memoryEditDialog = new MemoryEditDialog(this, this.commandProcessor);
        }
        if (object == this.registerModify) {
            RegisterEditDialog registerEditDialog = new RegisterEditDialog(this, this.commandProcessor);
        }
        if (object == this.open || object == this.openButton) {
            JFileChooser jFileChooser = !this.openDir.equals("nonespecified") ? new JFileChooser(this.openDir) : new JFileChooser();
            jFileChooser.setFileHidingEnabled(true);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileFilter(new SourceFileFilter());
            int n5 = jFileChooser.showOpenDialog(this.contentPane);
            if (n5 == 0) {
                StringTokenizer stringTokenizer;
                Object object2;
                this.performReset();
                File file = jFileChooser.getSelectedFile();
                this.openDir = file.getParent();
                String string = file.getName();
                int n6 = string.indexOf(46);
                if (n6 >= 0) {
                    string = string.substring(0, n6);
                }
                String string2 = new String();
                try {
                    string2 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    System.err.println("Error getting canonical path for source file in TopLevelWindow.actionPerformed");
                    JOptionPane.showMessageDialog(this, "Error opening file.", "Error", 1);
                }
                if (this.assemblyPhase1(string2, this.openDir, string, this.ignoreInvalidAT) > 0) {
                    this.performReset();
                    return;
                }
                if (this.assemblyPhase2(this.openDir + File.separator + string + ".modified", this.openDir, string, this.ignoreInvalidAT) > 0) {
                    this.performReset();
                    return;
                }
                Vector vector = Utility.vLoadFileAsVector(this.openDir + File.separator + string + ".code");
                Enumeration enumeration = vector.elements();
                this.sourceLinks = new Vector();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    if (((String)object2).startsWith("T ")) {
                        this.commandResultBuffer = this.commandProcessor.processCommand("LOAD " + (String)object2);
                        stringTokenizer = new StringTokenizer((String)object2);
                        stringTokenizer.nextToken();
                        String string3 = stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken().substring(1);
                        long l = Long.parseLong(string3, 16);
                        int n7 = Integer.parseInt(string4);
                        this.sourceLinks.add(new sourceLink(string3, n7));
                    }
                    if (!((String)object2).startsWith("D ")) continue;
                    this.commandResultBuffer = this.commandProcessor.processCommand("LOAD " + (String)object2);
                }
                vector = null;
                object2 = Utility.vLoadFileAsVector(this.openDir + File.separator + string + ".modified");
                this.sourceCode = new Vector();
                stringTokenizer = ((Vector)object2).elements();
                int n8 = 1;
                int n9 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (n9 < this.sourceLinks.size() && n8 == ((sourceLink)this.sourceLinks.elementAt((int)n9)).line) {
                        stringBuffer.append("[0x");
                        stringBuffer.append(((sourceLink)this.sourceLinks.elementAt((int)n9)).pc);
                        stringBuffer.append("]");
                        stringBuffer.append((String)stringTokenizer.nextElement());
                        ++n9;
                    } else {
                        stringBuffer.append((String)stringTokenizer.nextElement());
                    }
                    ++n8;
                    this.sourceCode.add(stringBuffer.toString());
                }
                Vector vector2 = Utility.vLoadFileAsVector(this.openDir + File.separator + string + ".code");
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    if (!string5.startsWith("T ")) continue;
                    this.commandResultBuffer = this.commandProcessor.processCommand("LOAD " + string5);
                }
                this.updateRegisters();
                this.updateMemory();
                this.sourceList.setListData(this.sourceCode);
                this.highlightSourceLine(this.getRegisterValue("GPR", "$PC"));
                this.fileLoaded = true;
                this.validate();
            }
        }
    }

    private void setUpMenus() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.simulatorMenu = new JMenu("Simulator");
        this.simulatorMenu.setMnemonic(83);
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic(87);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.simulatorMenu);
        this.menuBar.add(this.windowMenu);
        this.menuBar.add(this.helpMenu);
    }

    public void setUpMenuItems() {
        this.open = new JMenuItem("Open");
        this.open.setMnemonic(79);
        this.open.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.open.addActionListener(this);
        this.exit = new JMenuItem("Exit");
        this.exit.setMnemonic(88);
        this.exit.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.exit.addActionListener(this);
        this.fileMenu.add(this.open);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exit);
        this.singleStepB = new JMenuItem("Step backward");
        this.singleStepB.setMnemonic(83);
        this.singleStepB.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.singleStepB.addActionListener(this);
        this.multipleStepB = new JMenuItem("Multiple step backward");
        this.multipleStepB.setMnemonic(77);
        this.multipleStepB.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.multipleStepB.addActionListener(this);
        this.runB = new JMenuItem("Run backward");
        this.runB.setMnemonic(66);
        this.runB.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.runB.addActionListener(this);
        this.singleStepF = new JMenuItem("Step forward");
        this.singleStepF.setMnemonic(83);
        this.singleStepF.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.singleStepF.addActionListener(this);
        this.multipleStepF = new JMenuItem("Multiple step forward");
        this.multipleStepF.setMnemonic(77);
        this.multipleStepF.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.multipleStepF.addActionListener(this);
        this.runF = new JMenuItem("Run forward");
        this.runF.setMnemonic(70);
        this.runF.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.runF.addActionListener(this);
        this.stop = new JMenuItem("Stop");
        this.stop.setMnemonic(80);
        this.stop.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.stop.addActionListener(this);
        this.reset = new JMenuItem("Reset");
        this.reset.setMnemonic(82);
        this.reset.addActionListener(this);
        this.breakpoints = new JMenuItem("Breakpoints");
        this.breakpoints.setMnemonic(75);
        this.breakpoints.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.breakpoints.addActionListener(this);
        this.registerModify = new JMenuItem("Register Modify");
        this.registerModify.setMnemonic(71);
        this.registerModify.addActionListener(this);
        this.memoryModify = new JMenuItem("Memory Modify");
        this.memoryModify.setMnemonic(69);
        this.memoryModify.addActionListener(this);
        this.status = new JMenuItem("Status");
        this.status.addActionListener(this);
        this.commandConsole = new JMenuItem("Command console");
        this.commandConsole.addActionListener(this);
        this.settings = new JMenuItem("Settings");
        this.settings.addActionListener(this);
        this.simulatorMenu.add(this.reset);
        this.simulatorMenu.addSeparator();
        this.simulatorMenu.add(this.runF);
        this.simulatorMenu.add(this.stop);
        this.simulatorMenu.add(this.runB);
        this.simulatorMenu.addSeparator();
        this.simulatorMenu.add(this.singleStepF);
        this.simulatorMenu.add(this.multipleStepF);
        this.simulatorMenu.add(this.singleStepB);
        this.simulatorMenu.add(this.multipleStepB);
        this.simulatorMenu.addSeparator();
        this.simulatorMenu.add(this.registerModify);
        this.simulatorMenu.add(this.memoryModify);
        this.simulatorMenu.add(this.breakpoints);
        this.simulatorMenu.add(this.status);
        this.simulatorMenu.addSeparator();
        this.simulatorMenu.add(this.commandConsole);
        this.simulatorMenu.addSeparator();
        this.simulatorMenu.add(this.settings);
        this.showRegisterWindow = new JCheckBoxMenuItem("Registers", !this.registerWindowIsIcon);
        this.showRegisterWindow.addActionListener(this);
        this.showMemoryWindow = new JCheckBoxMenuItem("Memory", !this.memoryWindowIsIcon);
        this.showMemoryWindow.addActionListener(this);
        this.showSourceWindow = new JCheckBoxMenuItem("Source", !this.sourceWindowIsIcon);
        this.showSourceWindow.addActionListener(this);
        this.showConsoleWindow = new JCheckBoxMenuItem("Console", !this.consoleWindowIsIcon);
        this.showConsoleWindow.addActionListener(this);
        this.resetAllWindows = new JMenuItem("Reset all");
        this.resetAllWindows.addActionListener(this);
        this.windowMenu.add(this.showRegisterWindow);
        this.windowMenu.add(this.showMemoryWindow);
        this.windowMenu.add(this.showSourceWindow);
        this.windowMenu.add(this.showConsoleWindow);
        this.windowMenu.addSeparator();
        this.windowMenu.add(this.resetAllWindows);
        this.helpContents = new JMenuItem("Contents");
        this.helpContents.addActionListener(this);
        this.about = new JMenuItem("About");
        this.about.setMnemonic(65);
        this.about.addActionListener(this);
        this.helpMenu.add(this.helpContents);
        this.helpMenu.add(this.about);
    }

    public void setUpToolBar() {
        this.toolBar.setFloatable(false);
        this.openButton = new JButton(new ImageIcon("./toolBarGraphics/Open16.gif"));
        this.openButton.addActionListener(this);
        this.openButton.setToolTipText("Open");
        this.goBButton = new JButton(new ImageIcon("./toolBarGraphics/StepBack16.gif"));
        this.goBButton.addActionListener(this);
        this.goBButton.setToolTipText("Run backward");
        this.multiStepBackButton = new JButton(new ImageIcon("./toolBarGraphics/Rewind16.gif"));
        this.multiStepBackButton.addActionListener(this);
        this.multiStepBackButton.setToolTipText("Multi-step backward");
        this.stepBackButton = new JButton(new ImageIcon("./toolBarGraphics/PlayBack16.gif"));
        this.stepBackButton.addActionListener(this);
        this.stepBackButton.setToolTipText("Step backward");
        this.stopButton = new JButton(new ImageIcon("./toolBarGraphics/Stop16.gif"));
        this.stopButton.addActionListener(this);
        this.stopButton.setToolTipText("Stop");
        this.stepForwardButton = new JButton(new ImageIcon("./toolBarGraphics/Play16.gif"));
        this.stepForwardButton.addActionListener(this);
        this.stepForwardButton.setToolTipText("Step forward");
        this.multiStepForwardButton = new JButton(new ImageIcon("./toolBarGraphics/FastForward16.gif"));
        this.multiStepForwardButton.addActionListener(this);
        this.multiStepForwardButton.setToolTipText("Multi-step forward");
        this.goFButton = new JButton(new ImageIcon("./toolBarGraphics/StepForward16.gif"));
        this.goFButton.addActionListener(this);
        this.goFButton.setToolTipText("Run forward");
        this.settingsButton = new JButton(new ImageIcon("./toolBarGraphics/Preferences16.gif"));
        this.settingsButton.addActionListener(this);
        this.settingsButton.setToolTipText("Settings");
        this.toolBar.add(this.openButton);
        this.toolBar.addSeparator();
        this.toolBar.add(this.goBButton);
        this.toolBar.add(this.multiStepBackButton);
        this.toolBar.add(this.stepBackButton);
        this.toolBar.add(this.stopButton);
        this.toolBar.add(this.stepForwardButton);
        this.toolBar.add(this.multiStepForwardButton);
        this.toolBar.add(this.goFButton);
        this.toolBar.addSeparator();
        this.toolBar.add(this.settingsButton);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setVisible(true);
        this.toolBar.setAlignmentX(0.0f);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.performExit();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.performExit();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.registerWindow) {
            this.registersX = this.registerWindow.getX();
            this.registersY = this.registerWindow.getY();
        }
        if (componentEvent.getSource() == this.memoryWindow) {
            this.memoryX = this.memoryWindow.getX();
            this.memoryY = this.memoryWindow.getY();
        }
        if (componentEvent.getSource() == this.sourceWindow) {
            this.sourceX = this.sourceWindow.getX();
            this.sourceY = this.sourceWindow.getY();
        }
        if (componentEvent.getSource() == this.consoleWindow) {
            this.consoleX = this.consoleWindow.getX();
            this.consoleY = this.consoleWindow.getY();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this.registerWindow) {
            this.registersWidth = this.registerWindow.getWidth();
            this.registersHeight = this.registerWindow.getHeight();
            this.validate();
        }
        if (componentEvent.getSource() == this.memoryWindow) {
            this.memoryWidth = this.memoryWindow.getWidth();
            this.memoryHeight = this.memoryWindow.getHeight();
            this.validate();
        }
        if (componentEvent.getSource() == this.sourceWindow) {
            this.sourceWidth = this.sourceWindow.getWidth();
            this.sourceHeight = this.sourceWindow.getHeight();
            this.sourcePane.setSize(this.sourceWindow.getContentPane().getWidth(), this.sourceWindow.getContentPane().getHeight());
            this.validate();
        }
        if (componentEvent.getSource() == this.consoleWindow) {
            this.consoleWidth = this.consoleWindow.getWidth();
            this.consoleHeight = this.consoleWindow.getHeight();
            this.validate();
        }
        if (componentEvent.getSource() == this) {
            int n = this.desktopPane.getWidth();
            int n2 = this.desktopPane.getHeight();
            this.registersX = (int)Math.rint((double)(this.registersX * n) / (double)this.desktopPaneWidth);
            this.registersY = (int)Math.rint((double)(this.registersY * n2) / (double)this.desktopPaneHeight);
            int n3 = (int)Math.rint((double)(this.registersWidth * n) / (double)this.desktopPaneWidth);
            this.registersWidth = n3 < n ? n3 : n;
            n3 = (int)Math.rint((double)(this.registersHeight * n2) / (double)this.desktopPaneHeight);
            this.registersHeight = n3 < n2 ? n3 : n2;
            this.registerWindow.setBounds(this.registersX, this.registersY, this.registersWidth, this.registersHeight);
            this.memoryX = (int)Math.rint((double)this.memoryX * (double)n / (double)this.desktopPaneWidth);
            this.memoryY = (int)Math.rint((double)this.memoryY * (double)n2 / (double)this.desktopPaneHeight);
            n3 = (int)Math.rint((double)this.memoryWidth * (double)n / (double)this.desktopPaneWidth);
            this.memoryWidth = n3 < n ? n3 : n;
            n3 = (int)Math.rint((double)this.memoryHeight * (double)n2 / (double)this.desktopPaneHeight);
            this.memoryHeight = n3 < n2 ? n3 : n2;
            this.memoryWindow.setBounds(this.memoryX, this.memoryY, this.memoryWidth, this.memoryHeight);
            this.sourceX = (int)Math.rint((double)this.sourceX * (double)n / (double)this.desktopPaneWidth);
            this.sourceY = (int)Math.rint((double)this.sourceY * (double)n2 / (double)this.desktopPaneHeight);
            n3 = (int)Math.rint((double)this.sourceWidth * (double)n / (double)this.desktopPaneWidth);
            this.sourceWidth = n3 < n ? n3 : n;
            n3 = (int)Math.rint((double)this.sourceHeight * (double)n2 / (double)this.desktopPaneHeight);
            this.sourceHeight = n3 < n2 ? n3 : n2;
            this.sourceWindow.setBounds(this.sourceX, this.sourceY, this.sourceWidth, this.sourceHeight);
            this.consoleX = (int)Math.rint((double)this.consoleX * (double)n / (double)this.desktopPaneWidth);
            this.consoleY = (int)Math.rint((double)this.consoleY * (double)n2 / (double)this.desktopPaneHeight);
            n3 = (int)Math.rint((double)this.consoleWidth * (double)n / (double)this.desktopPaneWidth);
            this.consoleWidth = n3 < n ? n3 : n;
            n3 = (int)Math.rint((double)this.consoleHeight * (double)n2 / (double)this.desktopPaneHeight);
            this.consoleHeight = n3 < n2 ? n3 : n2;
            this.consoleWindow.setBounds(this.consoleX, this.consoleY, this.consoleWidth, this.consoleHeight);
            this.sourcePane.setSize(this.sourceWindow.getContentPane().getWidth(), this.sourceWindow.getContentPane().getHeight());
            this.desktopPaneWidth = this.desktopPane.getWidth();
            this.desktopPaneHeight = this.desktopPane.getHeight();
            this.validate();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
        if (jInternalFrame == this.registerWindow) {
            this.registerWindowIsIcon = true;
            this.showRegisterWindow.setSelected(false);
        }
        if (jInternalFrame == this.memoryWindow) {
            this.memoryWindowIsIcon = true;
            this.showMemoryWindow.setSelected(false);
        }
        if (jInternalFrame == this.sourceWindow) {
            this.sourceWindowIsIcon = true;
            this.showSourceWindow.setSelected(false);
        }
        if (jInternalFrame == this.consoleWindow) {
            this.consoleWindowIsIcon = true;
            this.showConsoleWindow.setSelected(false);
        }
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
        if (jInternalFrame == this.registerWindow) {
            this.registerWindowIsIcon = false;
            this.showRegisterWindow.setSelected(true);
        }
        if (jInternalFrame == this.memoryWindow) {
            this.memoryWindowIsIcon = false;
            this.showMemoryWindow.setSelected(true);
        }
        if (jInternalFrame == this.sourceWindow) {
            this.sourceWindowIsIcon = false;
            this.showSourceWindow.setSelected(true);
        }
        if (jInternalFrame == this.consoleWindow) {
            this.consoleWindowIsIcon = false;
            this.showConsoleWindow.setSelected(true);
        }
    }

    public void updateSettings(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.GPRHex = bl;
        this.SFPHex = bl2;
        this.DFPHex = bl3;
        this.ignoreInvalidAT = bl4;
        this.displayUpdate();
    }

    private void loadConfig() {
        File file = new File("jimswing.cfg");
        RandomAccessFile randomAccessFile = null;
        if (file.exists()) {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File not found in TopLevelWindow.loadConfig.");
            }
            try {
                randomAccessFile.seek(0L);
                this.openDir = randomAccessFile.readUTF();
                this.applicationX = randomAccessFile.readInt();
                if (this.applicationX < 0) {
                    this.applicationX = 0;
                }
                this.applicationY = randomAccessFile.readInt();
                if (this.applicationY < 0) {
                    this.applicationY = 0;
                }
                this.applicationWidth = randomAccessFile.readInt();
                this.applicationHeight = randomAccessFile.readInt();
                this.registersX = randomAccessFile.readInt();
                this.registersY = randomAccessFile.readInt();
                this.registersWidth = randomAccessFile.readInt();
                this.registersHeight = randomAccessFile.readInt();
                this.registerWindowIsIcon = randomAccessFile.readBoolean();
                this.memoryX = randomAccessFile.readInt();
                this.memoryY = randomAccessFile.readInt();
                this.memoryWidth = randomAccessFile.readInt();
                this.memoryHeight = randomAccessFile.readInt();
                this.memoryWindowIsIcon = randomAccessFile.readBoolean();
                this.sourceX = randomAccessFile.readInt();
                this.sourceY = randomAccessFile.readInt();
                this.sourceWidth = randomAccessFile.readInt();
                this.sourceHeight = randomAccessFile.readInt();
                this.sourceWindowIsIcon = randomAccessFile.readBoolean();
                this.consoleX = randomAccessFile.readInt();
                this.consoleY = randomAccessFile.readInt();
                this.consoleWidth = randomAccessFile.readInt();
                this.consoleHeight = randomAccessFile.readInt();
                this.consoleWindowIsIcon = randomAccessFile.readBoolean();
                this.GPRHex = randomAccessFile.readBoolean();
                this.SFPHex = randomAccessFile.readBoolean();
                this.DFPHex = randomAccessFile.readBoolean();
                this.ignoreInvalidAT = randomAccessFile.readBoolean();
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                System.err.println("Error reading file in TopLevelWindow.loadConfig.");
                JOptionPane.showMessageDialog(this, "Error reading configuration file.", "Error", 1);
            }
        } else {
            this.restoreConfigFile();
        }
    }

    private boolean performReset() {
        boolean bl = false;
        this.commandProcessor = new CommandProcessor();
        this.commandResultBuffer = this.commandProcessor.processCommand("RESET");
        if (this.commandResultBuffer.sGetNextResponse().startsWith("* RESET OK")) {
            if (this.shouldRun) {
                this.shouldRun = false;
            }
            this.sourceCode = new Vector();
            this.sourceLinks = null;
            this.sourceCode.addElement("No source file loaded.");
            this.sourceList.setListData(this.sourceCode);
            Vector<String> vector = new Vector<String>();
            vector.addElement("No modified memory.");
            this.memoryList.setListData(vector);
            this.commandResultBuffer = this.commandProcessor.processCommand("SET REGISTER GPR $PC 0x00400000");
            String string = this.commandResultBuffer.sGetNextResponse();
            if (!string.startsWith("* SET DONE")) {
                JOptionPane.showMessageDialog(this, "Error resetting program counter.", "Error", 1);
            }
            this.displayUpdate();
            this.fileLoaded = false;
            bl = true;
        } else {
            JOptionPane.showMessageDialog(this, "Error resetting simulator.", "Error", 1);
            this.performExit();
        }
        return bl;
    }

    private void performExit() {
        if (this.commandProcessor != null) {
            this.commandResultBuffer = this.commandProcessor.processCommand("EXIT");
        }
        this.applicationX = this.getX();
        if (this.applicationX < 0) {
            this.applicationX = 0;
        }
        this.applicationY = this.getY();
        if (this.applicationY < 0) {
            this.applicationY = 0;
        }
        this.applicationWidth = this.getWidth();
        this.applicationHeight = this.getHeight();
        this.registersX = this.registerWindow.getX();
        this.registersY = this.registerWindow.getY();
        this.registersWidth = this.registerWindow.getWidth();
        this.registersHeight = this.registerWindow.getHeight();
        this.registerWindowIsIcon = this.registerWindow.isIcon();
        this.memoryX = this.memoryWindow.getX();
        this.memoryY = this.memoryWindow.getY();
        this.memoryWidth = this.memoryWindow.getWidth();
        this.memoryHeight = this.memoryWindow.getHeight();
        this.memoryWindowIsIcon = this.memoryWindow.isIcon();
        this.sourceX = this.sourceWindow.getX();
        this.sourceY = this.sourceWindow.getY();
        this.sourceWidth = this.sourceWindow.getWidth();
        this.sourceHeight = this.sourceWindow.getHeight();
        this.sourceWindowIsIcon = this.sourceWindow.isIcon();
        this.consoleX = this.consoleWindow.getX();
        this.consoleY = this.consoleWindow.getY();
        this.consoleWidth = this.consoleWindow.getWidth();
        this.consoleHeight = this.consoleWindow.getHeight();
        this.consoleWindowIsIcon = this.consoleWindow.isIcon();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile("jimswing.cfg", "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found in TopLevelWindow.performExit.");
        }
        this.writeConfig(randomAccessFile);
        System.exit(0);
    }

    private void restoreWindows() {
        this.removeComponentListener(this);
        this.applicationX = (int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 4.0);
        this.applicationY = (int)(Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 8.0);
        this.applicationWidth = (int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2.0);
        this.applicationHeight = (int)(3.0 * (Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 4.0));
        this.desktopPaneWidth = this.applicationWidth - this.xCorrection;
        this.desktopPaneHeight = this.applicationHeight - this.yCorrection;
        this.registersX = 0;
        this.registersY = 0;
        this.registersWidth = (int)((Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.xCorrection) / 2.0);
        this.registersHeight = this.desktopPaneHeight / 4;
        this.registerWindowIsIcon = false;
        if (this.registerWindow != null) {
            this.registerWindow.setBounds(this.registersX, this.registersY, this.registersWidth, this.registersHeight);
            try {
                this.registerWindow.setSelected(true);
                this.registerWindow.setIcon(false);
                this.registerWindowIsIcon = false;
                this.showRegisterWindow.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.out.println("Error iconifying/deiconifying window in TopLevelWindow.restoreWindows.");
            }
        }
        this.memoryX = 0;
        this.memoryY = 1 * (this.desktopPaneHeight / 4);
        this.memoryWidth = (int)((Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.xCorrection) / 2.0);
        this.memoryHeight = this.desktopPaneHeight / 4;
        this.memoryWindowIsIcon = false;
        if (this.memoryWindow != null) {
            this.memoryWindow.setBounds(this.memoryX, this.memoryY, this.memoryWidth, this.memoryHeight);
            try {
                this.memoryWindow.setIcon(false);
                this.memoryWindowIsIcon = false;
                this.showMemoryWindow.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.out.println("Error iconifying/deiconifying window in TopLevelWindow.restoreWindows.");
            }
        }
        this.sourceX = 0;
        this.sourceY = 2 * (this.desktopPaneHeight / 4);
        this.sourceWidth = (int)((Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.xCorrection) / 2.0);
        this.sourceHeight = this.desktopPaneHeight / 4;
        this.sourceWindowIsIcon = false;
        if (this.sourceWindow != null) {
            this.sourceWindow.setBounds(this.sourceX, this.sourceY, this.sourceWidth, this.sourceHeight);
            try {
                this.sourceWindow.setIcon(false);
                this.sourceWindowIsIcon = false;
                this.showSourceWindow.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.out.println("Error iconifying/deiconifying window in TopLevelWindow.restoreWindows.");
            }
        }
        this.consoleX = 0;
        this.consoleY = 3 * (this.desktopPaneHeight / 4);
        this.consoleWidth = (int)((Toolkit.getDefaultToolkit().getScreenSize().getWidth() - (double)this.xCorrection) / 2.0);
        this.consoleHeight = this.desktopPaneHeight / 4;
        this.consoleWindowIsIcon = false;
        if (this.consoleWindow != null) {
            this.consoleWindow.setBounds(this.consoleX, this.consoleY, this.consoleWidth, this.consoleHeight);
            try {
                this.consoleWindow.setIcon(false);
                this.consoleWindowIsIcon = false;
                this.showConsoleWindow.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.out.println("Error iconifying/deiconifying window in TopLevelWindow.restoreWindows.");
            }
        }
        ((Component)this).setLocation(this.applicationX, this.applicationY);
        ((Component)this).setSize(this.applicationWidth, this.applicationHeight);
        this.addComponentListener(this);
    }

    private void restoreConfigFile() {
        this.openDir = "nonespecified";
        this.restoreWindows();
        this.GPRHex = true;
        this.SFPHex = true;
        this.DFPHex = true;
        this.ignoreInvalidAT = false;
        File file = new File("jimswing.cfg");
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            System.err.println("Error creating file in TopLevelWindow.restoreConfigFile.");
            JOptionPane.showMessageDialog(this, "Error creating configuration file.", "Error", 1);
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found in TopLevelWindow.restoreConfigFile.");
        }
        this.writeConfig(randomAccessFile);
    }

    private void writeConfig(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.writeUTF(this.openDir);
            randomAccessFile.writeInt(this.applicationX);
            randomAccessFile.writeInt(this.applicationY);
            randomAccessFile.writeInt(this.applicationWidth);
            randomAccessFile.writeInt(this.applicationHeight);
            randomAccessFile.writeInt(this.registersX);
            randomAccessFile.writeInt(this.registersY);
            randomAccessFile.writeInt(this.registersWidth);
            randomAccessFile.writeInt(this.registersHeight);
            randomAccessFile.writeBoolean(this.registerWindowIsIcon);
            randomAccessFile.writeInt(this.memoryX);
            randomAccessFile.writeInt(this.memoryY);
            randomAccessFile.writeInt(this.memoryWidth);
            randomAccessFile.writeInt(this.memoryHeight);
            randomAccessFile.writeBoolean(this.memoryWindowIsIcon);
            randomAccessFile.writeInt(this.sourceX);
            randomAccessFile.writeInt(this.sourceY);
            randomAccessFile.writeInt(this.sourceWidth);
            randomAccessFile.writeInt(this.sourceHeight);
            randomAccessFile.writeBoolean(this.sourceWindowIsIcon);
            randomAccessFile.writeInt(this.consoleX);
            randomAccessFile.writeInt(this.consoleY);
            randomAccessFile.writeInt(this.consoleWidth);
            randomAccessFile.writeInt(this.consoleHeight);
            randomAccessFile.writeBoolean(this.consoleWindowIsIcon);
            randomAccessFile.writeBoolean(this.GPRHex);
            randomAccessFile.writeBoolean(this.SFPHex);
            randomAccessFile.writeBoolean(this.DFPHex);
            randomAccessFile.writeBoolean(this.ignoreInvalidAT);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println("Error writing to file in TopLevelWindow.writeConfig.");
            JOptionPane.showMessageDialog(this, "Error writing configuration file.", "Error", 1);
        }
    }

    private void updateConsole() {
        int n = this.consoleText.getText().length() - 1;
        if (n >= 0) {
            this.consoleText.setCaretPosition(n);
        }
    }

    private void updateMemory() {
        if (this.commandProcessor != null) {
            String string;
            Vector<String> vector = new Vector<String>();
            StringBuffer stringBuffer = new StringBuffer();
            this.commandResultBuffer = this.commandProcessor.processCommand("GET MEMORY MODIFIED");
            while (!(string = this.commandResultBuffer.sGetNextResponse()).equals("* GET DONE")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(stringTokenizer.nextToken());
                stringBuffer2.append(stringTokenizer.nextToken());
                stringBuffer2.append(stringTokenizer.nextToken());
                String string2 = stringTokenizer.nextToken();
                stringBuffer.append("[" + string2 + "]: ");
                int n = Utility.iHexStrToInt(string2);
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    stringBuffer.append(string3 + " ");
                    if (++n2 != 16) continue;
                    n2 = 0;
                    n += 16;
                    if (!stringTokenizer.hasMoreTokens()) continue;
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("[" + Utility.sAsHexPadded(n, 8) + "]: ");
                }
                vector.addElement(stringBuffer.toString());
                vector.addElement(" ");
                stringBuffer = new StringBuffer();
            }
            if (vector.isEmpty()) {
                vector.addElement("No modified memory.");
            }
            this.memoryList.setListData(vector);
        }
    }

    private void updateRegisters() {
        this.registersContent = new StringBuffer();
        int n = 0;
        if (this.registerList.getFirstVisibleIndex() != -1) {
            n = this.registerList.getFirstVisibleIndex();
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("PC  = " + this.getRegisterValue("GPR", "$PC") + "  " + "EPC  = " + this.getRegisterValue("CP0", "$EPC") + "  " + "Cause    = " + this.getRegisterValue("CP0", "$CAUSE") + "  " + "SR   = " + this.getRegisterValue("CP0", "$SR"));
        vector.addElement("HI  = " + this.getRegisterValue("GPR", "$HI") + "  " + "LO   = " + this.getRegisterValue("GPR", "$LO") + "  " + "BadVAddr = " + this.getRegisterValue("CP0", "$BADVADDR") + "  " + "PrID = " + this.getRegisterValue("CP0", "$PRID"));
        vector.addElement(" ");
        vector.addElement("                      General Registers");
        vector.addElement("R00 (r0) = " + this.getRegisterValue("GPR", "$ZERO") + "  " + "R08 (t0) = " + this.getRegisterValue("GPR", "$T0") + "  " + "R16 (s0) = " + this.getRegisterValue("GPR", "$S0") + "  " + "R24 (t8) = " + this.getRegisterValue("GPR", "$T8"));
        vector.addElement("R01 (at) = " + this.getRegisterValue("GPR", "$AT") + "  " + "R09 (t1) = " + this.getRegisterValue("GPR", "$T1") + "  " + "R17 (s1) = " + this.getRegisterValue("GPR", "$S1") + "  " + "R25 (t9) = " + this.getRegisterValue("GPR", "$T9"));
        vector.addElement("R02 (v0) = " + this.getRegisterValue("GPR", "$V0") + "  " + "R10 (t2) = " + this.getRegisterValue("GPR", "$T2") + "  " + "R18 (s2) = " + this.getRegisterValue("GPR", "$S2") + "  " + "R26 (k0) = " + this.getRegisterValue("GPR", "$K0"));
        vector.addElement("R03 (v1) = " + this.getRegisterValue("GPR", "$V1") + "  " + "R11 (t3) = " + this.getRegisterValue("GPR", "$T3") + "  " + "R19 (s3) = " + this.getRegisterValue("GPR", "$S3") + "  " + "R27 (k1) = " + this.getRegisterValue("GPR", "$K1"));
        vector.addElement("R04 (a0) = " + this.getRegisterValue("GPR", "$A0") + "  " + "R12 (t4) = " + this.getRegisterValue("GPR", "$T4") + "  " + "R20 (s4) = " + this.getRegisterValue("GPR", "$S4") + "  " + "R28 (gp) = " + this.getRegisterValue("GPR", "$GP"));
        vector.addElement("R05 (a1) = " + this.getRegisterValue("GPR", "$A1") + "  " + "R13 (t5) = " + this.getRegisterValue("GPR", "$T5") + "  " + "R21 (s5) = " + this.getRegisterValue("GPR", "$S5") + "  " + "R29 (sp) = " + this.getRegisterValue("GPR", "$SP"));
        vector.addElement("R06 (a2) = " + this.getRegisterValue("GPR", "$A2") + "  " + "R14 (t6) = " + this.getRegisterValue("GPR", "$T6") + "  " + "R22 (s6) = " + this.getRegisterValue("GPR", "$S6") + "  " + "R30 (fp) = " + this.getRegisterValue("GPR", "$FP"));
        vector.addElement("R07 (a3) = " + this.getRegisterValue("GPR", "$A3") + "  " + "R15 (t7) = " + this.getRegisterValue("GPR", "$T7") + "  " + "R23 (s7) = " + this.getRegisterValue("GPR", "$S7") + "  " + "R31 (ra) = " + this.getRegisterValue("GPR", "$RA"));
        vector.addElement(" ");
        vector.addElement("                      Single Floating Point Registers");
        vector.addElement("FP0  = " + this.getFPRegisterValue("CP1", "$FP0") + "  " + "FP8  = " + this.getFPRegisterValue("CP1", "$FP8") + "  " + "FP16 = " + this.getFPRegisterValue("CP1", "$FP16") + "  " + "FP24 = " + this.getFPRegisterValue("CP1", "$FP24"));
        vector.addElement("FP1  = " + this.getFPRegisterValue("CP1", "$FP1") + "  " + "FP9  = " + this.getFPRegisterValue("CP1", "$FP9") + "  " + "FP17 = " + this.getFPRegisterValue("CP1", "$FP17") + "  " + "FP25 = " + this.getFPRegisterValue("CP1", "$FP25"));
        vector.addElement("FP2  = " + this.getFPRegisterValue("CP1", "$FP2") + "  " + "FP10 = " + this.getFPRegisterValue("CP1", "$FP10") + "  " + "FP18 = " + this.getFPRegisterValue("CP1", "$FP18") + "  " + "FP26 = " + this.getFPRegisterValue("CP1", "$FP26"));
        vector.addElement("FP3  = " + this.getFPRegisterValue("CP1", "$FP3") + "  " + "FP11 = " + this.getFPRegisterValue("CP1", "$FP11") + "  " + "FP19 = " + this.getFPRegisterValue("CP1", "$FP19") + "  " + "FP27 = " + this.getFPRegisterValue("CP1", "$FP27"));
        vector.addElement("FP4  = " + this.getFPRegisterValue("CP1", "$FP4") + "  " + "FP12 = " + this.getFPRegisterValue("CP1", "$FP12") + "  " + "FP20 = " + this.getFPRegisterValue("CP1", "$FP20") + "  " + "FP28 = " + this.getFPRegisterValue("CP1", "$FP28"));
        vector.addElement("FP5  = " + this.getFPRegisterValue("CP1", "$FP5") + "  " + "FP13 = " + this.getFPRegisterValue("CP1", "$FP13") + "  " + "FP21 = " + this.getFPRegisterValue("CP1", "$FP21") + "  " + "FP29 = " + this.getFPRegisterValue("CP1", "$FP29"));
        vector.addElement("FP6  = " + this.getFPRegisterValue("CP1", "$FP6") + "  " + "FP14 = " + this.getFPRegisterValue("CP1", "$FP14") + "  " + "FP22 = " + this.getFPRegisterValue("CP1", "$FP22") + "  " + "FP30 = " + this.getFPRegisterValue("CP1", "$FP30"));
        vector.addElement("FP7  = " + this.getFPRegisterValue("CP1", "$FP7") + "  " + "FP15 = " + this.getFPRegisterValue("CP1", "$FP15") + "  " + "FP23 = " + this.getFPRegisterValue("CP1", "$FP23") + "  " + "FP31 = " + this.getFPRegisterValue("CP1", "$FP31"));
        vector.addElement(" ");
        vector.addElement("                      Double Floating Point Registers");
        vector.addElement("FP0  = " + this.getDoubleFPRegisterValue("CP1", "$FP0", "$FP1") + "  " + "FP8  = " + this.getDoubleFPRegisterValue("CP1", "$FP8", "$FP9") + "  " + "FP16 = " + this.getDoubleFPRegisterValue("CP1", "$FP16", "$FP17") + "  " + "FP24 = " + this.getDoubleFPRegisterValue("CP1", "$FP24", "$FP25"));
        vector.addElement("FP2  = " + this.getDoubleFPRegisterValue("CP1", "$FP2", "$FP3") + "  " + "FP10 = " + this.getDoubleFPRegisterValue("CP1", "$FP10", "$FP11") + "  " + "FP18 = " + this.getDoubleFPRegisterValue("CP1", "$FP18", "$FP19") + "  " + "FP26 = " + this.getDoubleFPRegisterValue("CP1", "$FP26", "$FP27"));
        vector.addElement("FP4  = " + this.getDoubleFPRegisterValue("CP1", "$FP4", "$FP5") + "  " + "FP12 = " + this.getDoubleFPRegisterValue("CP1", "$FP12", "$FP13") + "  " + "FP20 = " + this.getDoubleFPRegisterValue("CP1", "$FP20", "$FP21") + "  " + "FP28 = " + this.getDoubleFPRegisterValue("CP1", "$FP28", "$FP29"));
        vector.addElement("FP6  = " + this.getDoubleFPRegisterValue("CP1", "$FP6", "$FP7") + "  " + "FP14 = " + this.getDoubleFPRegisterValue("CP1", "$FP14", "$FP15") + "  " + "FP22 = " + this.getDoubleFPRegisterValue("CP1", "$FP22", "$FP23") + "  " + "FP30 = " + this.getDoubleFPRegisterValue("CP1", "$FP30", "$FP31"));
        this.registerList.setListData(vector);
        this.registerList.ensureIndexIsVisible(n);
    }

    private int assemblyPhase1(String string, String string2, String string3, boolean bl) {
        Vector vector = Utility.vLoadFileAsVector(string);
        if (vector == null) {
            JOptionPane.showMessageDialog(this, "Error loading " + string + " for phase 1 assembler processing.", "Error", 0);
            return 1;
        }
        Assembler assembler = new Assembler(string2 + File.separator + string3 + ".modified");
        assembler.reset();
        Enumeration enumeration = vector.elements();
        int n = this.assemblyPhase1Processing(assembler, enumeration);
        if (!bl && assembler.iGetLastInvalidUseOfAT() != -1) {
            int n2 = assembler.iGetLastInvalidUseOfAT();
            JOptionPane.showMessageDialog(this, "Line " + n2 + ": Invalid use of $at register.", "Error", 0);
            ++n;
        }
        if (n > 0) {
            JOptionPane.showMessageDialog(this, n + " error(s) detected during phase 1.", "Error", 0);
        }
        return n;
    }

    private int assemblyPhase2(String string, String string2, String string3, boolean bl) {
        Vector vector = Utility.vLoadFileAsVector(string);
        if (vector == null) {
            JOptionPane.showMessageDialog(this, "Error loading " + string + " for phase 2 assembler processing.", "Error", 0);
            return 1;
        }
        Assembler assembler = new Assembler();
        assembler.reset();
        Enumeration enumeration = vector.elements();
        int n = this.assemblyPhase1Processing(assembler, enumeration);
        if (!bl && assembler.iGetLastInvalidUseOfAT() != -1) {
            int n2 = assembler.iGetLastInvalidUseOfAT();
            JOptionPane.showMessageDialog(this, "Line " + n2 + ": Invalid use of $at register.", "Error", 0);
            ++n;
        }
        if (n > 0) {
            JOptionPane.showMessageDialog(this, n + " error(s) detected during phase 1.\nAssembler process cancelled.", "Error", 0);
        }
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = assembler.sbGetMachineCode(string3);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error", 0);
        }
        int n3 = assembler.iGetNumPhaseTwoErrors();
        if (n3 > 0) {
            JOptionPane.showMessageDialog(this, "Error(s) encountered during phase 2 of assembly.", "Error", 0);
        } else {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2 + File.separator + string3 + ".code"));
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error outputting machine code in assembly phase 2.", "Error", 0);
            }
        }
        return n3 + n;
    }

    private int assemblyPhase1Processing(Assembler assembler, Enumeration enumeration) {
        int n = 0;
        int n2 = 0;
        this.showMoreErrors = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ++n;
            boolean bl = false;
            try {
                assembler.iProcessLine(string, n);
            }
            catch (Exception exception) {
                ++n2;
                if (!this.showMoreErrors) continue;
                Object[] objectArray = new Object[]{"Show more errors", "Stop"};
                int n3 = JOptionPane.showOptionDialog(this, exception.getMessage(), "Error", 0, 0, null, objectArray, objectArray[0]);
                if (n3 == 0) continue;
                this.showMoreErrors = false;
            }
        }
        return n2;
    }

    private String getRegisterValue(String string, String string2) {
        this.commandResultBuffer = this.commandProcessor.processCommand("GET REGISTER " + string + " " + string2);
        String string3 = this.commandResultBuffer.sGetNextResponse();
        String string4 = new String();
        if (string3.startsWith("* GET REGISTER " + string.toUpperCase() + " ")) {
            string4 = string3 = string3.substring(22);
        }
        if (!(!string.toUpperCase().equals("GPR") || string2.toUpperCase().equals("$PC") || string2.toUpperCase().equals("$LO") || string2.toUpperCase().equals("$HI") || this.GPRHex)) {
            string4 = new Long(Long.parseLong(string4, 16)).toString();
        }
        return Utility.sPad(string4, 8);
    }

    private String getFPRegisterValue(String string, String string2) {
        String string3 = this.getRegisterValue(string, string2).trim();
        if (!this.SFPHex) {
            int n = Integer.parseInt(string3.substring(0, 1), 16);
            int n2 = 0;
            float f = 0.0f;
            if (n > 7) {
                string3 = Integer.toHexString(n ^= 8).concat(string3.substring(1));
                n2 = Integer.parseInt(string3, 16);
                f = Float.intBitsToFloat(n2) * -1.0f;
            } else {
                n2 = Integer.parseInt(string3, 16);
                f = Float.intBitsToFloat(n2);
            }
            string3 = Float.toString(f);
            if (string3.length() > 12) {
                int n3 = string3.indexOf("E");
                if (n3 != -1) {
                    String string4 = string3.substring(n3);
                    int n4 = string3.length() - 1 - n3;
                    String string5 = new String();
                    string5 = n3 + string4.length() >= 12 ? string3.substring(0, 12 - string4.length()) : string3.substring(0, n3);
                    string3 = string5 + string4;
                } else {
                    string3 = string3.substring(12);
                }
            }
        }
        return Utility.sPad(string3, 12);
    }

    private String getDoubleFPRegisterValue(String string, String string2, String string3) {
        String string4 = this.getRegisterValue(string, string2).trim();
        String string5 = this.getRegisterValue(string, string3).trim();
        String string6 = new String();
        if (this.DFPHex) {
            string6 = string5 + string4;
        } else {
            long l = 0L;
            double d = 0.0;
            String string7 = string5 + string4;
            int n = Integer.parseInt(string7.substring(0, 1), 16);
            if (n > 7) {
                string7 = Integer.toHexString(n ^= 8).concat(string7.substring(1));
                l = Long.parseLong(string7, 16);
                d = Double.longBitsToDouble(l) * -1.0;
            } else {
                l = Long.parseLong(string7, 16);
                d = Double.longBitsToDouble(l);
            }
            string6 = Double.toString(d);
            if (string6.length() > 12) {
                int n2 = string6.indexOf("E");
                if (n2 != -1) {
                    String string8 = string6.substring(n2);
                    int n3 = string6.length() - 1 - n2;
                    String string9 = new String();
                    string9 = n2 + string8.length() >= 12 ? string6.substring(0, 12 - string8.length()) : string6.substring(0, n2);
                    string6 = string9 + string8;
                } else {
                    string6 = string6.substring(12);
                }
            }
        }
        return Utility.sPad(string6, 12);
    }

    private void highlightSourceLine(String string) {
        if (this.sourceLinks != null) {
            Enumeration enumeration = this.sourceLinks.elements();
            while (enumeration.hasMoreElements()) {
                sourceLink sourceLink2 = (sourceLink)enumeration.nextElement();
                if (!sourceLink2.pc.equals(string)) continue;
                this.sourceList.setSelectionInterval(sourceLink2.line - 1, -808);
                this.sourceList.ensureIndexIsVisible(sourceLink2.line - 1);
            }
        }
    }

    public void displayUpdate() {
        this.updateRegisters();
        this.updateMemory();
        this.highlightSourceLine(this.getRegisterValue("GPR", "$PC"));
        this.updateConsole();
        this.validate();
    }

    private class sourceLink {
        public String pc;
        public int line;

        public sourceLink(String string, int n) {
            this.pc = string;
            this.line = n;
        }
    }

    private class runThread
    extends Thread {
        private boolean runForward;

        public runThread(String string, boolean bl) {
            super(string);
            this.runForward = bl;
        }

        public void run() {
            while (TopLevelWindow.this.shouldRun) {
                if (this.runForward) {
                    TopLevelWindow.this.performForwardStep(false);
                    continue;
                }
                TopLevelWindow.this.performBackStep(false);
            }
        }
    }
}

