/*
 * Decompiled with CFR 0.152.
 */
package JIMSwingGUI;

import JIMSCore.CommandProcessor;
import JIMSCore.CommandResultBuffer;
import JIMSwingGUI.TopLevelWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class RegisterEditDialog
extends JDialog
implements ActionListener {
    private TopLevelWindow parent;
    private CommandProcessor commandProcessor;
    private static Vector registersAndSets;
    private static Vector registersAsList;
    private static Vector floatingPointList;
    private Vector setList;
    private JTextField value;
    private JComboBox regList;
    private JComboBox setListBox;
    private JButton applyButton;
    private JButton closeButton;
    private String returnValue = null;

    public RegisterEditDialog(TopLevelWindow topLevelWindow, CommandProcessor commandProcessor) {
        super(topLevelWindow, "Modify register", true);
        Object object;
        this.setUpRegisterVectors();
        this.parent = topLevelWindow;
        this.setList = new Vector();
        this.setList.addElement("General Purpose");
        this.setList.addElement("Floating Point");
        this.commandProcessor = commandProcessor;
        JLabel jLabel = new JLabel("Set: ");
        this.setListBox = new JComboBox(this.setList);
        this.setListBox.setSelectedIndex(0);
        this.setListBox.addActionListener(this);
        JLabel jLabel2 = new JLabel("Register: ");
        this.regList = new JComboBox();
        Enumeration enumeration = registersAsList.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            this.regList.addItem(object);
        }
        object = new JLabel("Value: ");
        this.value = new JTextField();
        this.applyButton = new JButton("Apply");
        this.applyButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.applyButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.applyButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 10)));
        jPanel.add(this.closeButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 5, 10));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
        jPanel2.add(jLabel);
        jPanel2.add(this.setListBox);
        jPanel2.add(jLabel2);
        jPanel2.add(this.regList);
        jPanel2.add((Component)object);
        jPanel2.add(this.value);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)new JPanel(), "North");
        jPanel4.add((Component)new JPanel(), "South");
        jPanel4.add((Component)new JPanel(), "West");
        jPanel4.add((Component)new JPanel(), "East");
        jPanel4.add((Component)jPanel3, "Center");
        this.setContentPane(jPanel4);
        this.setResizable(false);
        this.pack();
        ((Component)this).setLocation(new Point(topLevelWindow.getX() + (topLevelWindow.getWidth() - this.getWidth()) / 2, topLevelWindow.getY() + (topLevelWindow.getHeight() - this.getHeight()) / 2));
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object;
        Object object2 = actionEvent.getSource();
        if (object2 == this.applyButton) {
            String string2 = ((String)this.regList.getSelectedItem()).toUpperCase();
            object = this.value.getText();
            string = new String();
            Enumeration enumeration = registersAndSets.elements();
            while (enumeration.hasMoreElements()) {
                registerInfo registerInfo2 = (registerInfo)enumeration.nextElement();
                String string3 = registerInfo2.getName();
                if (!string2.equals(string3)) continue;
                string = registerInfo2.getSet();
                break;
            }
            float f = 0.0f;
            boolean bl = false;
            if (string == "CP1" && !((String)object).toUpperCase().startsWith("0X")) {
                bl = true;
                f = Float.parseFloat(object);
                object = Long.toString(Float.floatToIntBits(f));
            }
            String string4 = "SET REGISTER " + string + " $" + string2 + " " + object;
            CommandResultBuffer commandResultBuffer = this.commandProcessor.processCommand(string4);
            this.returnValue = commandResultBuffer.sGetNextResponse();
            if (this.returnValue.startsWith("* SET DONE")) {
                if (bl) {
                    JOptionPane.showMessageDialog(this, "Successfully set $" + string2 + " to " + f, "Success", 1);
                } else {
                    JOptionPane.showMessageDialog(this, "Successfully set $" + string2 + " to " + (String)object, "Success", 1);
                }
                this.parent.displayUpdate();
            } else {
                JOptionPane.showMessageDialog(this, "Invalid register or value.", "Error", 0);
            }
            this.value.setText(null);
        }
        if (object2 == this.closeButton) {
            this.dispose();
        }
        if (object2 == this.setListBox) {
            int n = this.setListBox.getSelectedIndex();
            if (n == 0) {
                this.regList.removeAllItems();
                object = registersAsList.elements();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    this.regList.addItem(string);
                }
            }
            if (n == 1) {
                this.regList.removeAllItems();
                object = floatingPointList.elements();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    this.regList.addItem(string);
                }
            }
        }
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    private void setUpRegisterVectors() {
        registersAndSets = new Vector();
        registerInfo registerInfo2 = new registerInfo("GPR", "PC");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "HI");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "LO");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "AT");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "V0");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "V1");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "A0");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "A1");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "A2");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "A3");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T0");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T1");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T2");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T3");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T4");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T5");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T6");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T7");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "S0");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "S1");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "S2");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "S3");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "S4");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "S5");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "S6");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "S7");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T8");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "T9");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "K0");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "K1");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "GP");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "SP");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "FP");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("GPR", "RA");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP0");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP1");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP2");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP3");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP4");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP5");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP6");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP7");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP8");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP9");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP10");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP11");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP12");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP13");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP14");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP15");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP16");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP17");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP18");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP19");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP20");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP21");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP22");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP23");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP24");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP25");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP26");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP27");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP28");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP29");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP30");
        registersAndSets.add(registerInfo2);
        registerInfo2 = new registerInfo("CP1", "FP31");
        registersAndSets.add(registerInfo2);
        registersAsList = new Vector();
        floatingPointList = new Vector();
        Enumeration enumeration = registersAndSets.elements();
        while (enumeration.hasMoreElements()) {
            registerInfo registerInfo3 = (registerInfo)enumeration.nextElement();
            if (registerInfo3.getSet() == "GPR") {
                registersAsList.addElement(registerInfo3.getName().toLowerCase());
            }
            if (registerInfo3.getSet() != "CP1") continue;
            floatingPointList.addElement(registerInfo3.getName().toLowerCase());
        }
    }

    private class registerInfo {
        String set;
        String name;

        public registerInfo(String string, String string2) {
            this.set = string;
            this.name = string2;
        }

        public String getSet() {
            return this.set;
        }

        public String getName() {
            return this.name;
        }
    }
}

