/*
 * Decompiled with CFR 0.152.
 */
package JIMSwingGUI;

import JIMSCore.CommandProcessor;
import JIMSCore.CommandResultBuffer;
import JIMSwingGUI.TopLevelWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class MemoryEditDialog
extends JDialog
implements ActionListener {
    private CommandProcessor commandProcessor;
    private TopLevelWindow parent;
    private JTextField memoryStart;
    private JTextField memoryEnd;
    private JTextField value;
    private JButton applyButton;
    private JButton closeButton;
    private String returnValue;

    public MemoryEditDialog(TopLevelWindow topLevelWindow, CommandProcessor commandProcessor) {
        super(topLevelWindow, "Modify memory", true);
        this.commandProcessor = commandProcessor;
        this.parent = topLevelWindow;
        JLabel jLabel = new JLabel("Starting address: ");
        JLabel jLabel2 = new JLabel("Ending address: ");
        this.memoryStart = new JTextField();
        this.memoryEnd = new JTextField();
        JLabel jLabel3 = new JLabel("Value: ");
        this.value = new JTextField();
        this.applyButton = new JButton("Apply");
        this.applyButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.applyButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        jPanel.add(this.applyButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 10)));
        jPanel.add(this.closeButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 5, 10));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
        jPanel2.add(jLabel);
        jPanel2.add(this.memoryStart);
        jPanel2.add(jLabel2);
        jPanel2.add(this.memoryEnd);
        jPanel2.add(jLabel3);
        jPanel2.add(this.value);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel);
        this.setContentPane(jPanel3);
        this.setResizable(false);
        this.pack();
        ((Component)this).setLocation(new Point(topLevelWindow.getX() + (topLevelWindow.getWidth() - this.getWidth()) / 2, topLevelWindow.getY() + (topLevelWindow.getHeight() - this.getHeight()) / 2));
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.applyButton) {
            String string = this.memoryStart.getText();
            String string2 = this.memoryEnd.getText();
            String string3 = this.value.getText();
            String string4 = new String();
            string4 = string2.length() != 0 ? "SET MEMORY " + string + "-" + string2 + " " + string3 : "SET MEMORY " + string + " " + string3;
            CommandResultBuffer commandResultBuffer = this.commandProcessor.processCommand(string4);
            this.returnValue = commandResultBuffer.sGetNextResponse();
            if (this.returnValue.startsWith("* SET DONE")) {
                this.parent.displayUpdate();
                JOptionPane.showMessageDialog(this, "Successfully modified memory.", "Success", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Invalid range or value.", "Error", 0);
            }
            this.memoryStart.setText(null);
            this.memoryEnd.setText(null);
            this.value.setText(null);
        }
        if (object == this.closeButton) {
            this.dispose();
        }
    }

    public String getReturnValue() {
        return this.returnValue;
    }
}

