/*
 * Decompiled with CFR 0.152.
 */
package JIMSwingGUI;

import JIMSCore.CommandProcessor;
import JIMSCore.CommandResultBuffer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class InputDialog
extends JDialog
implements ActionListener {
    private CommandProcessor commandProcessor;
    private JPanel contentPane;
    private JPanel intermediatePane;
    private JTextField value;
    private JButton accept;
    private JButton cancel;
    private String returnValue = null;

    public InputDialog(Frame frame, CommandProcessor commandProcessor) {
        super(frame, "Console input", true);
        this.commandProcessor = commandProcessor;
        JLabel jLabel = new JLabel("Input: ");
        this.value = new JTextField();
        this.accept = new JButton("Apply");
        this.accept.setMnemonic(65);
        this.accept.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.accept);
        this.accept.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.setMnemonic(67);
        this.cancel.addActionListener(this);
        this.intermediatePane = new JPanel();
        this.intermediatePane.setLayout(new GridLayout(0, 2, 5, 10));
        this.intermediatePane.add(jLabel);
        this.intermediatePane.add(this.value);
        this.intermediatePane.add(this.accept);
        this.intermediatePane.add(this.cancel);
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.intermediatePane, "Center");
        this.contentPane.add((Component)new JPanel(), "North");
        this.contentPane.add((Component)new JPanel(), "South");
        this.contentPane.add((Component)new JPanel(), "East");
        this.contentPane.add((Component)new JPanel(), "West");
        this.setContentPane(this.contentPane);
        this.setResizable(false);
        this.pack();
        ((Component)this).setLocation(new Point(frame.getX() + (frame.getWidth() - this.getWidth()) / 2, frame.getY() + (frame.getHeight() - this.getHeight()) / 2));
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.accept) {
            CommandResultBuffer commandResultBuffer = this.commandProcessor.processCommand("INPUT \"" + this.value.getText() + "\"");
            this.returnValue = commandResultBuffer.sGetNextResponse();
            this.dispose();
        }
        if (actionEvent.getSource() == this.cancel) {
            this.dispose();
        }
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public String getText() {
        return this.value.getText();
    }
}

