/*
 * Decompiled with CFR 0.152.
 */
package JIMSwingGUI;

import JIMSwingGUI.TopLevelWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;

public class HelpWindow
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JButton backButton;
    private JButton contentsButton;
    private JButton closeButton;
    private Vector backList;
    private URL contentsURL;
    private TopLevelWindow parentWindow;
    private JEditorPane helpContents;
    private JScrollPane scroller;

    public HelpWindow(TopLevelWindow topLevelWindow) {
        this.parentWindow = topLevelWindow;
        this.backList = new Vector();
        this.contentsButton = new JButton("Contents");
        this.contentsButton.addActionListener(this);
        this.backButton = new JButton("Back");
        this.backButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 10, 5));
        jPanel.add(this.contentsButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 10)));
        jPanel.add(this.backButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 10)));
        jPanel.add(this.closeButton);
        this.helpContents = new JEditorPane();
        this.helpContents.setEditorKit(new HTMLEditorKit());
        try {
            this.helpContents = new JEditorPane("file:." + System.getProperty("file.separator") + "help" + System.getProperty("file.separator") + "help.html");
            this.contentsURL = this.helpContents.getPage();
        }
        catch (IOException iOException) {
            System.err.println("Error opening help file in HelpWindow constructor.");
        }
        this.helpContents.setSelectionColor(MetalLookAndFeel.getWhite());
        this.helpContents.setEditable(false);
        this.helpContents.addHyperlinkListener(this);
        this.scroller = new JScrollPane(this.helpContents, 20, 30);
        this.scroller.getViewport().setScrollMode(0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        jPanel2.add(this.scroller);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)new JPanel(), "North");
        jPanel3.add((Component)new JPanel(), "South");
        jPanel3.add((Component)new JPanel(), "East");
        jPanel3.add((Component)new JPanel(), "West");
        this.setContentPane(jPanel3);
        this.pack();
        ((Component)this).setSize(topLevelWindow.getWidth() / 2, topLevelWindow.getHeight() / 2);
        this.setResizable(true);
        ((Component)this).setLocation(new Point(topLevelWindow.getX() + (topLevelWindow.getWidth() - this.getWidth()) / 2, topLevelWindow.getY() + (topLevelWindow.getHeight() - this.getHeight()) / 2));
        this.setTitle("JIMSwing Help");
        ((Component)this).setVisible(true);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.backList.addElement(this.helpContents.getPage());
                this.helpContents.setPage(hyperlinkEvent.getURL());
            }
            catch (Exception exception) {
                System.err.println("Error opening html file in HelpWindow.hyperlinkUpdate.");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.backButton && this.backList.size() != 0) {
            URL uRL = (URL)this.backList.remove(this.backList.size() - 1);
            try {
                this.helpContents.setPage(uRL);
            }
            catch (Exception exception) {
                System.err.println("Error opening html file in HelpWindow.hyperlinkUpdate.");
            }
        }
        if (object == this.contentsButton) {
            this.backList.addElement(this.helpContents.getPage());
            try {
                this.helpContents.setPage(this.contentsURL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (object == this.closeButton) {
            this.dispose();
        }
    }
}

