/*
 * Decompiled with CFR 0.152.
 */
package JIMSwingGUI;

import JIMSCore.CommandProcessor;
import JIMSCore.CommandResultBuffer;
import JIMSwingGUI.SourceListSelectionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class BreakpointEditDialog
extends JDialog
implements ActionListener {
    private CommandProcessor commandProcessor;
    private CommandResultBuffer crb;
    private JButton addButton;
    private JButton remove;
    private JButton closeButton;
    private JList breakpointList;
    private JTextField addField;
    private JTextField removeField;
    private Vector breakpoints;

    public BreakpointEditDialog(Frame frame, CommandProcessor commandProcessor) {
        super(frame, "Breakpoints", true);
        this.commandProcessor = commandProcessor;
        this.breakpoints = new Vector();
        this.breakpointList = new JList();
        this.breakpointList.setSelectionModel(new SourceListSelectionModel());
        this.breakpointList.setVisibleRowCount(8);
        JScrollPane jScrollPane = new JScrollPane(this.breakpointList, 20, 30);
        jScrollPane.getViewport().setScrollMode(0);
        this.addButton = new JButton("Add");
        this.addButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.addButton);
        this.addButton.addActionListener(this);
        this.remove = new JButton("Remove");
        this.remove.setMnemonic(82);
        this.remove.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(this);
        JLabel jLabel = new JLabel("Address to add: ");
        this.addField = new JTextField();
        JLabel jLabel2 = new JLabel("Index to remove: ");
        this.removeField = new JTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 10));
        jPanel.add(this.addButton);
        jPanel.add(this.remove);
        jPanel.add(this.closeButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 5, 10));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel2.add(jLabel);
        jPanel2.add(this.addField);
        jPanel2.add(jLabel2);
        jPanel2.add(this.removeField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jScrollPane);
        jPanel3.add(jPanel2);
        jPanel3.add(jPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        jPanel4.add((Component)new JPanel(), "North");
        jPanel4.add((Component)new JPanel(), "South");
        jPanel4.add((Component)new JPanel(), "East");
        jPanel4.add((Component)new JPanel(), "West");
        this.setContentPane(jPanel4);
        this.setResizable(false);
        this.pack();
        ((Component)this).setLocation(new Point(frame.getX() + (frame.getWidth() - this.getWidth()) / 2, frame.getY() + (frame.getHeight() - this.getHeight()) / 2));
        this.updateDisplay();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            this.crb = this.commandProcessor.processCommand("ADD BREAKPOINT " + this.addField.getText());
            string = this.crb.sGetNextResponse();
            if (string != null) {
                if (string.startsWith("* ADD DONE")) {
                    JOptionPane.showMessageDialog(this, "Breakpoint added successfully.", "Success", 1);
                }
                if (string.startsWith("EXCEPTION")) {
                    JOptionPane.showMessageDialog(this, string.substring(10), "Error", 0);
                }
                this.addField.setText(null);
                this.removeField.setText(null);
                this.updateDisplay();
            }
        }
        if (object == this.remove) {
            string = this.removeField.getText();
            String string2 = "REMOVE BREAKPOINT " + string;
            this.crb = this.commandProcessor.processCommand(string2);
            String string3 = this.crb.sGetNextResponse();
            if (string3 != null) {
                if (string3.startsWith("* REMOVE DONE")) {
                    JOptionPane.showMessageDialog(this, "Breakpoint removed successfully.", "Success", 1);
                }
                if (string3.startsWith("EXCEPTION")) {
                    JOptionPane.showMessageDialog(this, string3.substring(10), "Error", 0);
                }
                this.addField.setText(null);
                this.removeField.setText(null);
                this.updateDisplay();
            }
        }
        if (object == this.closeButton) {
            this.dispose();
        }
    }

    private void updateDisplay() {
        this.breakpoints = new Vector();
        this.crb = this.commandProcessor.processCommand("LIST BREAKPOINT");
        String string = this.crb.sGetNextResponse();
        if (!string.startsWith("* LIST BREAKPOINT NONE")) {
            int n = 0;
            while (!string.startsWith("* LIST DONE")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(n + ": ");
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                stringBuffer.append(string6);
                this.breakpoints.addElement(stringBuffer.toString());
                string = this.crb.sGetNextResponse();
                ++n;
            }
        }
        this.breakpointList.setListData(this.breakpoints);
        this.validate();
    }
}

