/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Utility;
import java.util.StringTokenizer;

public class TextEntry {
    public static final String[][] regID = new String[][]{{"00000", "$0", "$ZERO", "$R0"}, {"00001", "$1", "$AT"}, {"00010", "$2", "$V0"}, {"00011", "$3", "$V1"}, {"00100", "$4", "$A0"}, {"00101", "$5", "$A1"}, {"00110", "$6", "$A2"}, {"00111", "$7", "$A3"}, {"01000", "$8", "$T0"}, {"01001", "$9", "$T1"}, {"01010", "$10", "$T2"}, {"01011", "$11", "$T3"}, {"01100", "$12", "$T4"}, {"01101", "$13", "$T5"}, {"01110", "$14", "$T6"}, {"01111", "$15", "$T7"}, {"10000", "$16", "$S0"}, {"10001", "$17", "$S1"}, {"10010", "$18", "$S2"}, {"10011", "$19", "$S3"}, {"10100", "$20", "$S4"}, {"10101", "$21", "$S5"}, {"10110", "$22", "$S6"}, {"10111", "$23", "$S7"}, {"11000", "$24", "$T8"}, {"11001", "$25", "$T9"}, {"11010", "$26", "$K0"}, {"11011", "$27", "$K1"}, {"11100", "$28", "$GP"}, {"11101", "$29", "$SP"}, {"11110", "$30", "$FP"}, {"11111", "$31", "$RA"}, {"00000", "$F0"}, {"00001", "$F1"}, {"00010", "$F2"}, {"00011", "$F3"}, {"00100", "$F4"}, {"00101", "$F5"}, {"00110", "$F6"}, {"00111", "$F7"}, {"01000", "$F8"}, {"01001", "$F9"}, {"01010", "$F10"}, {"01011", "$F11"}, {"01100", "$F12"}, {"01101", "$F13"}, {"01110", "$F14"}, {"01111", "$F15"}, {"10000", "$F16"}, {"10001", "$F17"}, {"10010", "$F18"}, {"10011", "$F19"}, {"10100", "$F20"}, {"10101", "$F21"}, {"10110", "$F22"}, {"10111", "$F23"}, {"11000", "$F24"}, {"11001", "$F25"}, {"11010", "$F26"}, {"11011", "$F27"}, {"11100", "$F28"}, {"11101", "$F29"}, {"11110", "$F30"}, {"11111", "$F31"}};
    public String op;
    public String rs;
    public String rt;
    public String rd;
    public String shamt;
    public String funct;
    public String fd;
    public String fs;
    public String ft;
    public String addr_imm;
    public String code;
    public String target;
    public String format;
    public String formatLen;
    public int iSourceLine;

    public TextEntry(int n) {
        this.iSourceLine = n;
    }

    public String toString() {
        return "[" + this.op + ": " + this.sGetInstruction() + "]";
    }

    public String sGetInstruction() {
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.format, "-");
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.formatLen, "-");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer2.nextToken());
            if (string2.equals("rs")) {
                string = string + this.sRegStringToRegValue(this.rs);
                continue;
            }
            if (string2.equals("rt")) {
                string = string + this.sRegStringToRegValue(this.rt);
                continue;
            }
            if (string2.equals("rd")) {
                string = string + this.sRegStringToRegValue(this.rd);
                continue;
            }
            if (string2.equals("imm")) {
                string = string + "imm(" + this.addr_imm + ")";
                continue;
            }
            if (string2.equals("branch")) {
                string = string + "branch(" + this.addr_imm + ")";
                continue;
            }
            if (string2.equals("offset")) {
                string = string + "offset(" + this.addr_imm + ")";
                continue;
            }
            if (string2.equals("target")) {
                string = string + "target(" + this.target + ")";
                continue;
            }
            if (string2.equals("code")) {
                string = string + "code(" + this.code + ")";
                continue;
            }
            if (string2.equals("shamt")) {
                string = string + "shamt(" + this.shamt + ")";
                continue;
            }
            if (string2.equals("fs")) {
                string = string + this.sRegStringToRegValue(this.fs);
                continue;
            }
            if (string2.equals("ft")) {
                string = string + this.sRegStringToRegValue(this.ft);
                continue;
            }
            if (string2.equals("fd")) {
                string = string + this.sRegStringToRegValue(this.fd);
                continue;
            }
            long l = Utility.IntegerLiteralToLong("0x" + string2);
            string = string + Utility.sAsBinaryPadded(l, n);
        }
        return string;
    }

    private String sRegStringToRegValue(String string) {
        string = string.toUpperCase();
        int n = 0;
        while (n < regID.length) {
            int n2 = 1;
            while (n2 < regID[n].length) {
                if (string.equals(regID[n][n2])) {
                    return regID[n][0];
                }
                ++n2;
            }
            ++n;
        }
        System.out.println("Invalid register: " + string);
        return "?????";
    }
}

