/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Coprocessor0;
import JIMSCore.Coprocessor1;
import JIMSCore.MainMemory;
import JIMSCore.RegisterFile;
import JIMSCore.StateHistoryBuffer;
import JIMSCore.Utility;
import java.util.Vector;

public class State {
    private MainMemory mainMemory;
    private RegisterFile registerFile;
    private Coprocessor0 coprocessor0;
    private Coprocessor1 coprocessor1;
    private StateHistoryBuffer currentStateHistoryBuffer;
    private StringBuffer sbInputBuffer;
    private StringBuffer sbOutputBuffer;
    private boolean[] baFlag;
    private Vector vModifiedMemoryAddresses;
    public static final int NUM_FLAGS = 10;
    public static final int FLAG_SC_PRINT_INT = 0;
    public static final int FLAG_SC_PRINT_FLOAT = 1;
    public static final int FLAG_SC_PRINT_DOUBLE = 2;
    public static final int FLAG_SC_PRINT_STRING = 3;
    public static final int FLAG_SC_READ_INT = 4;
    public static final int FLAG_SC_READ_FLOAT = 5;
    public static final int FLAG_SC_READ_DOUBLE = 6;
    public static final int FLAG_SC_READ_STRING = 7;
    public static final int FLAG_SC_SBRK = 8;
    public static final int FLAG_SC_EXIT = 9;
    public static final String STATE_CHANGE_FLAG = "F";
    public static final String STATE_CHANGE_MEM = "M";
    public static final String STATE_CHANGE_GPR = "R";
    public static final String STATE_CHANGE_CP0 = "0";
    public static final String STATE_CHANGE_CP1 = "1";
    public int iModifiedMemoryCount;

    public State() {
        this.reset();
    }

    public void reset() {
        this.mainMemory = new MainMemory();
        this.registerFile = new RegisterFile();
        this.baFlag = new boolean[10];
        this.sbInputBuffer = new StringBuffer();
        this.sbOutputBuffer = new StringBuffer();
        this.coprocessor0 = new Coprocessor0();
        this.coprocessor1 = new Coprocessor1();
        this.vModifiedMemoryAddresses = new Vector();
        this.iModifiedMemoryCount = 0;
    }

    public Coprocessor0 getCoprocessor0() {
        return this.coprocessor0;
    }

    public void setStateHistoryBuffer(StateHistoryBuffer stateHistoryBuffer) {
        this.currentStateHistoryBuffer = stateHistoryBuffer;
    }

    public StateHistoryBuffer getStateHistoryBuffer() {
        return this.currentStateHistoryBuffer;
    }

    private void addStateValue(String string) {
        if (this.currentStateHistoryBuffer != null) {
            this.currentStateHistoryBuffer.addStateValue(string);
        }
    }

    public void setFlag(int n, boolean bl) {
        String string = "F " + n + " ";
        string = this.baFlag[n] ? string + "T" : string + STATE_CHANGE_FLAG;
        this.addStateValue(string);
        this.baFlag[n] = bl;
    }

    public boolean getFlag(int n) {
        return this.baFlag[n];
    }

    public void storeByte(int n, byte by) {
        byte by2 = this.loadByte(n);
        if (by2 != by) {
            this.addStateValue("M " + Utility.sAsHexPadded(n, 8) + " " + Utility.sAsHexPadded(by2, 2));
        }
        this.mainMemory.storeByte(n, by);
        this.addToModifiedMemoryList(n);
    }

    public void storeHalfWord(int n, int n2) {
        int n3 = this.loadHalfWord(n);
        if (n3 != n2) {
            byte by = (byte)(((long)n2 & 0xFF00L) >>> 8);
            byte by2 = (byte)((long)n2 & 0xFFL);
            this.storeByte(n, by);
            this.storeByte(n + 1, by2);
        }
    }

    public void storeWord(int n, int n2) {
        int n3 = this.loadWord(n);
        if (n3 != n2) {
            byte by = (byte)(((long)n2 & 0xFF000000L) >>> 24);
            byte by2 = (byte)(((long)n2 & 0xFF0000L) >>> 16);
            byte by3 = (byte)(((long)n2 & 0xFF00L) >>> 8);
            byte by4 = (byte)((long)n2 & 0xFFL);
            this.storeByte(n, by);
            this.storeByte(n + 1, by2);
            this.storeByte(n + 2, by3);
            this.storeByte(n + 3, by4);
        }
    }

    public byte loadByte(int n) {
        return this.mainMemory.loadByte(n);
    }

    public int loadHalfWord(int n) {
        return this.mainMemory.loadHalfWord(n);
    }

    public int loadWord(int n) {
        return this.mainMemory.loadWord(n);
    }

    public void setRegister(int n, int n2) {
        if (n == 0) {
            return;
        }
        int n3 = this.iGetRegister(n);
        if (n3 != n2) {
            this.addStateValue("R " + n + " " + Utility.sAsHexPadded(n3, 8));
            this.registerFile.iaReg[n] = n2;
        }
    }

    public void setCP0Register(int n, int n2) {
        int n3 = this.iGetCP0Register(n);
        if (n3 != n2) {
            this.addStateValue("0 " + n + " " + Utility.sAsHexPadded(n3, 8));
            this.coprocessor0.iaReg[n] = n2;
        }
    }

    public void setCP1Register(int n, int n2) {
        int n3 = this.iGetCP1Register(n);
        if (n3 != n2) {
            this.addStateValue("1 " + n + " " + Utility.sAsHexPadded(n3, 8));
            this.coprocessor1.iaReg[n] = n2;
        }
    }

    public int iGetRegister(int n) {
        return this.registerFile.iaReg[n];
    }

    public int iGetCP0Register(int n) {
        return this.coprocessor0.iaReg[n];
    }

    public int iGetCP1Register(int n) {
        return this.coprocessor1.iaReg[n];
    }

    public void appendInputBuffer(String string) {
        this.sbInputBuffer.append(string);
    }

    public void appendOutputBuffer(String string) {
        this.sbOutputBuffer.append(string);
    }

    public StringBuffer sbGetOutputBuffer() {
        StringBuffer stringBuffer = this.sbOutputBuffer;
        this.sbOutputBuffer = null;
        return this.sbOutputBuffer;
    }

    public boolean isOutputBufferEmpty() {
        return this.sbOutputBuffer == null;
    }

    public Vector vGetModifiedAddresses() {
        return this.vModifiedMemoryAddresses;
    }

    private void addToModifiedMemoryList(int n) {
        int n2 = this.vModifiedMemoryAddresses.size();
        int n3 = 0;
        n3 = 0;
        while (n3 < n2) {
            int n4 = (Integer)this.vModifiedMemoryAddresses.elementAt(n3);
            if (n == n4) {
                return;
            }
            if (n < n4) break;
            ++n3;
        }
        ++this.iModifiedMemoryCount;
        this.vModifiedMemoryAddresses.insertElementAt(new Integer(n), n3);
    }

    public String toString() {
        String string = "";
        string = string + this.registerFile;
        string = string + "\n" + this.mainMemory;
        return string;
    }
}

