/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Assembler;
import JIMSCore.Coprocessor1;
import JIMSCore.DirectiveProcessor;
import JIMSCore.ModifiedSource;
import JIMSCore.RegisterFile;
import JIMSCore.TextEntry;
import JIMSCore.Utility;
import java.util.StringTokenizer;

public class InstructionEncoder {
    private Assembler assembler;

    public InstructionEncoder(Assembler assembler) {
        this.assembler = assembler;
    }

    public void processInstruction(String string, int n) throws Exception {
        this.processInstruction("", string, n);
    }

    public void processInstruction(String string, String string2, int n) throws Exception {
        int n2;
        String string3 = new StringTokenizer(string2).nextToken();
        String[] stringArray = Assembler.saGetParams(string2.substring(string3.length()).trim());
        string3 = string3.toUpperCase();
        int n3 = string.indexOf(58);
        if (n3 > 0 && ((n2 = string.indexOf(35)) == -1 || n2 > n3)) {
            ModifiedSource.append(string.substring(0, n3) + ":");
        }
        if ((n2 = this.iEncodeInstruction(string, string3, stringArray, n)) == 0) {
            n3 = string.indexOf(35);
            String string4 = "";
            if (n3 >= 0) {
                string4 = string.substring(n3);
            }
            ModifiedSource.append("\t" + string2 + "\t" + string4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int iEncodeInstruction(String string, String string2, String[] stringArray, int n) throws Exception {
        int n2 = 0;
        TextEntry textEntry = new TextEntry(n);
        textEntry.op = string2;
        if (string2.equals("MFHI")) {
            if (stringArray.length != 1) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "00-00-rd-00-10";
            textEntry.formatLen = "6-10-5-5-6";
            textEntry.rd = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MFLO")) {
            if (stringArray.length != 1) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "00-00-rd-00-12";
            textEntry.formatLen = "6-10-5-5-6";
            textEntry.rd = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MTHI")) {
            if (stringArray.length != 1) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "00-rs-00-11";
            textEntry.formatLen = "6-5-15-6";
            textEntry.rs = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MTLO")) {
            if (stringArray.length != 1) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "00-rs-00-13";
            textEntry.formatLen = "6-5-15-6";
            textEntry.rs = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("RFE")) {
            if (stringArray.length != 0) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "10-01-00-10";
            textEntry.formatLen = "6-1-19-6";
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SYSCALL")) {
            if (stringArray.length != 0) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "00-00-0C";
            textEntry.formatLen = "6-20-6";
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BREAK")) {
            if (stringArray.length != 1) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "00-code-0D";
            textEntry.formatLen = "6-20-6";
            textEntry.code = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("J")) {
            textEntry.format = "02-target";
            textEntry.formatLen = "6-26";
            textEntry.target = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("JAL")) {
            textEntry.format = "03-target";
            textEntry.formatLen = "6-26";
            textEntry.target = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("JR")) {
            String string3 = stringArray[0];
            if (string3.indexOf(36) < 0) {
                this.processInstruction("# " + string, "j " + string3, n);
                ++n2;
            } else {
                textEntry.format = "00-rs-00-08";
                textEntry.formatLen = "6-5-15-6";
                textEntry.rs = stringArray[0];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("DIV")) {
            if (stringArray.length == 3) {
                n2 += this.iProcessAsPseudoInstruction(string, string2, stringArray, n);
            } else {
                if (stringArray.length != 2) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                textEntry.format = "00-rs-rt-00-1A";
                textEntry.formatLen = "6-5-5-10-6";
                textEntry.rs = stringArray[0];
                textEntry.rt = stringArray[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("DIVU")) {
            if (stringArray.length == 3) {
                n2 += this.iProcessAsPseudoInstruction(string, string2, stringArray, n);
            } else {
                if (stringArray.length != 2) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                textEntry.format = "00-rs-rt-00-1B";
                textEntry.formatLen = "6-5-5-10-6";
                textEntry.rs = stringArray[0];
                textEntry.rt = stringArray[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("MULT")) {
            if (stringArray.length != 2) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            textEntry.format = "00-rs-rt-00-18";
            textEntry.formatLen = "6-5-5-10-6";
            textEntry.rs = stringArray[0];
            textEntry.rt = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MULTU")) {
            if (stringArray.length != 2) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            textEntry.format = "00-rs-rt-00-19";
            textEntry.formatLen = "6-5-5-10-6";
            textEntry.rs = stringArray[0];
            textEntry.rt = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ADDI")) {
            String string4;
            String string5;
            String string6;
            if (stringArray.length == 2) {
                string6 = stringArray[0];
                string5 = stringArray[0];
                string4 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string6 = stringArray[0];
                string5 = stringArray[1];
                string4 = stringArray[2];
            }
            textEntry.format = "08-rs-rt-imm";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rt = string6;
            textEntry.rs = string5;
            textEntry.addr_imm = string4;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ADDIU")) {
            String string7;
            String string8;
            String string9;
            if (stringArray.length == 2) {
                string9 = stringArray[0];
                string8 = stringArray[0];
                string7 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string9 = stringArray[0];
                string8 = stringArray[1];
                string7 = stringArray[2];
            }
            textEntry.format = "09-rs-rt-imm";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rt = string9;
            textEntry.rs = string8;
            textEntry.addr_imm = string7;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ANDI")) {
            String string10;
            String string11;
            String string12;
            if (stringArray.length == 2) {
                string12 = stringArray[0];
                string11 = stringArray[0];
                string10 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string12 = stringArray[0];
                string11 = stringArray[1];
                string10 = stringArray[2];
            }
            textEntry.format = "0C-rs-rt-imm";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rt = string12;
            textEntry.rs = string11;
            textEntry.addr_imm = string10;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ORI")) {
            String string13;
            String string14;
            String string15;
            if (stringArray.length == 2) {
                string15 = stringArray[0];
                string14 = stringArray[0];
                string13 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string15 = stringArray[0];
                string14 = stringArray[1];
                string13 = stringArray[2];
            }
            textEntry.format = "0D-rs-rt-imm";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rt = string15;
            textEntry.rs = string14;
            textEntry.addr_imm = string13;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("XORI")) {
            String string16;
            String string17;
            String string18;
            if (stringArray.length == 2) {
                string18 = stringArray[0];
                string17 = stringArray[0];
                string16 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string18 = stringArray[0];
                string17 = stringArray[1];
                string16 = stringArray[2];
            }
            textEntry.format = "0E-rs-rt-imm";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rt = string18;
            textEntry.rs = string17;
            textEntry.addr_imm = string16;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("LUI")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "0F-00-rt-imm";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rt = stringArray[0];
            textEntry.addr_imm = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SLTI")) {
            String string19;
            String string20;
            String string21;
            if (stringArray.length == 2) {
                string21 = stringArray[0];
                string20 = stringArray[0];
                string19 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string21 = stringArray[0];
                string20 = stringArray[1];
                string19 = stringArray[2];
            }
            textEntry.format = "0A-rs-rt-imm";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rt = string21;
            textEntry.rs = string20;
            textEntry.addr_imm = string19;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SLTIU")) {
            String string22;
            String string23;
            String string24;
            if (stringArray.length == 2) {
                string24 = stringArray[0];
                string23 = stringArray[0];
                string22 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string24 = stringArray[0];
                string23 = stringArray[1];
                string22 = stringArray[2];
            }
            textEntry.format = "0B-rs-rt-imm";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rt = string24;
            textEntry.rs = string23;
            textEntry.addr_imm = string22;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BC0T")) {
            textEntry.format = "10-8-1-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.addr_imm = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BC1T")) {
            textEntry.format = "11-8-1-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.addr_imm = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BC0F")) {
            textEntry.format = "10-8-0-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.addr_imm = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BC1F")) {
            textEntry.format = "11-8-0-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.addr_imm = stringArray[0];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BEQ")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            if (stringArray[1].indexOf(36) < 0) {
                this.storeAT();
                this.processInstruction("# " + string, "ori $at, $zero, " + stringArray[1], n);
                this.processInstruction("beq $at, " + stringArray[0] + ", " + stringArray[2], n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "04-rs-rt-branch";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray[0];
                textEntry.rt = stringArray[1];
                textEntry.addr_imm = stringArray[2];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("BGEZ")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "01-rs-01-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rs = stringArray[0];
            textEntry.addr_imm = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BGEZAL")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "01-rs-11-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rs = stringArray[0];
            textEntry.addr_imm = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BGTZ")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "07-rs-00-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rs = stringArray[0];
            textEntry.addr_imm = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BLEZ")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "06-rs-00-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rs = stringArray[0];
            textEntry.addr_imm = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BLTZAL")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "01-rs-10-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rs = stringArray[0];
            textEntry.addr_imm = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BLTZ")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "01-rs-00-branch";
            textEntry.formatLen = "6-5-5-16";
            textEntry.rs = stringArray[0];
            textEntry.addr_imm = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("BNE")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            if (stringArray[1].indexOf(36) < 0) {
                this.storeAT();
                this.processInstruction("# " + string, "ori $at, $zero, " + stringArray[1], n);
                this.processInstruction("bne $at, " + stringArray[0] + ", " + stringArray[2], n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "05-rs-rt-branch";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray[0];
                textEntry.rt = stringArray[1];
                textEntry.addr_imm = stringArray[2];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LB")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray2 = this.saProcessAddress(stringArray[1]);
            if (stringArray2[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray2[1] + ")", n);
                this.processInstruction("lb " + stringArray[0] + ", lo16(" + stringArray2[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "20-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray2[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray2[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LBU")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray3 = this.saProcessAddress(stringArray[1]);
            if (stringArray3[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray3[1] + ")", n);
                this.processInstruction("lbu " + stringArray[0] + ", lo16(" + stringArray3[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "24-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray3[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray3[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LH")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray4 = this.saProcessAddress(stringArray[1]);
            if (stringArray4[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray4[1] + ")", n);
                this.processInstruction("lh " + stringArray[0] + ", lo16(" + stringArray4[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "21-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray4[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray4[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LHU")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray5 = this.saProcessAddress(stringArray[1]);
            if (stringArray5[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray5[1] + ")", n);
                this.processInstruction("lhu " + stringArray[0] + ", lo16(" + stringArray5[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "25-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray5[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray5[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LW")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray6 = this.saProcessAddress(stringArray[1]);
            if (stringArray6[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray6[1] + ")", n);
                this.processInstruction("lw " + stringArray[0] + ", lo16(" + stringArray6[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "23-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray6[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray6[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LWC0")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray7 = this.saProcessAddress(stringArray[1]);
            if (stringArray7[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray7[1] + ")", n);
                this.processInstruction("lwc0 " + stringArray[0] + ", lo16(" + stringArray7[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "30-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray7[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray7[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LWC1")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray8 = this.saProcessAddress(stringArray[1]);
            if (stringArray8[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray8[1] + ")", n);
                this.processInstruction("lwc1 " + stringArray[0] + ", lo16(" + stringArray8[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "31-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray8[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray8[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LWL")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray9 = this.saProcessAddress(stringArray[1]);
            if (stringArray9[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray9[1] + ")", n);
                this.processInstruction("lwl " + stringArray[0] + ", lo16(" + stringArray9[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "22-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray9[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray9[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("LWR")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray10 = this.saProcessAddress(stringArray[1]);
            if (stringArray10[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray10[1] + ")", n);
                this.processInstruction("lwr " + stringArray[0] + ", lo16(" + stringArray10[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "26-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray10[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray10[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("SB")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray11 = this.saProcessAddress(stringArray[1]);
            if (stringArray11[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray11[1] + ")", n);
                this.processInstruction("sb " + stringArray[0] + ", lo16(" + stringArray11[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "28-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray11[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray11[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("SH")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray12 = this.saProcessAddress(stringArray[1]);
            if (stringArray12[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray12[1] + ")", n);
                this.processInstruction("sh " + stringArray[0] + ", lo16(" + stringArray12[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "29-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray12[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray12[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("SW")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray13 = this.saProcessAddress(stringArray[1]);
            if (stringArray13[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray13[1] + ")", n);
                this.processInstruction("sw " + stringArray[0] + ", lo16(" + stringArray13[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "2B-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray13[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray13[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("SWC0")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray14 = this.saProcessAddress(stringArray[1]);
            if (stringArray14[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray14[1] + ")", n);
                this.processInstruction("swc0 " + stringArray[0] + ", lo16(" + stringArray14[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "38-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray14[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray14[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("SWC1")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray15 = this.saProcessAddress(stringArray[1]);
            if (stringArray15[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray15[1] + ")", n);
                this.processInstruction("swc1 " + stringArray[0] + ", lo16(" + stringArray15[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "39-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray15[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray15[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("SWL")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray16 = this.saProcessAddress(stringArray[1]);
            if (stringArray16[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray16[1] + ")", n);
                this.processInstruction("swl " + stringArray[0] + ", lo16(" + stringArray16[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "2A-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray16[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray16[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("SWR")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String[] stringArray17 = this.saProcessAddress(stringArray[1]);
            if (stringArray17[0].equals("")) {
                this.storeAT();
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray17[1] + ")", n);
                this.processInstruction("swr " + stringArray[0] + ", lo16(" + stringArray17[1] + ")($at)", n);
                this.restoreAT(stringArray[0], n);
                n2 += 2;
            } else {
                textEntry.format = "2E-rs-rt-offset";
                textEntry.formatLen = "6-5-5-16";
                textEntry.rs = stringArray17[0];
                textEntry.rt = stringArray[0];
                textEntry.addr_imm = stringArray17[1];
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("MFC0")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "10-00-rt-rd-00";
            textEntry.formatLen = "6-5-5-5-11";
            textEntry.rt = stringArray[0];
            textEntry.rd = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MFC1")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "11-00-rt-rd-00";
            textEntry.formatLen = "6-5-5-5-11";
            textEntry.rt = stringArray[0];
            textEntry.rd = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MTC0")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "10-04-rt-rd-00";
            textEntry.formatLen = "6-5-5-5-11";
            textEntry.rt = stringArray[0];
            textEntry.rd = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MTC1")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "11-04-rt-rd-00";
            textEntry.formatLen = "6-5-5-5-11";
            textEntry.rt = stringArray[0];
            textEntry.rd = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("C.EQ.D")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "11-11-ft-fs-00-3-02";
            textEntry.formatLen = "6-5-5-5-5-2-4";
            textEntry.fs = stringArray[0];
            textEntry.ft = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("C.EQ.S")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "11-10-ft-fs-00-3-02";
            textEntry.formatLen = "6-5-5-5-5-2-4";
            textEntry.fs = stringArray[0];
            textEntry.ft = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("C.LE.D")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "11-11-ft-fs-00-3-0E";
            textEntry.formatLen = "6-5-5-5-5-2-4";
            textEntry.fs = stringArray[0];
            textEntry.ft = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("C.LE.S")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "11-10-ft-fs-00-3-0E";
            textEntry.formatLen = "6-5-5-5-5-2-4";
            textEntry.fs = stringArray[0];
            textEntry.ft = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("C.LT.D")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "11-11-ft-fs-00-3-0C";
            textEntry.formatLen = "6-5-5-5-5-2-4";
            textEntry.fs = stringArray[0];
            textEntry.ft = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("C.LT.S")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            textEntry.format = "11-10-ft-fs-00-3-0C";
            textEntry.formatLen = "6-5-5-5-5-2-4";
            textEntry.fs = stringArray[0];
            textEntry.ft = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ADD")) {
            String string25;
            String string26;
            String string27;
            if (stringArray.length == 2) {
                string27 = stringArray[0];
                string26 = stringArray[0];
                string25 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string27 = stringArray[0];
                string26 = stringArray[1];
                string25 = stringArray[2];
            }
            if (string25.indexOf(36) < 0) {
                this.processInstruction("# " + string, "addi " + string27 + ", " + string26 + ", " + string25, n);
                ++n2;
            } else {
                textEntry.format = "00-rs-rt-rd-00-20";
                textEntry.formatLen = "6-5-5-5-5-6";
                textEntry.rd = string27;
                textEntry.rs = string26;
                textEntry.rt = string25;
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("ADDU")) {
            String string28;
            String string29;
            String string30;
            if (stringArray.length == 2) {
                string30 = stringArray[0];
                string29 = stringArray[0];
                string28 = stringArray[1];
            } else {
                string30 = stringArray[0];
                string29 = stringArray[1];
                string28 = stringArray[2];
            }
            if (string28.indexOf(36) < 0) {
                this.processInstruction("# " + string, "addiu " + string30 + ", " + string29 + ", " + string28, n);
                ++n2;
            } else {
                textEntry.format = "00-rs-rt-rd-00-21";
                textEntry.formatLen = "6-5-5-5-5-6";
                textEntry.rd = string30;
                textEntry.rs = string29;
                textEntry.rt = string28;
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("AND")) {
            String string31;
            String string32;
            String string33;
            if (stringArray.length == 2) {
                string33 = stringArray[0];
                string32 = stringArray[0];
                string31 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string33 = stringArray[0];
                string32 = stringArray[1];
                string31 = stringArray[2];
            }
            if (string31.indexOf(36) < 0) {
                this.processInstruction("# " + string, "andi " + string33 + "," + string32 + "," + string31, n);
                ++n2;
            } else {
                textEntry.format = "00-rs-rt-rd-00-24";
                textEntry.formatLen = "6-5-5-5-5-6";
                textEntry.rd = string33;
                textEntry.rs = string32;
                textEntry.rt = string31;
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("NOR")) {
            String string34;
            String string35;
            String string36;
            if (stringArray.length == 2) {
                string36 = stringArray[0];
                string35 = stringArray[0];
                string34 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string36 = stringArray[0];
                string35 = stringArray[1];
                string34 = stringArray[2];
            }
            textEntry.format = "00-rs-rt-rd-00-27";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string36;
            textEntry.rs = string35;
            textEntry.rt = string34;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("OR")) {
            String string37;
            String string38;
            String string39;
            if (stringArray.length == 2) {
                string39 = stringArray[0];
                string38 = stringArray[0];
                string37 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string39 = stringArray[0];
                string38 = stringArray[1];
                string37 = stringArray[2];
            }
            textEntry.format = "00-rs-rt-rd-00-25";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string39;
            textEntry.rs = string38;
            textEntry.rt = string37;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SLL")) {
            String string40;
            String string41;
            String string42;
            if (stringArray.length == 2) {
                string42 = stringArray[0];
                string41 = stringArray[0];
                string40 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string42 = stringArray[0];
                string41 = stringArray[1];
                string40 = stringArray[2];
            }
            textEntry.format = "00-00-rt-rd-shamt-00";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string42;
            textEntry.rt = string41;
            textEntry.shamt = string40;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SLLV")) {
            String string43;
            String string44;
            String string45;
            if (stringArray.length == 2) {
                string45 = stringArray[0];
                string44 = stringArray[0];
                string43 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string45 = stringArray[0];
                string44 = stringArray[1];
                string43 = stringArray[2];
            }
            textEntry.format = "00-rs-rt-rd-00-04";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string45;
            textEntry.rs = string43;
            textEntry.rt = string44;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SRA")) {
            String string46;
            String string47;
            String string48;
            if (stringArray.length == 2) {
                string48 = stringArray[0];
                string47 = stringArray[0];
                string46 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string48 = stringArray[0];
                string47 = stringArray[1];
                string46 = stringArray[2];
            }
            textEntry.format = "00-00-rt-rd-shamt-03";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string48;
            textEntry.rt = string47;
            textEntry.shamt = string46;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SRAV")) {
            String string49;
            String string50;
            String string51;
            if (stringArray.length == 2) {
                string51 = stringArray[0];
                string50 = stringArray[0];
                string49 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string51 = stringArray[0];
                string50 = stringArray[1];
                string49 = stringArray[2];
            }
            textEntry.format = "00-rs-rt-rd-00-07";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string51;
            textEntry.rs = string49;
            textEntry.rt = string50;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SRL")) {
            String string52;
            String string53;
            String string54;
            if (stringArray.length == 2) {
                string54 = stringArray[0];
                string53 = stringArray[0];
                string52 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string54 = stringArray[0];
                string53 = stringArray[1];
                string52 = stringArray[2];
            }
            textEntry.format = "00-00-rt-rd-shamt-02";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string54;
            textEntry.rt = string53;
            textEntry.shamt = string52;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SRLV")) {
            String string55;
            String string56;
            String string57;
            if (stringArray.length == 2) {
                string57 = stringArray[0];
                string56 = stringArray[0];
                string55 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string57 = stringArray[0];
                string56 = stringArray[1];
                string55 = stringArray[2];
            }
            textEntry.format = "00-rs-rt-rd-00-06";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string57;
            textEntry.rs = string55;
            textEntry.rt = string56;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SUB")) {
            String string58;
            String string59;
            String string60;
            if (stringArray.length == 2) {
                string60 = stringArray[0];
                string59 = stringArray[0];
                string58 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string60 = stringArray[0];
                string59 = stringArray[1];
                string58 = stringArray[2];
            }
            if (string58.indexOf(36) < 0) {
                long l = Utility.IntegerLiteralToLong(string58);
                this.processInstruction("# " + string, "addi " + string60 + ", " + string59 + ", " + -l, n);
                ++n2;
            } else {
                textEntry.format = "00-rs-rt-rd-00-22";
                textEntry.formatLen = "6-5-5-5-5-6";
                textEntry.rd = string60;
                textEntry.rs = string59;
                textEntry.rt = string58;
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("SUBU")) {
            String string61;
            String string62;
            String string63;
            if (stringArray.length == 2) {
                string63 = stringArray[0];
                string62 = stringArray[0];
                string61 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string63 = stringArray[0];
                string62 = stringArray[1];
                string61 = stringArray[2];
            }
            if (string61.indexOf(36) < 0) {
                long l = Utility.IntegerLiteralToLong(string61);
                this.processInstruction("# " + string, "addiu " + string63 + ", " + string62 + ", " + -l, n);
                ++n2;
            } else {
                textEntry.format = "00-rs-rt-rd-00-23";
                textEntry.formatLen = "6-5-5-5-5-6";
                textEntry.rd = string63;
                textEntry.rs = string62;
                textEntry.rt = string61;
                this.assembler.addToTextVector(textEntry);
            }
        } else if (string2.equals("XOR")) {
            String string64;
            String string65;
            String string66;
            if (stringArray.length == 2) {
                string66 = stringArray[0];
                string65 = stringArray[0];
                string64 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string66 = stringArray[0];
                string65 = stringArray[1];
                string64 = stringArray[2];
            }
            textEntry.format = "00-rs-rt-rd-00-26";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string66;
            textEntry.rs = string65;
            textEntry.rt = string64;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SLT")) {
            String string67;
            String string68;
            String string69;
            if (stringArray.length == 2) {
                string69 = stringArray[0];
                string68 = stringArray[0];
                string67 = stringArray[1];
            } else {
                if (stringArray.length != 3) throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
                string69 = stringArray[0];
                string68 = stringArray[1];
                string67 = stringArray[2];
            }
            textEntry.format = "00-rs-rt-rd-00-2A";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string69;
            textEntry.rs = string68;
            textEntry.rt = string67;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SLTU")) {
            String string70;
            String string71;
            String string72;
            if (stringArray.length == 2) {
                string72 = stringArray[0];
                string71 = stringArray[0];
                string70 = stringArray[1];
            } else {
                string72 = stringArray[0];
                string71 = stringArray[1];
                string70 = stringArray[2];
            }
            textEntry.format = "00-rs-rt-rd-00-2B";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rd = string72;
            textEntry.rs = string71;
            textEntry.rt = string70;
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("JALR")) {
            textEntry.format = "00-rs-00-rd-00-09";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.rs = stringArray[0];
            textEntry.rd = stringArray.length == 1 ? "$31" : stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("NOP")) {
            textEntry.format = "00-00-00-00-00-00";
            textEntry.formatLen = "6-5-5-5-5-6";
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ABS.D")) {
            textEntry.format = "11-11-00-fs-fd-05";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ABS.S")) {
            textEntry.format = "11-10-00-fs-fd-05";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ADD.D")) {
            textEntry.format = "11-11-ft-fs-fd-00";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            textEntry.ft = stringArray[2];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("ADD.S")) {
            textEntry.format = "11-10-ft-fs-fd-00";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            textEntry.ft = stringArray[2];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("CVT.D.S")) {
            textEntry.format = "11-11-00-fs-fd-21";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("CVT.D.W")) {
            textEntry.format = "11-10-00-fs-fd-21";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("CVT.S.D")) {
            textEntry.format = "11-11-00-fs-fd-20";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("CVT.S.W")) {
            textEntry.format = "11-10-00-fs-fd-20";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("CVT.W.D")) {
            textEntry.format = "11-11-00-fs-fd-00";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("CVT.W.S")) {
            textEntry.format = "11-10-00-fs-fd-24";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("DIV.D")) {
            textEntry.format = "11-11-ft-fs-fd-03";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            textEntry.ft = stringArray[2];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("DIV.S")) {
            textEntry.format = "11-10-ft-fs-fd-03";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            textEntry.ft = stringArray[2];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MOV.D")) {
            textEntry.format = "11-11-00-fs-fd-00";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MOV.S")) {
            textEntry.format = "11-10-00-fs-fd-00";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MUL.D")) {
            textEntry.format = "11-11-ft-fs-fd-02";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            textEntry.ft = stringArray[2];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("MUL.S")) {
            textEntry.format = "11-10-ft-fs-fd-02";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            textEntry.ft = stringArray[2];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("NEG.D")) {
            textEntry.format = "11-11-00-fs-fd-07";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("NEG.S")) {
            textEntry.format = "11-10-00-fs-fd-07";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SUB.D")) {
            textEntry.format = "11-11-ft-fs-fd-01";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            textEntry.ft = stringArray[2];
            this.assembler.addToTextVector(textEntry);
        } else if (string2.equals("SUB.S")) {
            textEntry.format = "11-10-ft-fs-fd-01";
            textEntry.formatLen = "6-5-5-5-5-6";
            textEntry.fd = stringArray[0];
            textEntry.fs = stringArray[1];
            textEntry.ft = stringArray[2];
            this.assembler.addToTextVector(textEntry);
        } else {
            n2 += this.iProcessAsPseudoInstruction(string, string2, stringArray, n);
        }
        this.validateRegisterUse(textEntry, string, n);
        return n2;
    }

    private int iProcessAsPseudoInstruction(String string, String string2, String[] stringArray, int n) throws Exception {
        int n2 = 0;
        this.storeAT();
        if (string2.equals("DIV")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            if (string5.indexOf(36) < 0) {
                this.processInstruction("# " + string, "ori $at, $zero, " + string5, n);
                this.processInstruction("div " + string4 + ", $at", n);
                this.processInstruction("mflo " + string3, n);
                n2 += 3;
            } else {
                this.processInstruction("# " + string, "div " + string4 + "," + string5, n);
                this.processInstruction("bne " + string5 + ",$zero,8", n);
                this.processInstruction("break 7", n);
                this.processInstruction("li $at, -1", n);
                this.processInstruction("bne " + string5 + ", $at, 16", n);
                this.processInstruction("lui $at, 0x8000", n);
                this.processInstruction("bne " + string4 + ", $at, 8", n);
                this.processInstruction("break 6", n);
                this.processInstruction("mflo " + string3, n);
                n2 += 9;
            }
        } else if (string2.equals("DIVU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string6 = stringArray[0];
            String string7 = stringArray[1];
            String string8 = stringArray[2];
            this.processInstruction("# " + string, "divu " + string7 + ", " + string8, n);
            this.processInstruction("bne " + string8 + ", $zero, 8", n);
            this.processInstruction("break 7", n);
            this.processInstruction("mflo " + string6, n);
            n2 += 4;
        } else if (string2.equals("ABS")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string9 = stringArray[0];
            String string10 = stringArray[1];
            this.processInstruction("# " + string, "addu " + string9 + ", $zero, " + string10, n);
            this.processInstruction("bgez " + string10 + ", 8", 0);
            this.processInstruction("sub " + string9 + ", $zero, " + string10, 0);
            n2 += 3;
        } else if (string2.equals("MUL")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string11 = stringArray[0];
            String string12 = stringArray[1];
            String string13 = stringArray[2];
            this.processInstruction("# " + string, "mult " + string12 + ", " + string13, n);
            this.processInstruction("mflo " + string11, 0);
            n2 += 2;
        } else if (string2.equals("MULO")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string14 = stringArray[0];
            String string15 = stringArray[1];
            String string16 = stringArray[2];
            this.processInstruction("# " + string, "mult " + string15 + ", " + string16, n);
            this.processInstruction("mflo " + string14, 0);
            this.processInstruction("sra " + string14 + ", " + string14 + ",31", 0);
            this.processInstruction("mfhi $at", 0);
            this.processInstruction("beq " + string14 + ", $at, 8", 0);
            this.processInstruction("break 6", 0);
            this.processInstruction("mflo " + string14, 0);
            n2 += 7;
        } else if (string2.equals("MULOU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string17 = stringArray[0];
            String string18 = stringArray[1];
            String string19 = stringArray[2];
            this.processInstruction("# " + string, "multu " + string18 + ", " + string19, n);
            this.processInstruction("mfhi $at", 0);
            this.processInstruction("mflo " + string17, 0);
            this.processInstruction("beq $at, $zero, 8", 0);
            this.processInstruction("break 6", 0);
            n2 += 5;
        } else if (string2.equals("NEG")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string20 = stringArray[0];
            String string21 = stringArray[1];
            this.processInstruction("# " + string, "sub " + string20 + ", $zero, " + string21, n);
            ++n2;
        } else if (string2.equals("NEGU")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string22 = stringArray[0];
            String string23 = stringArray[1];
            this.processInstruction("# " + string, "subu " + string22 + ", $zero, " + string23, n);
            ++n2;
        } else if (string2.equals("NOT")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string24 = stringArray[0];
            String string25 = stringArray[1];
            this.processInstruction("# " + string, "nor " + string24 + ", " + string25 + ", $zero", n);
            ++n2;
        } else if (string2.equals("ROL")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string26 = stringArray[0];
            String string27 = stringArray[1];
            String string28 = stringArray[2];
            this.processInstruction("# " + string, "negu $at, " + string28, n);
            this.processInstruction("srlv $at, " + string27 + ",$at", 0);
            this.processInstruction("sllv " + string26 + ", " + string27 + ", " + string28, 0);
            this.processInstruction("or " + string26 + ", " + string26 + ", $at", 0);
            n2 += 4;
        } else if (string2.equals("ROR")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string29 = stringArray[0];
            String string30 = stringArray[1];
            String string31 = stringArray[2];
            this.processInstruction("# " + string, "negu $at, " + string31, n);
            this.processInstruction("sllv $at, " + string30 + ",$at", 0);
            this.processInstruction("srlv " + string29 + ", " + string30 + ", " + string31, 0);
            this.processInstruction("or " + string29 + ", " + string29 + ", $at", 0);
            n2 += 4;
        } else if (string2.equals("LI")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string32 = stringArray[0];
            String string33 = stringArray[1];
            long l = Utility.IntegerLiteralToLong(string33);
            if (l >= 0L && l <= 65535L) {
                this.processInstruction("# " + string, "ori " + string32 + ", $zero, " + string33, n);
                ++n2;
            } else if (l >= -32768L && l < 0L) {
                this.processInstruction("# " + string, "addiu " + string32 + ", $zero, " + string33, n);
                ++n2;
            } else {
                this.processInstruction("# " + string, "lui " + string32 + ", " + ((l & 0xFFFFFFFFFFFF0000L) >>> 16), n);
                this.processInstruction("ori " + string32 + ", " + (l & 0xFFFFL), 0);
                n2 += 2;
            }
        } else if (string2.equals("SEQ")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string34 = stringArray[0];
            String string35 = stringArray[1];
            String string36 = stringArray[2];
            if (string36.indexOf(36) < 0) {
                this.processInstruction("# " + string, "seqi " + string34 + ", " + string35 + ", " + string36, n);
                ++n2;
            } else {
                this.processInstruction("# " + string, "beq " + string36 + ", " + string35 + ", 12", n);
                this.processInstruction("ori " + string34 + ", $zero, 0", 0);
                this.processInstruction("beq $zero, $zero, 8", 0);
                this.processInstruction("ori " + string34 + ", $zero, 1", 0);
                n2 += 4;
            }
        } else if (string2.equals("SEQI")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string37 = stringArray[0];
            String string38 = stringArray[1];
            String string39 = stringArray[2];
            this.processInstruction("# " + string, "ori $at, $zero, " + string39, n);
            this.processInstruction("beq $at, " + string38 + ", 12", 0);
            this.processInstruction("ori " + string37 + ", $zero, 0", 0);
            this.processInstruction("beq $zero, $zero, 8", 0);
            this.processInstruction("ori " + string37 + ", $zero, 1", 0);
            n2 += 5;
        } else if (string2.equals("SGE")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string40 = stringArray[0];
            String string41 = stringArray[1];
            String string42 = stringArray[2];
            this.processInstruction("# " + string, "slt " + string40 + ", " + string41 + ", " + string42, n);
            this.processInstruction("xori " + string40 + ", " + string40 + ", 1", 0);
            n2 += 2;
        } else if (string2.equals("SGEU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string43 = stringArray[0];
            String string44 = stringArray[1];
            String string45 = stringArray[2];
            this.processInstruction("# " + string, "sltu " + string43 + ", " + string44 + ", " + string45, n);
            this.processInstruction("xori " + string43 + ", " + string43 + ", 1", 0);
            n2 += 2;
        } else if (string2.equals("SGT")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string46 = stringArray[0];
            String string47 = stringArray[1];
            String string48 = stringArray[2];
            if (string48.indexOf(36) < 0) {
                this.processInstruction("# " + string, "ori $at, $zero, " + string48, n);
                this.processInstruction("slt " + string46 + ", $at, " + string47, n);
                n2 += 2;
            } else {
                this.processInstruction("# " + string, "slt " + string46 + ", " + string48 + ", " + string47, n);
                ++n2;
            }
        } else if (string2.equals("SGTU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string49 = stringArray[0];
            String string50 = stringArray[1];
            String string51 = stringArray[2];
            this.processInstruction("# " + string, "sltu " + string49 + ", " + string51 + ", " + string50, n);
            ++n2;
        } else if (string2.equals("SLE")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string52 = stringArray[0];
            String string53 = stringArray[1];
            String string54 = stringArray[2];
            this.processInstruction("# " + string, "slt " + string52 + "," + string54 + "," + string53, n);
            this.processInstruction("xori " + string52 + "," + string52 + ",1", 0);
            n2 += 2;
        } else if (string2.equals("SLEU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string55 = stringArray[0];
            String string56 = stringArray[1];
            String string57 = stringArray[2];
            this.processInstruction("# " + string, "sltu " + string55 + ", " + string57 + ", " + string56, n);
            this.processInstruction("xori " + string55 + ", " + string55 + ", 1", 0);
            n2 += 2;
        } else if (string2.equals("SNE")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string58 = stringArray[0];
            String string59 = stringArray[1];
            String string60 = stringArray[2];
            if (string60.indexOf(36) < 0) {
                this.processInstruction("# " + string, "snei " + string58 + ", " + string59 + ", " + string60, n);
                ++n2;
            } else {
                this.processInstruction("# " + string, "beq " + string60 + ", " + string59 + ", 12", n);
                this.processInstruction("ori " + string58 + ", $zero, 1", 0);
                this.processInstruction("beq $zero, $zero, 8", 0);
                this.processInstruction("ori " + string58 + ", $zero, 0", 0);
                n2 += 4;
            }
        } else if (string2.equals("SNEI")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string61 = stringArray[0];
            String string62 = stringArray[1];
            String string63 = stringArray[2];
            this.processInstruction("# " + string, "ori $at, $zero, " + string63, n);
            this.processInstruction("beq $at, " + string62 + ", 12", 0);
            this.processInstruction("ori " + string61 + ", $zero, 1", 0);
            this.processInstruction("beq $zero, $zero, 8", 0);
            this.processInstruction("ori " + string61 + ", $zero, 0", 0);
            n2 += 5;
        } else if (string2.equals("B")) {
            if (stringArray.length != 1) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string64 = stringArray[0];
            this.processInstruction("# " + string, "beq $zero, $zero, " + string64, n);
            ++n2;
        } else if (string2.equals("BEQZ")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string65 = stringArray[0];
            String string66 = stringArray[1];
            this.processInstruction("# " + string, "beq " + string65 + ", $zero, " + string66, n);
            ++n2;
        } else if (string2.equals("BGE")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string67 = stringArray[0];
            String string68 = stringArray[1];
            String string69 = stringArray[2];
            this.processInstruction("# " + string, "slt $at, " + string67 + ", " + string68, n);
            this.processInstruction("beq $at, $zero, " + string69, 0);
            n2 += 2;
        } else if (string2.equals("BGEU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string70 = stringArray[0];
            String string71 = stringArray[1];
            String string72 = stringArray[2];
            this.processInstruction("# " + string, "sltu $at, " + string70 + ", " + string71, n);
            this.processInstruction("beq $at, $zero, " + string72, 0);
            n2 += 2;
        } else if (string2.equals("BGT")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string73 = stringArray[0];
            String string74 = stringArray[1];
            String string75 = stringArray[2];
            this.processInstruction("# " + string, "slt $at, " + string74 + ", " + string73, n);
            this.processInstruction("bne $at, $zero, " + string75, n);
            n2 += 2;
        } else if (string2.equals("BGTU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string76 = stringArray[0];
            String string77 = stringArray[1];
            String string78 = stringArray[2];
            this.processInstruction("# " + string, "slt $at, " + string77 + ", " + string76, n);
            this.processInstruction("beq $at, $zero, " + string78, 0);
            n2 += 2;
        } else if (string2.equals("BLE")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string79 = stringArray[0];
            String string80 = stringArray[1];
            String string81 = stringArray[2];
            this.processInstruction("# " + string, "slt $at, " + string80 + ", " + string79, n);
            this.processInstruction("beq $at, $zero, " + string81, 0);
            n2 += 2;
        } else if (string2.equals("BLEU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string82 = stringArray[0];
            String string83 = stringArray[1];
            String string84 = stringArray[2];
            this.processInstruction("# " + string, "sltu $at, " + string83 + ", " + string82, n);
            this.processInstruction("beq $at, $zero, " + string84, 0);
            n2 += 2;
        } else if (string2.equals("BLT")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string85 = stringArray[0];
            String string86 = stringArray[1];
            String string87 = stringArray[2];
            this.processInstruction("# " + string, "slt $at, " + string85 + ", " + string86, n);
            this.processInstruction("bne $at, $zero, " + string87, 0);
            n2 += 2;
        } else if (string2.equals("BLTU")) {
            if (stringArray.length != 3) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string88 = stringArray[0];
            String string89 = stringArray[1];
            String string90 = stringArray[2];
            this.processInstruction("# " + string, "sltu $at, " + string88 + ", " + string89, n);
            this.processInstruction("bne $at, $zero, " + string90, 0);
            n2 += 2;
        } else if (string2.equals("BNEZ")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string91 = stringArray[0];
            String string92 = stringArray[1];
            this.processInstruction("# " + string, "bne " + string91 + ", $zero, " + string92, n);
            ++n2;
        } else if (string2.equals("LA")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            String string93 = stringArray[0];
            String string94 = stringArray[1].trim();
            String[] stringArray2 = this.saProcessAddress(string94);
            if (stringArray2[0].equals("")) {
                this.processInstruction("# " + string, "lui $at, hi16(" + string94 + ")", n);
                this.processInstruction("ori " + string93 + ", $at, lo16(" + string94 + ")", 0);
                n2 += 2;
            } else {
                this.processInstruction("# " + string, "lui $at, hi16(" + stringArray2[1] + ")", n);
                this.processInstruction("ori $at, $at, lo16(" + stringArray2[1] + ")", 0);
                this.processInstruction("add " + string93 + ", " + stringArray2[0] + ",$at", 0);
                n2 += 3;
            }
        } else if (string2.equals("MOVE")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.\n\n" + string.trim());
            }
            String string95 = stringArray[0];
            String string96 = stringArray[1];
            this.processInstruction("# " + string, "addu " + string95 + ", $zero, " + string96, n);
            ++n2;
        } else if (string2.equals("L.D")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            int n3 = Coprocessor1.iRegLiteralToID(stringArray[0]);
            this.processInstruction("# " + string, "lui $at, hi16(" + stringArray[1] + ")", n);
            this.processInstruction("lwc1 " + stringArray[0] + ", lo16(" + stringArray[1] + ")($at)", 0);
            this.processInstruction("lui $at, hi16(+4|" + stringArray[1] + ")", n);
            this.processInstruction("lwc1 $" + (n3 + 1) + ", lo16(+4|" + stringArray[1] + ")($at)", 0);
            n2 += 4;
        } else if (string2.equals("L.S")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            this.processInstruction("# " + string, "lui $at, hi16(" + stringArray[1] + ")", n);
            this.processInstruction("lwc1 " + stringArray[0] + ", lo16(" + stringArray[1] + ")($at)", 0);
            n2 += 2;
        } else if (string2.equals("S.D")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            int n4 = Coprocessor1.iRegLiteralToID(stringArray[0]);
            this.processInstruction("# " + string, "lui $at, hi16(" + stringArray[1] + ")", n);
            this.processInstruction("swc1 " + stringArray[0] + ", lo16(" + stringArray[1] + ")($at)", 0);
            this.processInstruction("lui $at, hi16(+4|" + stringArray[1] + ")", n);
            this.processInstruction("swc1 $" + (n4 + 1) + ", lo16(+4|" + stringArray[1] + ")($at)", 0);
            n2 += 4;
        } else if (string2.equals("S.S")) {
            if (stringArray.length != 2) {
                throw new Exception("Line " + n + "\n" + "Invalid number of operands.");
            }
            this.processInstruction("# " + string, "lui $at, hi16(" + stringArray[1] + ")", n);
            this.processInstruction("swc1 " + stringArray[0] + ", lo16(" + stringArray[1] + ")($at)", 0);
            n2 += 2;
        } else {
            throw new Exception("Line " + n + "\n" + "Unsupported opcode: " + string2);
        }
        this.restoreAT("", n);
        return n2;
    }

    private String[] saProcessAddress(String string) {
        String[] stringArray = new String[2];
        int n = string.lastIndexOf("(");
        if (n >= 0) {
            int n2 = string.lastIndexOf(")");
            stringArray[0] = string.substring(n + 1, n2);
            stringArray[1] = string.substring(0, n);
        } else {
            stringArray[0] = "";
            stringArray[1] = string;
        }
        return stringArray;
    }

    private void storeAT() {
        DirectiveProcessor.bOldWarnAboutAT = DirectiveProcessor.bWarnAboutAT;
        DirectiveProcessor.bWarnAboutAT = false;
    }

    private void restoreAT(String string, int n) {
        DirectiveProcessor.bWarnAboutAT = DirectiveProcessor.bOldWarnAboutAT;
        if (DirectiveProcessor.bWarnAboutAT && Assembler.isAT(string)) {
            Assembler.warnAboutUseOfAT(n);
        }
    }

    private void validateRegisterUse(TextEntry textEntry, String string, int n) throws Exception {
        if (textEntry.rs != null && RegisterFile.iRegLiteralToID(textEntry.rs) == -1) {
            throw new Exception("Line " + n + "\n" + "Invalid general-purpose register: " + textEntry.rs + "\n\n" + string);
        }
        if (textEntry.rt != null && RegisterFile.iRegLiteralToID(textEntry.rt) == -1) {
            throw new Exception("Line " + n + "\n" + "Invalid general-purpose register: " + textEntry.rt + "\n\n" + string);
        }
        if (textEntry.rd != null && RegisterFile.iRegLiteralToID(textEntry.rd) == -1) {
            throw new Exception("Line " + n + "\n" + "Invalid general-purpose register: " + textEntry.rd + "\n\n" + string);
        }
        if (textEntry.fs != null && RegisterFile.iRegLiteralToID(textEntry.fs) == -1) {
            throw new Exception("Line " + n + "\n" + "Invalid floating-point register: " + textEntry.fs + "\n\n" + string);
        }
        if (textEntry.ft != null && RegisterFile.iRegLiteralToID(textEntry.ft) == -1) {
            throw new Exception("Line " + n + "\n" + "Invalid floating-point register: " + textEntry.ft + "\n\n" + string);
        }
        if (textEntry.fd != null && RegisterFile.iRegLiteralToID(textEntry.fd) == -1) {
            throw new Exception("Line " + n + "\n" + "Invalid floating-point register: " + textEntry.fd + "\n\n" + string);
        }
    }
}

