/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Utility;

class GammaMemoryBucket {
    public byte[] cell;
    public byte[] modified;

    public GammaMemoryBucket() {
        this.reset();
    }

    public void reset() {
        this.cell = new byte[256];
        this.modified = new byte[256];
        int n = 0;
        while (n < this.modified.length) {
            this.cell[n] = 0;
            ++n;
        }
    }

    public void storeByte(int n, byte by) {
        this.cell[n] = by;
        if (this.modified[n] < 127) {
            int n2 = n;
            this.modified[n2] = (byte)(this.modified[n2] + 1);
        }
    }

    public byte loadByte(int n) {
        return this.cell[n];
    }

    public StringBuffer sbGetMemoryDump(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cell != null) {
            int n = 0;
            while (n < this.cell.length) {
                if (this.modified[n] > 0) {
                    stringBuffer.append(string + Utility.sAsHexPadded(n, 2) + " " + Utility.sAsHexPadded(this.cell[n], 2) + "\n");
                }
                ++n;
            }
        }
        return stringBuffer;
    }
}

