/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Assembler;
import JIMSCore.DataEntry;
import JIMSCore.DataSection;
import JIMSCore.TextSection;
import JIMSCore.Utility;
import java.util.StringTokenizer;
import java.util.Vector;

public class DirectiveProcessor {
    public static final int SIZE_BYTE = 1;
    public static final int SIZE_HALF_WORD = 2;
    public static final int SIZE_WORD = 4;
    public static final int SIZE_FLOAT = 4;
    public static final int SIZE_DOUBLE = 8;
    public static final int DEFAULT_TEXT_ADDRESS = 0x400000;
    public static final int DEFAULT_DATA_ADDRESS = 0x10000000;
    public static final int DEFAULT_KTEXT_ADDRESS = -2147483520;
    public static final int DEFAULT_KDATA_ADDRESS = -1879048192;
    public static boolean bOldWarnAboutAT;
    public static boolean bWarnAboutAT;
    public int iLastTextAddress;
    public int iLastDataAddress;
    public int iLastKTextAddress;
    public int iLastKDataAddress;
    public int iCurrentAddress;
    private Assembler assembler;

    public DirectiveProcessor(Assembler assembler) {
        this.assembler = assembler;
        this.iLastTextAddress = 0x400000;
        this.iLastDataAddress = 0x10000000;
        this.iLastKTextAddress = -2147483520;
        this.iLastKDataAddress = -1879048192;
    }

    /*
     * Unable to fully structure code
     */
    public int iProcessDirective(String var1_1, int var2_2) {
        block93: {
            block94: {
                var3_3 = new StringTokenizer(var1_1).nextToken();
                var4_4 = Assembler.saGetParams(var1_1.substring(var3_3.length()).trim());
                if ((var3_3 = var3_3.substring(1).toUpperCase()).equals("ALIGN")) break block93;
                if (!(var3_3.equals("ASCII") | var3_3.equals("ASCIIZ"))) break block94;
                switch (this.assembler.iCurrentMode) {
                    case 2: 
                    case 4: {
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                var6_5 = var3_3.equals("ASCIIZ");
                var7_12 = new DataEntry(this.iCurrentAddress);
                var8_19 = "";
                var5_27 = 0;
                while (var5_27 < var4_4.length) {
                    var9_34 = var4_4[var5_27];
                    var10_35 = false;
                    var11_37 = 1;
                    while (var11_37 < var9_34.length() - 1) {
                        block95: {
                            var12_38 = var9_34.charAt(var11_37);
                            if (!var10_35) break block95;
                            switch (var12_38) {
                                case 92: {
                                    var12_38 = 92;
                                    break;
                                }
                                case 110: {
                                    var12_38 = 10;
                                    break;
                                }
                                case 116: {
                                    var12_38 = 9;
                                    break;
                                }
                                case 114: {
                                    var12_38 = 13;
                                    break;
                                }
                                case 48: {
                                    var12_38 = 0;
                                    break;
                                }
                                case 34: {
                                    var12_38 = 34;
                                }
                                default: {
                                    return -2;
                                }
                            }
                            var10_35 = false;
                            ** GOTO lbl-1000
                        }
                        if (var12_38 == 92) {
                            var10_35 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var8_19 = var8_19 + Utility.sAsHexPadded(var12_38, 2) + " ";
                            ++this.iCurrentAddress;
                        }
                        ++var11_37;
                    }
                    if (var6_5) {
                        var8_19 = var8_19 + Utility.sAsHexPadded(0L, 2) + " ";
                        ++this.iCurrentAddress;
                    }
                    ++var5_27;
                }
                var7_12.sData = var8_19.trim();
                this.assembler.addToDataVector(var7_12);
                break block93;
            }
            if (var3_3.equals("BYTE")) {
                switch (this.assembler.iCurrentMode) {
                    case 2: 
                    case 4: {
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                var6_6 = new DataEntry(this.iCurrentAddress);
                var7_13 = "";
                var5_28 = 0;
                while (var5_28 < var4_4.length) {
                    var8_20 = (byte)Utility.IntegerLiteralToLong(var4_4[var5_28]);
                    var7_13 = var7_13 + Utility.sAsHexPadded(var8_20, 2) + " ";
                    ++this.iCurrentAddress;
                    ++var5_28;
                }
                var6_6.sData = var7_13.trim();
                this.assembler.addToDataVector(var6_6);
            } else if (var3_3.equals("DATA")) {
                switch (this.assembler.iCurrentMode) {
                    case 1: {
                        this.iLastTextAddress = this.iCurrentAddress;
                        break;
                    }
                    case 4: {
                        this.iLastKDataAddress = this.iCurrentAddress;
                        break;
                    }
                    case 3: {
                        this.iLastKTextAddress = this.iCurrentAddress;
                    }
                }
                this.assembler.iCurrentMode = 2;
                this.iCurrentAddress = var4_4.length == 0 ? this.iLastDataAddress : (int)Utility.IntegerLiteralToLong(var4_4[0]);
                if (this.assembler.vDataSection == null) {
                    this.assembler.vDataSection = new Vector<E>();
                }
                this.assembler.currentDataSection = new DataSection(this.iCurrentAddress, 0);
                this.assembler.vDataSection.add(this.assembler.currentDataSection);
                ++this.assembler.iCurrentDataSectionIndex;
                this.assembler.iCurrentDataIndex = 0;
            } else if (var3_3.equals("DOUBLE")) {
                switch (this.assembler.iCurrentMode) {
                    case 2: 
                    case 4: {
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                var6_7 = new DataEntry(this.iCurrentAddress);
                var7_14 = "";
                var5_29 = 0;
                while (var5_29 < var4_4.length) {
                    var8_21 = Utility.FloatingPointLiteralToDouble(var4_4[var5_29]);
                    var10_36 = Double.doubleToLongBits(var8_21);
                    var12_39 = (int)((var10_36 & -4294967296L) >>> 32);
                    var13_40 = (int)(var10_36 & 0xFFFFFFFFL);
                    var7_14 = var7_14 + Utility.sAsHexPadded(var13_40, 8);
                    var7_14 = var7_14 + Utility.sAsHexPadded(var12_39, 8);
                    this.iCurrentAddress += 8;
                    ++var5_29;
                }
                var6_7.sData = var7_14.trim();
                this.assembler.addToDataVector(var6_7);
            } else if (var3_3.equals("FLOAT")) {
                switch (this.assembler.iCurrentMode) {
                    case 2: 
                    case 4: {
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                var6_8 = new DataEntry(this.iCurrentAddress);
                var7_15 = "";
                var5_30 = 0;
                while (var5_30 < var4_4.length) {
                    var8_22 = Utility.FloatingPointLiteralToFloat(var4_4[var5_30]);
                    var7_15 = var7_15 + Utility.sAsHexPadded(var8_22, 8) + " ";
                    this.iCurrentAddress += 4;
                    ++var5_30;
                }
                var6_8.sData = var7_15.trim();
                this.assembler.addToDataVector(var6_8);
            } else if (!var3_3.equals("GLOBL")) {
                if (var3_3.equals("HALF")) {
                    switch (this.assembler.iCurrentMode) {
                        case 2: 
                        case 4: {
                            break;
                        }
                        default: {
                            return -1;
                        }
                    }
                    var6_9 = new DataEntry(this.iCurrentAddress);
                    var7_16 = "";
                    var5_31 = 0;
                    while (var5_31 < var4_4.length) {
                        var8_23 = (short)Utility.IntegerLiteralToLong(var4_4[var5_31]);
                        var7_16 = var7_16 + Utility.sAsHexPadded(var8_23, 4) + " ";
                        this.iCurrentAddress += 4;
                        ++var5_31;
                    }
                    var6_9.sData = var7_16.trim();
                    this.assembler.addToDataVector(var6_9);
                } else if (var3_3.equals("KDATA")) {
                    switch (this.assembler.iCurrentMode) {
                        case 1: {
                            this.iLastTextAddress = this.iCurrentAddress;
                            break;
                        }
                        case 2: {
                            this.iLastDataAddress = this.iCurrentAddress;
                            break;
                        }
                        case 3: {
                            this.iLastKTextAddress = this.iCurrentAddress;
                        }
                    }
                    this.assembler.iCurrentMode = 4;
                    this.iCurrentAddress = var4_4.length == 0 ? this.iLastKDataAddress : (int)Utility.IntegerLiteralToLong(var4_4[0]);
                    if (this.assembler.vDataSection == null) {
                        this.assembler.vDataSection = new Vector<E>();
                    }
                    this.assembler.currentDataSection = new DataSection(this.iCurrentAddress, 1);
                    this.assembler.vDataSection.add(this.assembler.currentDataSection);
                    ++this.assembler.iCurrentDataSectionIndex;
                    this.assembler.iCurrentDataIndex = 0;
                } else if (var3_3.equals("KTEXT")) {
                    switch (this.assembler.iCurrentMode) {
                        case 2: {
                            this.iLastDataAddress = this.iCurrentAddress;
                            break;
                        }
                        case 4: {
                            this.iLastKDataAddress = this.iCurrentAddress;
                            break;
                        }
                        case 1: {
                            this.iLastTextAddress = this.iCurrentAddress;
                        }
                    }
                    this.assembler.iCurrentMode = 3;
                    this.iCurrentAddress = var4_4.length == 0 ? this.iLastKTextAddress : (int)Utility.IntegerLiteralToLong(var4_4[0]);
                    if (this.assembler.vTextSection == null) {
                        this.assembler.vTextSection = new Vector<E>();
                    }
                    this.assembler.currentTextSection = new TextSection(this.iCurrentAddress, 1);
                    this.assembler.vTextSection.add(this.assembler.currentTextSection);
                    ++this.assembler.iCurrentTextSectionIndex;
                    this.assembler.iCurrentTextIndex = 0;
                } else if (var3_3.equals("SET")) {
                    if (var4_4[0].toUpperCase().equals("NOAT")) {
                        DirectiveProcessor.bWarnAboutAT = false;
                    } else if (var4_4[0].toUpperCase().equals("AT")) {
                        DirectiveProcessor.bWarnAboutAT = true;
                    } else {
                        System.err.println("WARNING: Invalid parameter for SET directive (L" + var2_2 + ")");
                    }
                } else if (var3_3.equals("SPACE")) {
                    switch (this.assembler.iCurrentMode) {
                        case 2: 
                        case 4: {
                            break;
                        }
                        default: {
                            return -1;
                        }
                    }
                    var6_10 = new DataEntry(this.iCurrentAddress);
                    var7_17 = "";
                    var8_24 = (int)Utility.IntegerLiteralToLong(var4_4[0]);
                    var5_32 = 0;
                    while (var5_32 < var8_24) {
                        var7_17 = var7_17 + "00 ";
                        ++this.iCurrentAddress;
                        ++var5_32;
                    }
                    var6_10.sData = var7_17.trim();
                    this.assembler.addToDataVector(var6_10);
                } else if (var3_3.equals("TEXT")) {
                    switch (this.assembler.iCurrentMode) {
                        case 2: {
                            this.iLastDataAddress = this.iCurrentAddress;
                            break;
                        }
                        case 4: {
                            this.iLastKDataAddress = this.iCurrentAddress;
                            break;
                        }
                        case 3: {
                            this.iLastKTextAddress = this.iCurrentAddress;
                        }
                    }
                    this.assembler.iCurrentMode = 1;
                    this.iCurrentAddress = var4_4.length == 0 ? this.iLastTextAddress : (int)Utility.IntegerLiteralToLong(var4_4[0]);
                    if (this.assembler.vTextSection == null) {
                        this.assembler.vTextSection = new Vector<E>();
                    }
                    this.assembler.currentTextSection = new TextSection(this.iCurrentAddress, 0);
                    this.assembler.vTextSection.add(this.assembler.currentTextSection);
                    ++this.assembler.iCurrentTextSectionIndex;
                    this.assembler.iCurrentTextIndex = 0;
                } else if (var3_3.equals("WORD")) {
                    switch (this.assembler.iCurrentMode) {
                        case 2: 
                        case 4: {
                            break;
                        }
                        default: {
                            return -1;
                        }
                    }
                    var6_11 = new DataEntry(this.iCurrentAddress);
                    var7_18 = "";
                    var5_33 = 0;
                    while (var5_33 < var4_4.length) {
                        try {
                            var8_25 = (int)Utility.IntegerLiteralToLong(var4_4[var5_33]);
                            var7_18 = var7_18 + Utility.sAsHexPadded(var8_25, 8) + " ";
                        }
                        catch (NumberFormatException var8_26) {
                            var7_18 = var7_18 + "addr(" + var4_4[var5_33] + ") ";
                        }
                        this.iCurrentAddress += 4;
                        ++var5_33;
                    }
                    var6_11.sData = var7_18.trim();
                    this.assembler.addToDataVector(var6_11);
                } else {
                    return -3;
                }
            }
        }
        return 0;
    }

    static {
        bWarnAboutAT = true;
    }
}

