/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Command;
import JIMSCore.CommandResultBuffer;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import JIMSCore.SimulatorException;
import java.util.StringTokenizer;

public class CommandStep
extends Command {
    public static final String ERR_CYCLE_ERROR = "ERR_CYCLE_ERROR";
    private Simulator simulator;

    public CommandStep(StringTokenizer stringTokenizer, Simulator simulator) {
        super(stringTokenizer);
        this.simulator = simulator;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        long l = 1L;
        String string = this.nextToken();
        if (string.length() > 0) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                throw new InvalidCommandUseException("Unable to translate value of n specified.");
            }
            if (l < 1L) {
                throw new InvalidCommandUseException("Value of n must be larger than 0.");
            }
        }
        try {
            int n = this.simulator.iPerformStep(l);
            switch (n) {
                case 0: {
                    break;
                }
                case -1: {
                    commandResultBuffer.append("* STEP BREAKPOINT " + this.simulator.iGetBreakpointIndex());
                    l = 1L;
                    break;
                }
                case -2: {
                    commandResultBuffer.append("* STEP GUARD " + this.simulator.iGetGuardIndex());
                    l = 1L;
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
        }
        catch (SimulatorException simulatorException) {
            int n = this.simulator.iGetExceptionCode();
            commandResultBuffer.append("* STEP EXCEPTION " + n + " " + simulatorException);
            l = 1L;
        }
        catch (Exception exception) {
            commandResultBuffer.append("* STEP ERR ERR_CYCLE_ERROR " + exception);
        }
        commandResultBuffer.append("* STEP DONE");
    }
}

