/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Utility;

public class RegisterFile {
    public static final String[][] REG_ID = new String[][]{{"$0", "$ZERO"}, {"$1", "$AT"}, {"$2", "$V0"}, {"$3", "$V1"}, {"$4", "$A0"}, {"$5", "$A1"}, {"$6", "$A2"}, {"$7", "$A3"}, {"$8", "$T0"}, {"$9", "$T1"}, {"$10", "$T2"}, {"$11", "$T3"}, {"$12", "$T4"}, {"$13", "$T5"}, {"$14", "$T6"}, {"$15", "$T7"}, {"$16", "$S0"}, {"$17", "$S1"}, {"$18", "$S2"}, {"$19", "$S3"}, {"$20", "$S4"}, {"$21", "$S5"}, {"$22", "$S6"}, {"$23", "$S7"}, {"$24", "$T8"}, {"$25", "$T9"}, {"$26", "$K0"}, {"$27", "$K1"}, {"$28", "$GP"}, {"$29", "$SP"}, {"$30", "$FP"}, {"$31", "$RA"}, {"$32", "$PC"}, {"$33", "$HI"}, {"$34", "$LO"}};
    public static final int NUM_REGS = 35;
    public static final int R_ZERO = 0;
    public static final int R_AT = 1;
    public static final int R_V0 = 2;
    public static final int R_V1 = 3;
    public static final int R_A0 = 4;
    public static final int R_A1 = 5;
    public static final int R_A2 = 6;
    public static final int R_A3 = 7;
    public static final int R_T0 = 8;
    public static final int R_T1 = 9;
    public static final int R_T2 = 10;
    public static final int R_T3 = 11;
    public static final int R_T4 = 12;
    public static final int R_T5 = 13;
    public static final int R_T6 = 14;
    public static final int R_T7 = 15;
    public static final int R_S0 = 16;
    public static final int R_S1 = 17;
    public static final int R_S2 = 18;
    public static final int R_S3 = 19;
    public static final int R_S4 = 20;
    public static final int R_S5 = 21;
    public static final int R_S6 = 22;
    public static final int R_S7 = 23;
    public static final int R_T8 = 24;
    public static final int R_T9 = 25;
    public static final int R_K0 = 26;
    public static final int R_K1 = 27;
    public static final int R_GP = 28;
    public static final int R_SP = 29;
    public static final int R_FP = 30;
    public static final int R_RA = 31;
    public static final int R_PC = 32;
    public static final int R_HI = 33;
    public static final int R_LO = 34;
    public int[] iaReg;

    public RegisterFile() {
        this.reset();
    }

    public void reset() {
        this.iaReg = new int[35];
        this.iaReg[29] = Integer.MAX_VALUE;
        this.iaReg[32] = 0x400000;
    }

    public int iGetReg(int n) {
        if (n == 0) {
            return 0;
        }
        return this.iaReg[n];
    }

    public void setReg(int n, int n2) {
        this.iaReg[n] = n2;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.iaReg.length - 1;
        while (n2 >= 0) {
            if (this.iaReg[n2] != 0) {
                string = string + REG_ID[n2] + "=" + Utility.sAsHexPadded(this.iaReg[n2], 8) + "\t";
                if (++n % 3 == 0) {
                    string = string + "\n";
                }
            }
            --n2;
        }
        return string;
    }

    public static int iRegLiteralToID(String string) {
        string = string.toUpperCase().trim();
        int n = 0;
        while (n < REG_ID.length) {
            int n2 = 0;
            while (n2 < REG_ID[n].length) {
                if (string.equals(REG_ID[n][n2])) {
                    return n;
                }
                ++n2;
            }
            ++n;
        }
        return -1;
    }
}

