/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.BreakpointList;
import JIMSCore.Command;
import JIMSCore.CommandResultBuffer;
import JIMSCore.GuardList;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import java.util.StringTokenizer;

public class CommandRemove
extends Command {
    private Simulator simulator;

    public CommandRemove(StringTokenizer stringTokenizer, Simulator simulator) {
        super(stringTokenizer);
        this.simulator = simulator;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        String string = this.nextToken();
        if (string.startsWith("B")) {
            string = this.nextToken();
            BreakpointList breakpointList = this.simulator.getBreakpointList();
            int n = 1;
            try {
                n = breakpointList.iRemoveBreakpoint(Command.iGetNumber(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != 0) {
                throw new InvalidCommandUseException("Invalid breakpoint index.");
            }
        } else if (string.startsWith("G")) {
            string = this.nextToken();
            GuardList guardList = this.simulator.getGuardList();
            int n = 1;
            try {
                n = guardList.iRemoveGuard(Command.iGetNumber(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != 0) {
                throw new InvalidCommandUseException("Invalid guard index.");
            }
        } else {
            throw new InvalidCommandUseException("Incorrect use of REMOVE command.");
        }
        commandResultBuffer.append("* REMOVE DONE");
    }
}

