/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.BreakpointList;
import JIMSCore.Command;
import JIMSCore.CommandResultBuffer;
import JIMSCore.GuardExpression;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import JIMSCore.Utility;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandList
extends Command {
    private Simulator simulator;

    public CommandList(StringTokenizer stringTokenizer, Simulator simulator) {
        super(stringTokenizer);
        this.simulator = simulator;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        String string = this.nextToken();
        if (string.startsWith("B")) {
            BreakpointList breakpointList = this.simulator.getBreakpointList();
            int[] nArray = breakpointList.iaGetBreakpoints();
            if (nArray == null) {
                commandResultBuffer.append("* LIST BREAKPOINT NONE");
            } else {
                int n = 0;
                while (n < nArray.length) {
                    commandResultBuffer.append("* LIST BREAKPOINT " + n + " " + Utility.sAsHexPadded(nArray[n], 8));
                    ++n;
                }
            }
        } else if (string.startsWith("G")) {
            Vector vector = this.simulator.getGuardList().vGetGuards();
            Enumeration enumeration = vector.elements();
            if (!enumeration.hasMoreElements()) {
                commandResultBuffer.append("* LIST GUARD NONE");
            } else {
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    GuardExpression guardExpression = (GuardExpression)enumeration.nextElement();
                    commandResultBuffer.append("* LIST GUARD " + n + " " + guardExpression);
                    ++n;
                }
            }
        } else {
            throw new InvalidCommandUseException("Incorrect use of LIST command.");
        }
        commandResultBuffer.append("* LIST DONE");
    }
}

