/*
 * Decompiled with CFR 0.152.
 */
package JIMSwingGUI;

import JIMSCore.CommandProcessor;
import JIMSCore.CommandResultBuffer;
import JIMSwingGUI.TopLevelWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class CommandConsoleWindow
extends JFrame
implements ActionListener {
    private TopLevelWindow parentWindow;
    private JPanel contentPane;
    private JPanel inputPane;
    private JPanel intermediatePane;
    private JTextField inputLine;
    private JButton inputButton;
    private JTextArea outputArea;
    private CommandProcessor commandProcessor;
    private CommandResultBuffer commandResultBuffer;

    public CommandConsoleWindow(TopLevelWindow topLevelWindow, CommandProcessor commandProcessor) {
        this.parentWindow = topLevelWindow;
        JLabel jLabel = new JLabel("Input: ");
        this.inputLine = new JTextField();
        this.inputButton = new JButton("Process command");
        this.getRootPane().setDefaultButton(this.inputButton);
        this.inputButton.addActionListener(this);
        this.outputArea = new JTextArea();
        this.outputArea.setEditable(false);
        this.outputArea.setFont(new Font("monospaced", 0, 12));
        this.outputArea.append("> ");
        JScrollPane jScrollPane = new JScrollPane(this.outputArea, 20, 30);
        jScrollPane.getViewport().setScrollMode(0);
        this.commandProcessor = commandProcessor;
        this.inputPane = new JPanel();
        this.inputPane.setLayout(new BoxLayout(this.inputPane, 0));
        this.inputPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.inputPane.add(jLabel);
        this.inputPane.add(this.inputLine);
        this.inputPane.add(this.inputButton);
        this.intermediatePane = new JPanel();
        this.intermediatePane.setLayout(new BorderLayout());
        this.intermediatePane.add((Component)this.inputPane, "North");
        this.intermediatePane.add((Component)jScrollPane, "Center");
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.intermediatePane, "Center");
        this.contentPane.add((Component)new JPanel(), "North");
        this.contentPane.add((Component)new JPanel(), "South");
        this.contentPane.add((Component)new JPanel(), "East");
        this.contentPane.add((Component)new JPanel(), "West");
        this.setContentPane(this.contentPane);
        this.pack();
        ((Component)this).setSize(topLevelWindow.getWidth() / 2, topLevelWindow.getHeight() / 2);
        this.setResizable(true);
        ((Component)this).setLocation(new Point(topLevelWindow.getX() + (topLevelWindow.getWidth() - this.getWidth()) / 2, topLevelWindow.getY() + (topLevelWindow.getHeight() - this.getHeight()) / 2));
        this.setTitle("JIMSwing Command Console");
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.inputButton) {
            String string = this.inputLine.getText();
            this.outputArea.append(string + "\n");
            this.inputLine.setText(null);
            this.commandResultBuffer = this.commandProcessor.processCommand(string);
            this.outputArea.append(this.commandResultBuffer.toString());
            this.outputArea.append("> ");
            this.validate();
            this.parentWindow.displayUpdate();
        }
    }
}

