/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.BreakpointList;
import JIMSCore.CheckpointBuffer;
import JIMSCore.GuardExpression;
import JIMSCore.GuardList;
import JIMSCore.InstructionDecodeBuffer;
import JIMSCore.InstructionDecoder;
import JIMSCore.InstructionExecuter;
import JIMSCore.SimulatorException;
import JIMSCore.State;
import JIMSCore.StateHistoryBuffer;
import JIMSCore.Utility;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Simulator {
    private static final int CHECKPOINT_CREATION_FACTOR = 5;
    private static final boolean ENABLE_HISTORY_RECORDING = true;
    public static final int EXCEPTION_NONE = -1;
    public static final int EXCEPTION_FETCH_ERROR = 0;
    public static final int EXCEPTION_DECODE_ERROR = 1;
    public static final int EXCEPTION_EXECUTE_ERROR = 2;
    public static final int EXCEPTION_FP_REQUIRED = 3;
    public static final int EXCEPTION_OUTPUT_WAITING = 4;
    public static final int EXCEPTION_INPUT_WAITING = 5;
    public static final int EXCEPTION_EXIT = 6;
    public static final int EXCEPTION_INVALID_OPCODE = 7;
    public static final int EXCEPTION_SYSCALL = 8;
    public static final int EXCEPTION_BREAK = 9;
    public static final int EXCEPTION_OVERFLOW = 10;
    public static final int EXCEPTION_FP_ERROR = 11;
    public static final int EXCEPTION_UNALIGNED_MEMORY_LOAD = 12;
    public static final int EXCEPTION_UNALIGNED_MEMORY_STORE = 13;
    public static final int NO_GUARD = -1;
    public static final int NO_BREAKPOINT = -1;
    private static final long MAX_CYCLE_INDEX = Long.MAX_VALUE;
    private static final String CHECKPOINT_GPR = "R";
    private static final String CHECKPOINT_CP0 = "0";
    private static final String CHECKPOINT_CP1 = "1";
    private static final String CHECKPOINT_MEM = "M";
    private State state;
    private Vector vBreakpoint;
    private Vector vStateHistory;
    private Vector vCheckpoint;
    private BreakpointList breakpointList;
    private int iBreakpointIndex;
    private GuardList guardList;
    private int iGuardIndex;
    private int iIR;
    private long lLastCheckPointCycleIndex;
    private long lCycleIndex;
    private StringBuffer sbOutputFromUndo;
    private CheckpointBuffer pendingCheckpoint;
    private int iStateHistoryByteSize;
    private int iExceptionCode;
    private InstructionDecodeBuffer decodeBuffer;
    private boolean bHistoryRecordingEnabled;
    private int iCheckpointCreationFactor;

    public Simulator(boolean bl, int n) {
        this.bHistoryRecordingEnabled = bl;
        this.iCheckpointCreationFactor = n;
        this.reset();
    }

    public Simulator() {
        this(true, 5);
    }

    public void reset() {
        this.state = new State();
        this.vBreakpoint = new Vector();
        if (this.bHistoryRecordingEnabled) {
            this.vStateHistory = new Vector();
            this.vCheckpoint = new Vector();
        } else {
            this.vStateHistory = null;
            this.vCheckpoint = null;
        }
        this.breakpointList = new BreakpointList();
        this.iBreakpointIndex = -1;
        this.guardList = new GuardList();
        this.iGuardIndex = -1;
        this.iIR = 0;
        this.lLastCheckPointCycleIndex = -1L;
        this.lCycleIndex = 0L;
        this.sbOutputFromUndo = null;
        this.pendingCheckpoint = null;
        this.iStateHistoryByteSize = 0;
        this.iExceptionCode = -1;
    }

    private void performCycle() throws SimulatorException {
        StateHistoryBuffer stateHistoryBuffer = null;
        if (this.bHistoryRecordingEnabled) {
            if (this.bTimeToMakeCheckpoint()) {
                this.makeCheckpoint();
                this.performCheckpointCulling();
            } else {
                if (this.vCheckpoint != null && this.vCheckpoint.size() > 0 && this.lLastCheckPointCycleIndex != -1L) {
                    this.lLastCheckPointCycleIndex = ((CheckpointBuffer)this.vCheckpoint.lastElement()).lGetCycleIndex();
                }
                if (this.lCycleIndex > this.lLastCheckPointCycleIndex) {
                    stateHistoryBuffer = new StateHistoryBuffer(this.lCycleIndex);
                }
            }
        }
        this.state.setStateHistoryBuffer(stateHistoryBuffer);
        this.IF();
        this.ID();
        this.EX();
        if (this.iExceptionCode != -1) {
            int n = -1;
            switch (this.iExceptionCode) {
                case 3: {
                    n = 11;
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    n = 10;
                    break;
                }
                case 8: {
                    this.iExceptionCode = 4;
                    if (this.state.getFlag(0) | this.state.getFlag(1) | this.state.getFlag(2) | this.state.getFlag(3)) break;
                    this.iExceptionCode = 5;
                    if (this.state.getFlag(4) | this.state.getFlag(5) | this.state.getFlag(6) | this.state.getFlag(7)) break;
                    this.iExceptionCode = 6;
                    if (this.state.getFlag(9)) break;
                    n = 8;
                    break;
                }
                case 9: {
                    n = 9;
                    break;
                }
                case 10: {
                    n = 12;
                    break;
                }
                case 11: {
                    n = 15;
                    break;
                }
                default: {
                    System.err.println("Internal Simulator Error (Exception Code == " + this.iExceptionCode + ")");
                }
            }
            if (n != -1) {
                int n2 = this.state.iGetRegister(32);
                this.state.setCP0Register(14, n2);
                int n3 = this.state.iGetCP0Register(13);
                this.state.setCP0Register(13, n3 |= (n <<= 2));
                this.state.setRegister(32, -2147483264);
            }
        }
        this.incrementCycleIndex();
        if (this.bHistoryRecordingEnabled && stateHistoryBuffer != null) {
            this.addToStateHistoryBuffer(stateHistoryBuffer);
            this.state.setStateHistoryBuffer(null);
        }
    }

    private void IF() {
        try {
            int n = this.state.iGetRegister(32);
            this.iIR = this.state.loadWord(n);
            this.state.setRegister(32, n + 4);
        }
        catch (Exception exception) {
            this.iExceptionCode = 0;
            System.err.println("CRITICAL ERROR IN FETCH: " + exception);
        }
    }

    private void ID() {
        InstructionDecoder instructionDecoder = new InstructionDecoder();
        this.decodeBuffer = instructionDecoder.decode(this.iIR);
        if (this.decodeBuffer == null) {
            this.iExceptionCode = 1;
            System.err.println("CRITICAL ERROR IN DECODE");
        }
    }

    private void EX() {
        InstructionExecuter instructionExecuter = new InstructionExecuter(this.state.getStateHistoryBuffer(), this);
        int n = instructionExecuter.iExecute(this.decodeBuffer);
        switch (n) {
            case 0: {
                break;
            }
            case -2: {
                this.iExceptionCode = 7;
                break;
            }
            case -4: {
                this.iExceptionCode = 3;
                break;
            }
            case -5: {
                this.iExceptionCode = 8;
                break;
            }
            case -6: {
                this.iExceptionCode = 9;
                break;
            }
            case -7: {
                this.iExceptionCode = 10;
                break;
            }
            case -8: {
                this.iExceptionCode = 11;
                break;
            }
            default: {
                this.iExceptionCode = 2;
                System.err.println("CRITICAL ERROR IN EXECUTE (UNEXPECTED VALUE " + n + ")");
            }
        }
    }

    private boolean bTimeToMakeCheckpoint() {
        boolean bl = false;
        int n = this.iGetNextCheckpointByteSize();
        if (this.iCheckpointCreationFactor * n <= this.iStateHistoryByteSize) {
            bl = true;
        }
        return bl;
    }

    public void makeCheckpoint() {
        CheckpointBuffer checkpointBuffer = this.pendingCheckpoint;
        this.pendingCheckpoint = null;
        if (checkpointBuffer == null) {
            checkpointBuffer = this.doCreateCheckpoint();
        }
        this.vCheckpoint.add(checkpointBuffer);
        this.clearStateHistoryBuffer();
        this.lLastCheckPointCycleIndex = this.lCycleIndex;
    }

    private void performCheckpointCulling() {
        int n;
        if (this.lCycleIndex <= 0L) {
            return;
        }
        int n2 = 0;
        int n3 = n = (int)(Math.log(this.lCycleIndex) / 0.6931471805599453);
        while (n3 > 0) {
            CheckpointBuffer checkpointBuffer;
            int n4;
            int n5 = (int)Math.pow(2.0, n3);
            int n6 = (int)this.lCycleIndex - n5;
            int n7 = (int)this.lCycleIndex - (n5 << 2) + 1;
            if (n7 < 0) {
                n7 = 0;
            }
            n5 = -1;
            while ((n4 = (int)(checkpointBuffer = (CheckpointBuffer)this.vCheckpoint.elementAt(n2)).lGetCycleIndex()) >= n7 && n4 <= n6) {
                if (n5 == -1) {
                    ++n2;
                    n5 = 0;
                    continue;
                }
                this.vCheckpoint.removeElementAt(n2);
            }
            --n3;
        }
    }

    public int iGetNextCheckpointByteSize() {
        int n = 0;
        n += 1152;
        return n += this.state.iModifiedMemoryCount * 3;
    }

    private CheckpointBuffer doCreateCheckpoint() {
        int n;
        int n2;
        CheckpointBuffer checkpointBuffer = new CheckpointBuffer(this.lCycleIndex);
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer("R ");
        int n3 = 0;
        while (n3 < 35) {
            n2 = this.state.iGetRegister(n3);
            if (n2 != 0) {
                stringBuffer.append(n3 + "=" + Utility.sAsHexPadded(n2, 8) + " ");
            }
            ++n3;
        }
        checkpointBuffer.addStateValue(stringBuffer.toString());
        stringBuffer = new StringBuffer("0 ");
        n2 = 0;
        while (n2 < 32) {
            n = this.state.iGetCP0Register(n2);
            if (n != 0) {
                stringBuffer.append(n2 + "=" + Utility.sAsHexPadded(n, 8) + " ");
            }
            ++n2;
        }
        checkpointBuffer.addStateValue(stringBuffer.toString());
        stringBuffer = new StringBuffer("1 ");
        n = 0;
        while (n < 34) {
            int n4 = this.state.iGetCP1Register(n);
            if (n4 != 0) {
                stringBuffer.append(n + "=" + Utility.sAsHexPadded(n4, 8) + " ");
            }
            ++n;
        }
        checkpointBuffer.addStateValue(stringBuffer.toString());
        Vector vector = this.state.vGetModifiedAddresses();
        if (vector != null && vector.size() > 0) {
            int n5;
            Enumeration enumeration = vector.elements();
            int n6 = n5 = ((Integer)enumeration.nextElement()).intValue();
            stringBuffer = new StringBuffer("M " + Utility.sAsHexPadded(n6, 8) + " ");
            while (true) {
                byte by = this.state.loadByte(n6);
                stringBuffer.append(Utility.sAsHexPadded(by, 2) + " ");
                if (!enumeration.hasMoreElements()) break;
                n5 = (Integer)enumeration.nextElement();
                if (n5 == ++n6) continue;
                checkpointBuffer.addStateValue(stringBuffer.toString());
                n6 = n5;
                stringBuffer = new StringBuffer("M " + Utility.sAsHexPadded(n6, 8) + " ");
            }
            checkpointBuffer.addStateValue(stringBuffer.toString());
        }
        return checkpointBuffer;
    }

    public int iLoadCodeString(String string) {
        int n;
        block8: {
            n = 0;
            try {
                switch (string.charAt(0)) {
                    case 'S': {
                        break;
                    }
                    case 'D': 
                    case 'T': {
                        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(2));
                        String string2 = stringTokenizer.nextToken();
                        int n2 = Utility.iHexStrToInt(string2);
                        while (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                            if (string2.charAt(0) != 'L') {
                                byte by = (byte)(Utility.iHexStrToInt(string2) & 0xFF);
                                this.state.storeByte(n2, by);
                                ++n2;
                                continue;
                            }
                            break block8;
                        }
                        break;
                    }
                    default: {
                        n = -1;
                    }
                }
            }
            catch (Exception exception) {
                n = -2;
            }
        }
        return n;
    }

    public int iPerformStep(long l) throws SimulatorException {
        int n;
        int n2;
        Object object;
        int n3 = 0;
        if (this.bHistoryRecordingEnabled && this.lCycleIndex == 0L && this.vCheckpoint.size() == 0) {
            this.makeCheckpoint();
        }
        if (this.state.getFlag(9)) {
            this.state.setFlag(9, false);
        }
        switch (this.iExceptionCode) {
            case -1: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new SimulatorException("Forced exception handling.");
            }
        }
        this.iExceptionCode = -1;
        if (this.iBreakpointIndex != -1) {
            this.iBreakpointIndex = -1;
        } else {
            object = this.breakpointList.iaGetBreakpoints();
            n2 = this.state.iGetRegister(32);
            if (object != null) {
                n = 0;
                while (n < ((Object)object).length) {
                    if (object[n] == n2) {
                        this.iBreakpointIndex = n;
                        break;
                    }
                    ++n;
                }
            }
        }
        if (this.iGuardIndex != -1) {
            this.iGuardIndex = -1;
        } else {
            object = this.guardList.vGetGuards();
            if (object != null) {
                Enumeration enumeration = ((Vector)object).elements();
                n = -1;
                while (enumeration.hasMoreElements()) {
                    GuardExpression guardExpression = (GuardExpression)enumeration.nextElement();
                    ++n;
                    if (!GuardExpression.isSatisfied(guardExpression)) continue;
                    this.iGuardIndex = n;
                    break;
                }
            }
        }
        if (this.iBreakpointIndex != -1) {
            return -1;
        }
        if (this.iGuardIndex != -1) {
            return -2;
        }
        do {
            try {
                this.performCycle();
                if (this.iExceptionCode == -1) continue;
                throw new SimulatorException("Forced exception handling.");
            }
            catch (SimulatorException simulatorException) {
                n2 = this.iExceptionCode;
                this.iExceptionCode = 4;
                if (this.state.getFlag(0)) {
                    throw new SimulatorException("Waiting to output integer.");
                }
                if (this.state.getFlag(1)) {
                    throw new SimulatorException("Waiting to output float.");
                }
                if (this.state.getFlag(2)) {
                    throw new SimulatorException("Waiting to output double.");
                }
                if (this.state.getFlag(3)) {
                    throw new SimulatorException("Waiting to output string.");
                }
                this.iExceptionCode = 5;
                if (this.state.getFlag(4)) {
                    throw new SimulatorException("Waiting to read integer.");
                }
                if (this.state.getFlag(5)) {
                    throw new SimulatorException("Waiting to read float.");
                }
                if (this.state.getFlag(6)) {
                    throw new SimulatorException("Waiting to read double.");
                }
                if (this.state.getFlag(7)) {
                    throw new SimulatorException("Waiting to read string.");
                }
                this.iExceptionCode = 6;
                if (this.state.getFlag(9)) {
                    throw new SimulatorException("Exit system call.");
                }
                this.iExceptionCode = n2;
                throw new SimulatorException(simulatorException.toString());
            }
            catch (Exception exception) {
                n3 = -3;
            }
        } while (n3 == 0 && --l > 0L);
        return n3;
    }

    public int iPerformUndo(long l) {
        int n = 0;
        if (!this.bHistoryRecordingEnabled) {
            return -1;
        }
        int n2 = this.vStateHistory.size();
        int n3 = this.vCheckpoint.size();
        this.sbOutputFromUndo = null;
        if (n2 == 0 && n3 == 0) {
            return -1;
        }
        long l2 = this.lCycleIndex - l;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (n2 == 0 || l > (long)n2) {
            if (l > (long)n2) {
                this.clearStateHistoryBuffer();
            }
            if (n3 > 0) {
                CheckpointBuffer checkpointBuffer = null;
                long l3 = -1L;
                try {
                    while ((l3 = (checkpointBuffer = (CheckpointBuffer)this.vCheckpoint.elementAt(n3 - 1)).lGetCycleIndex()) > l2) {
                        this.vCheckpoint.removeElementAt(n3 - 1);
                        if (--n3 > 0) continue;
                        this.state.reset();
                        checkpointBuffer = null;
                        break;
                    }
                    if (l3 == l2) {
                        this.vCheckpoint.removeElementAt(n3 - 1);
                        --n3;
                    }
                }
                catch (Exception exception) {
                    checkpointBuffer = null;
                }
                if (checkpointBuffer == null) {
                    return -1;
                }
                this.state.reset();
                this.lCycleIndex = l3;
                Vector vector = checkpointBuffer.vGetStateRecord();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    int n4 = this.iApplyCheckpointSetting(string);
                    if (n4 == 0) continue;
                    System.err.println("APPLY CHECKPOINT ERROR: " + n4);
                    return -3;
                }
            } else {
                this.state.reset();
            }
            this.iExceptionCode = -1;
            while (this.lCycleIndex < l2) {
                try {
                    int n5 = this.iPerformStep(l2 - this.lCycleIndex);
                    switch (n5) {
                        case 0: {
                            break;
                        }
                        case -1: {
                            break;
                        }
                        case -2: {
                            break;
                        }
                        default: {
                            throw new Exception();
                        }
                    }
                }
                catch (SimulatorException simulatorException) {
                    if (this.iExceptionCode == 4) {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (this.iReadOutput(stringBuffer) == 0) {
                            if (this.sbOutputFromUndo == null) {
                                this.sbOutputFromUndo = new StringBuffer();
                            }
                            this.sbOutputFromUndo.append((Object)stringBuffer);
                            continue;
                        }
                        return -6;
                    }
                    return -5;
                }
                catch (Exception exception) {
                    return -4;
                }
            }
        } else {
            do {
                StateHistoryBuffer stateHistoryBuffer = null;
                try {
                    stateHistoryBuffer = (StateHistoryBuffer)this.vStateHistory.elementAt(n2 - 1);
                    this.vStateHistory.removeElementAt(n2 - 1);
                    --n2;
                }
                catch (Exception exception) {
                    stateHistoryBuffer = null;
                }
                if (stateHistoryBuffer == null) {
                    return -1;
                }
                Vector vector = stateHistoryBuffer.vGetStateHistory();
                int n6 = vector.size() - 1;
                while (n6 >= 0) {
                    String string = (String)vector.elementAt(n6);
                    int n7 = this.iApplyStateSetting(string);
                    if (n7 != 0) {
                        System.err.println("APPLY STATE ERROR: " + n7);
                        return -2;
                    }
                    --n6;
                }
                this.lCycleIndex = stateHistoryBuffer.lGetCycleIndex();
                this.iStateHistoryByteSize -= stateHistoryBuffer.iGetSize();
            } while (this.lCycleIndex > l2);
            this.iExceptionCode = -1;
        }
        return n;
    }

    private int iApplyCheckpointSetting(String string) {
        int n = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith(CHECKPOINT_GPR)) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    int n2 = string2.indexOf(61);
                    int n3 = Integer.parseInt(string2.substring(0, n2));
                    int n4 = (int)Utility.IntegerLiteralToLong("0x" + string2.substring(n2 + 1));
                    this.state.setRegister(n3, n4);
                }
            } else if (string2.startsWith(CHECKPOINT_CP0)) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    int n5 = string2.indexOf(61);
                    int n6 = Integer.parseInt(string2.substring(0, n5));
                    int n7 = (int)Utility.IntegerLiteralToLong("0x" + string2.substring(n5 + 1));
                    this.state.setCP0Register(n6, n7);
                }
            } else if (string2.startsWith(CHECKPOINT_CP1)) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    int n8 = string2.indexOf(61);
                    int n9 = Integer.parseInt(string2.substring(0, n8));
                    int n10 = (int)Utility.IntegerLiteralToLong("0x" + string2.substring(n8 + 1));
                    this.state.setCP1Register(n9, n10);
                }
            } else if (string2.startsWith(CHECKPOINT_MEM)) {
                string2 = stringTokenizer.nextToken();
                int n11 = (int)Utility.IntegerLiteralToLong("0x" + string2);
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    int n12 = Integer.parseInt(string2, 16);
                    this.state.storeByte(n11, (byte)n12);
                    ++n11;
                }
            } else {
                n = -1;
            }
        }
        catch (Exception exception) {
            n = -2;
        }
        return n;
    }

    private int iApplyStateSetting(String string) {
        int n = 0;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith(CHECKPOINT_MEM)) {
                string2 = stringTokenizer.nextToken();
                int n2 = Utility.iHexStrToInt(string2);
                string2 = stringTokenizer.nextToken();
                int n3 = Integer.parseInt(string2, 16);
                this.state.storeByte(n2, (byte)n3);
            } else if (string2.startsWith(CHECKPOINT_GPR)) {
                string2 = stringTokenizer.nextToken();
                byte by = Byte.parseByte(string2);
                string2 = stringTokenizer.nextToken();
                int n4 = Utility.iHexStrToInt(string2);
                this.state.setRegister(by, n4);
            } else if (string2.startsWith(CHECKPOINT_CP0)) {
                string2 = stringTokenizer.nextToken();
                byte by = Byte.parseByte(string2);
                string2 = stringTokenizer.nextToken();
                int n5 = Utility.iHexStrToInt(string2);
                this.state.setCP0Register(by, n5);
            } else if (string2.startsWith(CHECKPOINT_CP1)) {
                string2 = stringTokenizer.nextToken();
                byte by = Byte.parseByte(string2);
                string2 = stringTokenizer.nextToken();
                int n6 = Utility.iHexStrToInt(string2);
                this.state.setCP1Register(by, n6);
            } else if (string2.startsWith("F")) {
                string2 = stringTokenizer.nextToken();
                int n7 = Integer.parseInt(string2);
                string2 = stringTokenizer.nextToken();
                boolean bl = string2.equals("T");
                this.state.setFlag(n7, bl);
            } else {
                n = -1;
            }
        }
        catch (Exception exception) {
            System.err.println("APPLY STATE ERROR: " + exception);
            n = -2;
        }
        return n;
    }

    public int iGetNumCheckpoints() {
        if (this.vCheckpoint == null) {
            return -1;
        }
        return this.vCheckpoint.size();
    }

    public int iGetNumStateChanges() {
        if (this.vStateHistory == null) {
            return -1;
        }
        return this.vStateHistory.size();
    }

    public int iGetStateHistoryByteSize() {
        return this.iStateHistoryByteSize;
    }

    public BreakpointList getBreakpointList() {
        if (this.breakpointList == null) {
            this.breakpointList = new BreakpointList();
        }
        return this.breakpointList;
    }

    public GuardList getGuardList() {
        if (this.guardList == null) {
            this.guardList = new GuardList();
        }
        return this.guardList;
    }

    public Vector vGetStateHistory() {
        return this.vStateHistory;
    }

    public Vector vGetCheckpoint() {
        return this.vCheckpoint;
    }

    public State getState() {
        return this.state;
    }

    public int iGetBreakpointIndex() {
        return this.iBreakpointIndex;
    }

    public int iGetGuardIndex() {
        return this.iGuardIndex;
    }

    public long lGetCycleIndex() {
        return this.lCycleIndex;
    }

    public int iGetExceptionCode() {
        return this.iExceptionCode;
    }

    public void writeHistoryLog(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        }
        catch (Exception exception) {
            System.err.println("Could not create history log: " + exception);
            return;
        }
        try {
            Object object;
            int n = 0;
            while (n < this.vCheckpoint.size()) {
                CheckpointBuffer checkpointBuffer = (CheckpointBuffer)this.vCheckpoint.elementAt(n);
                printWriter.write("CP@" + checkpointBuffer.lGetCycleIndex() + "\n");
                object = checkpointBuffer.vGetStateRecord().elements();
                while (object.hasMoreElements()) {
                    printWriter.write((String)object.nextElement() + "\n");
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.vStateHistory.size()) {
                object = (StateHistoryBuffer)this.vStateHistory.elementAt(n2);
                printWriter.write("C " + ((StateHistoryBuffer)object).lGetCycleIndex() + "\n");
                Enumeration enumeration = ((StateHistoryBuffer)object).vGetStateHistory().elements();
                while (enumeration.hasMoreElements()) {
                    printWriter.write((String)enumeration.nextElement() + "\n");
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("Error writing history log: " + exception);
        }
        try {
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println("Error closing history log: " + exception);
        }
    }

    public StringBuffer sbGetHistoryLog() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.vCheckpoint.size()) {
            CheckpointBuffer checkpointBuffer = (CheckpointBuffer)this.vCheckpoint.elementAt(n);
            stringBuffer.append("CP@" + checkpointBuffer.lGetCycleIndex() + "\n");
            object = checkpointBuffer.vGetStateRecord().elements();
            while (object.hasMoreElements()) {
                stringBuffer.append((String)object.nextElement() + "\n");
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.vStateHistory.size()) {
            object = (StateHistoryBuffer)this.vStateHistory.elementAt(n2);
            stringBuffer.append("C " + ((StateHistoryBuffer)object).lGetCycleIndex() + "\n");
            Enumeration enumeration = ((StateHistoryBuffer)object).vGetStateHistory().elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((String)enumeration.nextElement() + "\n");
            }
            ++n2;
        }
        return stringBuffer;
    }

    public StringBuffer sbGetOutputFromUndo() {
        StringBuffer stringBuffer = this.sbOutputFromUndo;
        this.sbOutputFromUndo = null;
        return stringBuffer;
    }

    private void addToStateHistoryBuffer(StateHistoryBuffer stateHistoryBuffer) {
        this.vStateHistory.add(stateHistoryBuffer);
        this.iStateHistoryByteSize += stateHistoryBuffer.iGetSize();
    }

    private void clearStateHistoryBuffer() {
        this.vStateHistory.clear();
        this.iStateHistoryByteSize = 0;
    }

    public boolean bHasFPA() {
        int n = this.state.getCoprocessor0().iGetReg(12);
        return Utility.bBitSet(n, 29, true);
    }

    private void incrementCycleIndex() {
        long l = this.lCycleIndex;
        if (++l == Long.MAX_VALUE) {
            l = 0L;
            this.vCheckpoint.clear();
            this.clearStateHistoryBuffer();
            this.lLastCheckPointCycleIndex = -1L;
        }
        this.lCycleIndex = l;
    }

    private void decrementCycleIndex() {
        long l = this.lCycleIndex;
        if (--l < 0L) {
            l = 0L;
        }
        this.lCycleIndex = l;
    }

    public int iWriteInput(String string) {
        int n = 0;
        try {
            if (this.state.getFlag(4)) {
                int n2 = (int)Utility.IntegerLiteralToLong(string);
                this.state.setRegister(2, n2);
                this.state.setFlag(4, false);
            } else if (this.state.getFlag(5)) {
                float f = Float.parseFloat(string);
                this.state.setCP1Register(0, Float.floatToIntBits(f));
                this.state.setFlag(5, false);
            } else if (this.state.getFlag(6)) {
                double d = Double.parseDouble(string);
                long l = Double.doubleToLongBits(d);
                int n3 = (int)((l & 0xFFFFFFFF00000000L) >>> 32);
                int n4 = (int)(l & 0xFFFFFFFFL);
                this.state.setCP1Register(0, n4);
                this.state.setCP1Register(1, n3);
                this.state.setFlag(6, false);
            } else if (this.state.getFlag(7)) {
                if (!string.equals("")) {
                    int n5;
                    int n6 = this.state.iGetRegister(5);
                    int n7 = n5 = this.state.iGetRegister(4);
                    int n8 = 0;
                    int n9 = -1;
                    while (true) {
                        char c = string.charAt(n8);
                        if (n9 != -1) {
                            switch (c) {
                                case '\\': {
                                    this.state.storeByte(n7, (byte)92);
                                    break;
                                }
                                case 'n': {
                                    this.state.storeByte(n7, (byte)10);
                                    break;
                                }
                                case 't': {
                                    this.state.storeByte(n7, (byte)9);
                                    break;
                                }
                                case 'r': {
                                    this.state.storeByte(n7, (byte)13);
                                    break;
                                }
                                case '0': {
                                    this.state.storeByte(n7, (byte)0);
                                    break;
                                }
                                case '\"': {
                                    this.state.storeByte(n7, (byte)34);
                                    break;
                                }
                            }
                            n9 = -1;
                        } else if (c == '\\') {
                            n9 = n8;
                        } else {
                            this.state.storeByte(n7, (byte)c);
                        }
                        if (n8 >= string.length() || n8 >= n6) break;
                        ++n8;
                        ++n7;
                    }
                    this.state.setFlag(7, false);
                }
            } else {
                n = -1;
            }
        }
        catch (Exception exception) {
            System.err.println("INPUT ERROR: " + exception);
            n = -2;
        }
        if (n == 0 && this.iExceptionCode == 5) {
            this.iExceptionCode = -1;
        }
        return n;
    }

    public int iReadOutput(StringBuffer stringBuffer) {
        int n = 0;
        if (stringBuffer == null) {
            return -3;
        }
        try {
            if (this.state.getFlag(0)) {
                int n2 = this.state.iGetRegister(4);
                stringBuffer.append("" + n2);
                this.state.setFlag(0, false);
            } else if (this.state.getFlag(1)) {
                int n3 = this.state.iGetCP1Register(12);
                float f = Float.intBitsToFloat(n3);
                stringBuffer.append("" + f);
                this.state.setFlag(1, false);
            } else if (this.state.getFlag(2)) {
                int n4 = this.state.iGetCP1Register(12);
                int n5 = this.state.iGetCP1Register(13);
                long l = (long)n5 << 32;
                double d = Double.longBitsToDouble(l |= (long)n4 & 0xFFFFFFFFL);
                stringBuffer.append("" + d);
                this.state.setFlag(2, false);
            } else if (this.state.getFlag(3)) {
                char c;
                int n6;
                int n7 = n6 = this.state.iGetRegister(4);
                while ((c = (char)this.state.loadByte(n7)) != '\u0000') {
                    stringBuffer.append(c);
                    ++n7;
                }
                this.state.setFlag(3, false);
            } else {
                n = -1;
            }
        }
        catch (Exception exception) {
            System.err.println("OUTPUT ERROR: " + exception);
            n = -2;
        }
        if (n == 0 && this.iExceptionCode == 4) {
            this.iExceptionCode = -1;
        }
        return n;
    }
}

