/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Command;
import JIMSCore.CommandResultBuffer;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import java.util.StringTokenizer;

public class CommandUndo
extends Command {
    public static final String ERR_NO_STATE_CHANGE = "ERR_NO_STATE_CHANGE";
    public static final String ERR_CRITICAL_ERROR = "ERR_CRITICAL_ERROR";
    private Simulator simulator;
    private StringBuffer sbOutput;

    public CommandUndo(StringTokenizer stringTokenizer, Simulator simulator) {
        super(stringTokenizer);
        this.simulator = simulator;
    }

    public void execute(CommandResultBuffer commandResultBuffer) throws InvalidCommandUseException {
        int n;
        int n2 = 1;
        String string = this.nextToken();
        if (string.length() > 0) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new InvalidCommandUseException("Unable to translate value of n specified.");
            }
            if (n2 < 1) {
                throw new InvalidCommandUseException("Value of n must be larger than 0.");
            }
        }
        if ((n = this.simulator.iPerformUndo(n2)) == 0) {
            commandResultBuffer.append("* UNDO OK");
            this.sbOutput = this.simulator.sbGetOutputFromUndo();
            if (this.sbOutput != null) {
                commandResultBuffer.append("* UNDO OUTPUT");
            }
        } else {
            switch (n) {
                case -1: {
                    commandResultBuffer.append("* UNDO ERR ERR_NO_STATE_CHANGE");
                    break;
                }
                case -5: {
                    commandResultBuffer.append("* UNDO EXCEPTION " + this.simulator.iGetExceptionCode());
                    break;
                }
                default: {
                    commandResultBuffer.append("* UNDO ERR ERR_CRITICAL_ERROR " + n);
                }
            }
        }
        commandResultBuffer.append("* UNDO DONE");
    }

    public StringBuffer sbGetOutput() {
        return this.sbOutput;
    }
}

