/*
 * Decompiled with CFR 0.152.
 */
package JIMSCore;

import JIMSCore.Command;
import JIMSCore.CommandAdd;
import JIMSCore.CommandCheckpoint;
import JIMSCore.CommandExit;
import JIMSCore.CommandGet;
import JIMSCore.CommandHelp;
import JIMSCore.CommandHistory;
import JIMSCore.CommandInput;
import JIMSCore.CommandList;
import JIMSCore.CommandLoad;
import JIMSCore.CommandOutput;
import JIMSCore.CommandRemove;
import JIMSCore.CommandReset;
import JIMSCore.CommandResultBuffer;
import JIMSCore.CommandRun;
import JIMSCore.CommandSet;
import JIMSCore.CommandStatus;
import JIMSCore.CommandStep;
import JIMSCore.CommandUndo;
import JIMSCore.InvalidCommandUseException;
import JIMSCore.Simulator;
import java.util.StringTokenizer;

public class CommandProcessor {
    private static final String[][] COMMAND_TABLE = new String[][]{{""}, {"ADD", "+"}, {"EXIT", "X", "QUIT"}, {"GET", "G", "DUMP"}, {"HELP", "H", "?"}, {"LIST", "I"}, {"LOAD", "L"}, {"REMOVE", "-"}, {"RESET"}, {"RUN"}, {"SET"}, {"STEP", "S"}, {"UNDO", "U"}, {"HISTORY", "HI"}, {"STATUS"}, {"INPUT", "IN"}, {"OUTPUT", "OUT"}, {"CHECKPOINT", "C", "CHECK"}};
    private Simulator simulator = null;
    private Command commandLastCommand = null;

    public void initializeSimulator() {
        this.simulator = new Simulator();
        this.simulator.reset();
    }

    public void terminateSimulator() {
        this.simulator = null;
    }

    public boolean bSimulatorAllocated() {
        return this.simulator != null;
    }

    public Command getLastCommand() {
        return this.commandLastCommand;
    }

    public long lGetCurrentCycle() {
        return this.simulator.lGetCycleIndex();
    }

    public CommandResultBuffer processCommand(String string) {
        this.commandLastCommand = null;
        Command command = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase().trim());
        String string2 = "";
        String string3 = "";
        try {
            string2 = stringTokenizer.nextToken();
            int n = -1;
            while (string.charAt(0) == ' ') {
                ++n;
            }
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            string3 = string.substring(string2.length() + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = -1;
        int n2 = -1;
        n = 0;
        while (n < COMMAND_TABLE.length) {
            int n3 = COMMAND_TABLE[n].length;
            n2 = 0;
            while (n2 < n3) {
                if (string2.equals(COMMAND_TABLE[n][n2])) break;
                ++n2;
            }
            if (n2 < COMMAND_TABLE[n].length) break;
            ++n;
        }
        switch (n) {
            case 0: {
                command = new Command();
                break;
            }
            case 1: {
                command = new CommandAdd(stringTokenizer, this.simulator);
                break;
            }
            case 2: {
                command = new CommandExit(this);
                break;
            }
            case 3: {
                command = new CommandGet(stringTokenizer, this.simulator);
                break;
            }
            case 4: {
                command = new CommandHelp();
                break;
            }
            case 5: {
                command = new CommandList(stringTokenizer, this.simulator);
                break;
            }
            case 6: {
                command = new CommandLoad(string3, this.simulator);
                break;
            }
            case 7: {
                command = new CommandRemove(stringTokenizer, this.simulator);
                break;
            }
            case 8: {
                command = new CommandReset(this);
                break;
            }
            case 9: {
                command = new CommandRun(this);
                break;
            }
            case 10: {
                command = new CommandSet(stringTokenizer, this.simulator);
                break;
            }
            case 11: {
                command = new CommandStep(stringTokenizer, this.simulator);
                break;
            }
            case 12: {
                command = new CommandUndo(stringTokenizer, this.simulator);
                break;
            }
            case 13: {
                command = new CommandHistory(stringTokenizer, this.simulator);
                break;
            }
            case 14: {
                command = new CommandStatus(stringTokenizer, this.simulator);
                break;
            }
            case 15: {
                command = new CommandInput(stringTokenizer, string3, this.simulator);
                break;
            }
            case 16: {
                command = new CommandOutput(stringTokenizer, this.simulator);
                break;
            }
            case 17: {
                command = new CommandCheckpoint(this.simulator);
            }
        }
        CommandResultBuffer commandResultBuffer = null;
        try {
            commandResultBuffer = new CommandResultBuffer();
            command.execute(commandResultBuffer);
            this.commandLastCommand = command;
        }
        catch (InvalidCommandUseException invalidCommandUseException) {
            commandResultBuffer = new CommandResultBuffer();
            commandResultBuffer.append("EXCEPTION " + invalidCommandUseException.toString());
        }
        catch (Exception exception) {
            commandResultBuffer = new CommandResultBuffer();
            commandResultBuffer.append("UNKNOWN_COMMAND " + string2 + " " + exception);
        }
        return commandResultBuffer;
    }
}

